/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.CallChunkBlockBuilder;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainMethodCallsBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myBlockWrap;
    private final Alignment myBlockAlignment;
    private final Indent myBlockIndent;
    private final FormattingMode myFormattingMode;
    private static final int MANY_METHOD_CALLS_FACTOR = 3;

    ChainMethodCallsBlockBuilder(Alignment alignment, Wrap wrap, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(0);
        }
        this.myBlockWrap = wrap;
        this.myBlockAlignment = alignment;
        this.myBlockIndent = indent;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    public Block build(List<? extends ASTNode> nodes) {
        List<Block> blocks = this.buildBlocksFrom(nodes);
        Indent indent = this.myBlockIndent != null ? this.myBlockIndent : Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        return new SyntheticCodeBlock(blocks, this.myBlockAlignment, this.mySettings, this.myJavaSettings, indent, this.myBlockWrap);
    }

    private List<Block> buildBlocksFrom(List<? extends ASTNode> nodes) {
        List<ChainedCallChunk> methodCall = ChainMethodCallsBlockBuilder.splitMethodCallOnChunksByDots(nodes, this.mySettings);
        Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
        Wrap builderMethodWrap = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
        Alignment chainedCallsAlignment = null;
        ArrayList<Block> blocks = new ArrayList<Block>();
        int commonIndentSize = this.mySettings.KEEP_BUILDER_METHODS_INDENTS ? this.getCommonIndentSize(methodCall) : -1;
        CallChunkBlockBuilder builder = new CallChunkBlockBuilder(this.mySettings, this.myJavaSettings, this.myFormattingMode);
        for (int i = 0; i < methodCall.size(); ++i) {
            ChainedCallChunk currentCallChunk = methodCall.get(i);
            if (ChainMethodCallsBlockBuilder.isMethodCall(currentCallChunk) && !ChainMethodCallsBlockBuilder.isBuilderMethod(currentCallChunk, this.mySettings) || ChainMethodCallsBlockBuilder.isComment(currentCallChunk)) {
                if (chainedCallsAlignment == null) {
                    chainedCallsAlignment = this.createCallChunkAlignment(i, methodCall);
                }
            } else {
                chainedCallsAlignment = null;
            }
            Wrap currWrap = ChainMethodCallsBlockBuilder.isMethodCall(currentCallChunk) && this.canWrap(i, methodCall) ? (ChainMethodCallsBlockBuilder.isBuilderMethod(currentCallChunk, this.mySettings) ? builderMethodWrap : wrap) : null;
            blocks.add(builder.create(currentCallChunk.nodes, currWrap, chainedCallsAlignment, ChainMethodCallsBlockBuilder.getRelativeIndentSize(commonIndentSize, currentCallChunk)));
        }
        return blocks;
    }

    private int getCommonIndentSize(@NotNull List<ChainedCallChunk> chunks) {
        if (chunks == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(1);
        }
        String commonIndent = null;
        for (ChainedCallChunk chunk : chunks) {
            String currIndent;
            if (!ChainMethodCallsBlockBuilder.isMethodCall(chunk) || !ChainMethodCallsBlockBuilder.isBuilderMethod(chunk, this.mySettings) || (currIndent = chunk.getIndentString()) == null) continue;
            if (commonIndent == null) {
                commonIndent = currIndent;
                continue;
            }
            if (!commonIndent.startsWith(currIndent)) continue;
            commonIndent = currIndent;
        }
        return commonIndent != null ? commonIndent.length() : -1;
    }

    private static int getRelativeIndentSize(int commonIndentSize, @NotNull ChainedCallChunk chunk) {
        String indentString;
        if (chunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(2);
        }
        if (commonIndentSize >= 0 && (indentString = chunk.getIndentString()) != null) {
            return Math.max(indentString.length() - commonIndentSize, 0);
        }
        return -1;
    }

    private static boolean isComment(ChainedCallChunk chunk) {
        List<ASTNode> nodes = chunk.nodes;
        if (nodes.size() == 1) {
            return nodes.get(0).getPsi() instanceof PsiComment;
        }
        return false;
    }

    private static boolean isBuilderMethod(@NotNull ChainedCallChunk chunk, CommonCodeStyleSettings settings) {
        String identifier;
        if (chunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(3);
        }
        return (identifier = chunk.getIdentifier()) != null && settings.isBuilderMethod(identifier);
    }

    private boolean canWrap(int chunkIndex, @NotNull List<? extends ChainedCallChunk> methodCall) {
        boolean isFirst;
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(4);
        }
        if (chunkIndex <= 0) {
            return false;
        }
        ChainedCallChunk prev = methodCall.get(chunkIndex - 1);
        boolean bl = isFirst = !ChainMethodCallsBlockBuilder.isMethodCall(prev) || chunkIndex == 1;
        if (isFirst) {
            if (this.mySettings.WRAP_FIRST_METHOD_IN_CALL_CHAIN) {
                ChainedCallChunk next = chunkIndex + 1 < methodCall.size() ? methodCall.get(chunkIndex + 1) : null;
                return next != null && ChainMethodCallsBlockBuilder.isMethodCall(next);
            }
            return false;
        }
        return true;
    }

    private boolean shouldAlignMethod(ChainedCallChunk currentMethodChunk, List<ChainedCallChunk> methodCall) {
        return this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && !currentMethodChunk.isEmpty() && !ChainMethodCallsBlockBuilder.chunkIsFirstInChainMethodCall(currentMethodChunk, methodCall);
    }

    private static boolean chunkIsFirstInChainMethodCall(@NotNull ChainedCallChunk callChunk, @NotNull List<ChainedCallChunk> methodCall) {
        if (callChunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(5);
        }
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(6);
        }
        return !methodCall.isEmpty() && callChunk == methodCall.get(0);
    }

    @NotNull
    private static List<ChainedCallChunk> splitMethodCallOnChunksByDots(@NotNull List<? extends ASTNode> nodes, CommonCodeStyleSettings settings) {
        if (nodes == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(7);
        }
        ArrayList<ChainedCallChunk> result = new ArrayList<ChainedCallChunk>();
        ArrayList<Object> current = new ArrayList<ASTNode>();
        for (ASTNode aSTNode : nodes) {
            if (JavaFormatterUtil.isStartOfCallChunk(settings, aSTNode) || aSTNode.getPsi() instanceof PsiComment) {
                if (!current.isEmpty()) {
                    result.add(new ChainedCallChunk(current));
                }
                current = new ArrayList();
            }
            current.add(aSTNode);
        }
        if (!current.isEmpty()) {
            result.add(new ChainedCallChunk(current));
        }
        ArrayList<ChainedCallChunk> arrayList = result;
        if (arrayList == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private Alignment createCallChunkAlignment(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        ChainedCallChunk current;
        if (methodCall == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(9);
        }
        return this.shouldAlignMethod(current = methodCall.get(chunkIndex), methodCall) ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS, null) : null;
    }

    private static boolean isMethodCall(@NotNull ChainedCallChunk callChunk) {
        if (callChunk == null) {
            ChainMethodCallsBlockBuilder.$$$reportNull$$$0(10);
        }
        Iterator<ASTNode> iter = callChunk.nodes.iterator();
        while (iter.hasNext()) {
            ASTNode node = iter.next();
            if (node.getElementType() != JavaTokenType.IDENTIFIER) continue;
            node = iter.hasNext() ? iter.next() : null;
            return node != null && node.getElementType() == JavaElementType.EXPRESSION_LIST;
        }
        return false;
    }

    public static boolean isLongCallChain(List<ASTNode> nodes, CommonCodeStyleSettings settings) {
        List<ChainedCallChunk> chunks = ChainMethodCallsBlockBuilder.splitMethodCallOnChunksByDots(nodes, settings);
        int methodCallCount = 0;
        for (ChainedCallChunk chunk : chunks) {
            if (!ChainMethodCallsBlockBuilder.isMethodCall(chunk) || ChainMethodCallsBlockBuilder.isBuilderMethod(chunk, settings) || ChainMethodCallsBlockBuilder.isComment(chunk)) continue;
            ++methodCallCount;
        }
        return methodCallCount >= 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callChunk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMethodCallOnChunksByDots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIndentSize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeIndentSize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBuilderMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canWrap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chunkIsFirstInChainMethodCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitMethodCallOnChunksByDots";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCallChunkAlignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMethodCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private record ChainedCallChunk(@NotNull List<ASTNode> nodes) {
        @NotNull
        private final List<ASTNode> nodes;

        private ChainedCallChunk(@NotNull List<ASTNode> nodes) {
            if (nodes == null) {
                ChainedCallChunk.$$$reportNull$$$0(0);
            }
        }

        boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        @Nullable
        private String getIdentifier() {
            return (String)ObjectUtils.doIfNotNull((Object)((ASTNode)ContainerUtil.find(this.nodes, node -> node.getElementType() == JavaTokenType.IDENTIFIER)), node -> node.getText());
        }

        @Nullable
        private String getIndentString() {
            CharSequence whitespace;
            int lineStart;
            ASTNode prev;
            if (!this.nodes.isEmpty() && (prev = this.nodes.get(0).getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace && prev.textContains('\n') && (lineStart = CharArrayUtil.lastIndexOf((CharSequence)(whitespace = prev.getChars()), (String)"\n", (int)(whitespace.length() - 1))) >= 0) {
                return whitespace.subSequence(lineStart + 1, whitespace.length()).toString();
            }
            return null;
        }

        @NotNull
        public List<ASTNode> nodes() {
            List<ASTNode> list = this.nodes;
            if (list == null) {
                ChainedCallChunk.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder$ChainedCallChunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/formatter/java/ChainMethodCallsBlockBuilder$ChainedCallChunk";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

