/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance(BaseExternalAnnotationsManager.class);
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final Map<Object, List<PsiFile>> myExternalAnnotationsCache;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final Map<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<Object, AnnotationData> cache;
    private final CharTableImpl charTable;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        this.myExternalAnnotationsCache = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        this.myAnnotationDataCache = ContainerUtil.createWeakKeyWeakValueMap();
        this.myAnnotationFileToDataAndModStampCache = CollectionFactory.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        return PsiFormatUtil.getExternalName(listOwner, false, Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        return this.hasAnyAnnotationsRoots();
    }

    @Override
    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Override
    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<PsiAnnotation> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(5);
        }
        return (result = this.findExternalAnnotations(listOwner, annotationFQN)).isEmpty() ? null : result.get(0);
    }

    @Override
    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(6);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return this.filterAnnotations(result, annotationFQN);
    }

    @Override
    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationFQNs) {
        List<AnnotationData> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
        if (annotationFQNs == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(9);
        }
        if ((result = this.collectExternalAnnotations(listOwner)).isEmpty()) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(10);
            }
            return list;
        }
        SmartList annotations = new SmartList();
        for (AnnotationData data : result) {
            if (!data.hasNoTypePath() || !annotationFQNs.contains(data.annotationClassFqName)) continue;
            annotations.add((Object)data.getAnnotation(this));
        }
        SmartList smartList = annotations;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @Override
    @NotNull
    public @NotNull PsiAnnotation @NotNull [] findExternalTypeAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String typePath) {
        List<AnnotationData> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(12);
        }
        if (typePath == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(13);
        }
        if ((result = this.collectExternalAnnotations(listOwner)).isEmpty()) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(14);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])((StreamEx)StreamEx.of(result).filter(data -> typePath.equals(((AnnotationData)data).typePath))).map(data -> data.getAnnotation(this)).toArray((Object[])PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(15);
        }
        return psiAnnotationArray;
    }

    @Override
    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(16);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(17);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return this.filterAnnotations(result, annotationFQN);
    }

    @NotNull
    private List<PsiAnnotation> filterAnnotations(@NotNull List<AnnotationData> result, @NotNull String annotationFQN) {
        if (result == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(18);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(19);
        }
        SmartList annotations = new SmartList();
        for (AnnotationData data : result) {
            if (!data.hasNoTypePath() || !data.annotationClassFqName.equals(annotationFQN)) continue;
            PsiAnnotation annotation = data.getAnnotation(this);
            annotations.add((Object)annotation);
        }
        SmartList smartList = annotations;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(21);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return ((StreamEx)StreamEx.of(result).filter(AnnotationData::hasNoTypePath)).map(data -> data.getAnnotation(this)).toList();
    }

    @Override
    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(22);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(23);
        }
        return BaseExternalAnnotationsManager.findByFQN(map2 = this.doCollect(listOwner, true), annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        if (map2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(24);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(25);
        }
        return (AnnotationData)ContainerUtil.find(map2, data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN));
    }

    @Override
    @NotNull
    public @NotNull PsiAnnotation @NotNull [] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(26);
        }
        PsiAnnotation[] psiAnnotationArray = (result = this.collectExternalAnnotations(listOwner)).isEmpty() ? PsiAnnotation.EMPTY_ARRAY : (PsiAnnotation[])((StreamEx)StreamEx.of(result).filter(data -> ((AnnotationData)data).typePath == null)).map(data -> data.getAnnotation(this)).toArray((Object[])PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(27);
        }
        return psiAnnotationArray;
    }

    @NotNull
    private List<AnnotationData> collectDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        List<PsiFile> annotationsFiles;
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(28);
        }
        if ((annotationsFiles = this.findExternalAnnotationsFiles(aClass)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(29);
            }
            return list;
        }
        String defCtrExternalName = BaseExternalAnnotationsManager.getExternalName(aClass) + " " + aClass.getName() + "()";
        return this.collectExternalAnnotations(defCtrExternalName, () -> this.doCollect(defCtrExternalName, annotationsFiles, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(30);
        }
        return this.collectExternalAnnotations(listOwner, () -> this.doCollect(listOwner, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull Object cacheKey, @NotNull Supplier<? extends List<AnnotationData>> dataSupplier) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (cacheKey == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(31);
        }
        if (dataSupplier == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(32);
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list = Collections.emptyList();
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(33);
            }
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(cacheKey)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list = cached;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(34);
            }
            return list;
        } while (!this.cache.replace(cacheKey, (Collection)cached, computed = dataSupplier.get()));
        cached = computed;
        List<AnnotationData> list = cached;
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(35);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(36);
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data);
        if (interned == null) {
            this.myAnnotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(37);
        return annotationData;
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(38);
        }
        Pair<MostlySingularMultiMap<String, AnnotationData>, Long> cached = this.myAnnotationFileToDataAndModStampCache.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(39);
            }
            return mostlySingularMultiMap;
        }
        MostlySingularMultiMap<String, AnnotationData> result = BaseExternalAnnotationsManager.loadData(file.getViewProvider().getVirtualFile(), file.getViewProvider().getContents(), this);
        this.myAnnotationFileToDataAndModStampCache.put(file, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)Pair.create(result, (Object)fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result;
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(40);
        }
        return mostlySingularMultiMap;
    }

    @NotNull
    public static MostlySingularMultiMap<String, AnnotationData> loadData(@NotNull VirtualFile virtualFile, @NotNull CharSequence fileText, @Nullable BaseExternalAnnotationsManager externalAnnotationsManager) {
        if (virtualFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(41);
        }
        if (fileText == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(42);
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(virtualFile, externalAnnotationsManager);
        try {
            SAXParser saxParser = Holder.FACTORY.newSAXParser();
            saxParser.parse(new InputSource((Reader)new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(fileText))), (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            if (externalAnnotationsManager != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                externalAnnotationsManager.reportXmlParseError(virtualFile, e);
            } else {
                LOG.error(virtualFile.getPath(), (Throwable)e);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(virtualFile.getPath(), (Throwable)e);
        }
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = handler.getResult();
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(43);
        }
        return mostlySingularMultiMap;
    }

    protected void reportXmlParseError(@NotNull VirtualFile file, @NotNull SAXParseException exception) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(44);
        }
        if (exception == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(45);
        }
        LOG.error(file.getPath(), (Throwable)exception);
    }

    protected void duplicateError(@NotNull VirtualFile virtualFile, @NotNull String externalName, @NotNull String text) {
        if (virtualFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(46);
        }
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(47);
        }
        if (text == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(48);
        }
        LOG.error(text + "; for signature: '" + externalName + "' in the " + virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(49);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = this.charTable.doIntern((CharSequence)annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(50);
        return string;
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<PsiFile> files;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(51);
        }
        if ((files = this.findExternalAnnotationsFiles(listOwner)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(52);
            }
            return list;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner);
        if (externalName == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(53);
            }
            return list;
        }
        return this.doCollect(externalName, files, onlyWritable);
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull String externalName, @NotNull List<? extends PsiFile> annotationsFiles, boolean onlyWritable) {
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(54);
        }
        if (annotationsFiles == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(55);
        }
        SmartList result = new SmartList();
        for (PsiFile psiFile : annotationsFiles) {
            if (!psiFile.isValid() || onlyWritable && !psiFile.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(psiFile);
            ContainerUtil.addAll((Collection)result, (Iterable)fileData.get((Object)externalName));
        }
        if (result.isEmpty()) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(56);
            }
            return list;
        }
        result.trimToSize();
        SmartList smartList = result;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(57);
        }
        return smartList;
    }

    @Override
    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(58);
        }
        if (listOwner instanceof PsiPackage) {
            String packageName = ((PsiPackage)listOwner).getQualifiedName();
            Function<PsiPackage, List> roots = pack -> Arrays.stream(pack.getDirectories()).flatMap(dir -> this.getExternalAnnotationsRoots(dir.getVirtualFile()).stream()).distinct().collect(Collectors.toList());
            return this.findExternalAnnotationsFiles(packageName, (PsiPackage)listOwner, roots);
        }
        PsiFile containingFile = PsiUtil.preferCompiledElement(listOwner).getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.findExternalAnnotationsFiles(((PsiClassOwner)containingFile).getPackageName(), virtualFile, f -> this.getExternalAnnotationsRoots((VirtualFile)f));
    }

    private <T> List<PsiFile> findExternalAnnotationsFiles(String packageName, @NotNull T key, @NotNull Function<? super T, ? extends List<VirtualFile>> rootGetter) {
        List<PsiFile> files;
        if (key == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(59);
        }
        if (rootGetter == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(60);
        }
        if ((files = this.myExternalAnnotationsCache.get(key)) == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (PsiFile psiFile : files) {
                if (psiFile.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        HashSet<PsiFile> possibleAnnotationXmls = new HashSet<PsiFile>();
        String relativePath = packageName.replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : rootGetter.apply(key)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(key, NULL_LIST);
            return null;
        }
        ArrayList<PsiFile> arrayList = new ArrayList<PsiFile>(possibleAnnotationXmls);
        arrayList.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(key, arrayList);
        return arrayList;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(61);
        }
        if (!BaseExternalAnnotationsManager.hasInvalidAttribute(invalidXml)) {
            CharSequence charSequence = invalidXml;
            if (charSequence == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(62);
            }
            return charSequence;
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(63);
        }
        return stringBuilder;
    }

    private static boolean hasInvalidAttribute(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(64);
        }
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                return true;
            }
            if (inAttribute && c == '>') {
                return true;
            }
            if (c != '\"' && c != '\'') continue;
            inAttribute = !inAttribute;
        }
        return false;
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, PsiNameValuePair @Nullable [] value) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(65);
        }
        if (annotationFQName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(66);
        }
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(67);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(68);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(69);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, PsiNameValuePair @Nullable [] value) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(70);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(71);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlaceNoUi(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(72);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(73);
        }
        throw new UnsupportedOperationException();
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(74);
        }
        annotation.putUserData(EXTERNAL_ANNO_MARKER, Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(75);
        }
        JavaParserUtil.ParserWrapper ANNOTATION = (builder, level) -> new JavaParser(level).getDeclarationParser().parseAnnotation(builder);
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myPsiManager, (TreeElement)new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, (CharTable)this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(76);
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 63: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 63: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 22: 
            case 26: 
            case 30: 
            case 51: 
            case 58: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 7: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 49: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 63: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePath";
                break;
            }
            case 16: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSupplier";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 48: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsFiles";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidXml";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 10: 
            case 11: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalAnnotations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalTypeAnnotations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAnnotations";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExternalAnnotations";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationData";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromFile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 52: 
            case 53: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollect";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAttributes";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExternalName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotations";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 63: 
            case 76: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findExternalTypeAnnotations";
                break;
            }
            case 16: 
            case 17: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultConstructorExternalAnnotations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterAnnotations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotationWritable";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findByFQN";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectExternalAnnotations";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationData";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromFile";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "reportXmlParseError";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 51: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "doCollect";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsFiles";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "escapeAttributes";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidAttribute";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlaceNoUi";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "markAsExternalAnnotation";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 50: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 63: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class AnnotationData {
        @NotNull
        private final String annotationClassFqName;
        @NotNull
        private final String annotationParameters;
        @Nullable
        private final String typePath;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters, @Nullable String typePath) {
            if (fqn == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters;
            this.typePath = typePath;
        }

        public boolean hasNoTypePath() {
            return this.typePath == null;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            PsiAnnotation a;
            if (context == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            if ((a = this.myAnnotation) == null) {
                String text = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context.createAnnotationFromText(text);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                AnnotationData.$$$reportNull$$$0(3);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters) && Objects.equals(this.typePath, data.typePath);
        }

        public int hashCode() {
            int result = this.annotationClassFqName.hashCode();
            result = 31 * result + this.annotationParameters.hashCode();
            result = 31 * result + Objects.hashCode(this.typePath);
            return result;
        }

        @Nullable
        public String getTypePath() {
            return this.typePath;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotation";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData;
        @NotNull
        private final VirtualFile myFile;
        private final BaseExternalAnnotationsManager myExternalAnnotationsManager;
        private String myExternalName;
        private String myAnnotationFqn;
        private String myTypePath;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(@NotNull VirtualFile file, @Nullable BaseExternalAnnotationsManager manager) {
            if (file == null) {
                DataParsingSaxHandler.$$$reportNull$$$0(0);
            }
            this.myData = new MostlySingularMultiMap();
            this.myFile = file;
            this.myExternalAnnotationsManager = manager;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
                this.myTypePath = null;
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myTypePath = attributes.getValue("typePath");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            } else if (!"root".equals(qName)) {
                LOG.error("Unknown element name: " + qName + " in " + this.myFile.getPath());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("item".equals(qName)) {
                this.myExternalName = null;
                this.myTypePath = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                for (AnnotationData existingData : this.myData.get((Object)this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn) || !Objects.equals(this.myTypePath, existingData.typePath) || this.myExternalAnnotationsManager == null) continue;
                    String error = "Duplicate annotation '" + this.myAnnotationFqn + "'" + (this.myTypePath == null ? "" : " for type path '" + this.myTypePath + "'");
                    this.myExternalAnnotationsManager.duplicateError(this.myFile, this.myExternalName, error);
                }
                String argumentsString = this.myArguments.length() == 0 ? "" : (this.myExternalAnnotationsManager == null ? this.myArguments.toString() : this.myExternalAnnotationsManager.intern(this.myArguments.toString()));
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString, this.myTypePath);
                this.myData.add((Object)this.myExternalName, (Object)(this.myExternalAnnotationsManager == null ? data : this.myExternalAnnotationsManager.internAnnotationData(data)));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        @NotNull
        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                MostlySingularMultiMap mostlySingularMultiMap = MostlySingularMultiMap.emptyMap();
                if (mostlySingularMultiMap == null) {
                    DataParsingSaxHandler.$$$reportNull$$$0(1);
                }
                return mostlySingularMultiMap;
            }
            this.myData.compact();
            MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = this.myData;
            if (mostlySingularMultiMap == null) {
                DataParsingSaxHandler.$$$reportNull$$$0(2);
            }
            return mostlySingularMultiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$DataParsingSaxHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$DataParsingSaxHandler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Holder {
        public static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    }
}

