/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.strikethrough.internal;

import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StrikethroughNodeRenderer
implements NodeRenderer {
    private final String strikethroughStyleHtmlOpen;
    private final String strikethroughStyleHtmlClose;
    private final String subscriptStyleHtmlOpen;
    private final String subscriptStyleHtmlClose;

    public StrikethroughNodeRenderer(DataHolder options) {
        this.strikethroughStyleHtmlOpen = StrikethroughSubscriptExtension.STRIKETHROUGH_STYLE_HTML_OPEN.get(options);
        this.strikethroughStyleHtmlClose = StrikethroughSubscriptExtension.STRIKETHROUGH_STYLE_HTML_CLOSE.get(options);
        this.subscriptStyleHtmlOpen = StrikethroughSubscriptExtension.SUBSCRIPT_STYLE_HTML_OPEN.get(options);
        this.subscriptStyleHtmlClose = StrikethroughSubscriptExtension.SUBSCRIPT_STYLE_HTML_CLOSE.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<Strikethrough>(Strikethrough.class, this::render));
        set.add(new NodeRenderingHandler<Subscript>(Subscript.class, this::render));
        return set;
    }

    private void render(Strikethrough node, NodeRendererContext context, HtmlWriter html) {
        if (this.strikethroughStyleHtmlOpen == null || this.strikethroughStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("del");
            } else {
                html.srcPos(node.getText()).withAttr().tag("del");
            }
            context.renderChildren(node);
            html.tag("/del");
        } else {
            html.raw(this.strikethroughStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(this.strikethroughStyleHtmlClose);
        }
    }

    private void render(Subscript node, NodeRendererContext context, HtmlWriter html) {
        if (this.subscriptStyleHtmlOpen == null || this.subscriptStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("sub");
            } else {
                html.srcPos(node.getText()).withAttr().tag("sub");
            }
            context.renderChildren(node);
            html.tag("/sub");
        } else {
            html.raw(this.subscriptStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(this.subscriptStyleHtmlClose);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new StrikethroughNodeRenderer(options);
        }
    }
}

