/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.GenericListeningConnector;
import com.jetbrains.jdi.SocketTransportService;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.util.Map;

public class SocketListeningConnector
extends GenericListeningConnector {
    static final String ARG_PORT = "port";
    static final String ARG_LOCALADDR = "localAddress";

    public SocketListeningConnector() {
        super(new SocketTransportService());
        this.addIntegerArgument(ARG_PORT, this.getString("socket_listening.port.label"), this.getString("socket_listening.port"), "", false, 0, Integer.MAX_VALUE);
        this.addStringArgument(ARG_LOCALADDR, this.getString("socket_listening.localaddr.label"), this.getString("socket_listening.localaddr"), "", false);
        this.transport = () -> "dt_socket";
    }

    @Override
    public String startListening(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String port = this.argument(ARG_PORT, args).value();
        Object localaddr = this.argument(ARG_LOCALADDR, args).value();
        if (port.length() == 0) {
            port = "0";
        }
        localaddr = ((String)localaddr).length() > 0 ? (String)localaddr + ":" + port : port;
        return super.startListening((String)localaddr, args);
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.SocketListen");
    }

    @Override
    public String description() {
        return this.getString("socket_listening.description");
    }

    @Override
    protected void updateArgumentMapIfRequired(Map<String, ? extends Connector.Argument> args, TransportService.ListenKey listener) {
        String[] address;
        if (this.isWildcardPort(args) && (address = listener.address().split(":")).length > 1) {
            args.get(ARG_PORT).setValue(address[address.length - 1]);
        }
    }

    private boolean isWildcardPort(Map<String, ? extends Connector.Argument> args) {
        String port = args.get(ARG_PORT).value();
        return port.isEmpty() || Integer.parseInt(port) == 0;
    }
}

