/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyPackageVersion;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c2\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementVersionSpecImpl;", "Lcom/jetbrains/python/packaging/requirement/PyRequirementVersionSpec;", "relation", "Lcom/jetbrains/python/packaging/requirement/PyRequirementRelation;", "parsedVersion", "Lcom/jetbrains/python/packaging/PyPackageVersion;", "version", "", "<init>", "(Lcom/jetbrains/python/packaging/requirement/PyRequirementRelation;Lcom/jetbrains/python/packaging/PyPackageVersion;Ljava/lang/String;)V", "getRelation", "getVersion", "matches", "", "splitIntoPublicAndLocalVersions", "Lkotlin/Pair;", "toEqPartOfCompatibleRelation", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.python.psi.impl"})
final class PyRequirementVersionSpecImpl
implements PyRequirementVersionSpec {
    @NotNull
    private final PyRequirementRelation relation;
    @Nullable
    private final PyPackageVersion parsedVersion;
    @NotNull
    private final String version;

    public PyRequirementVersionSpecImpl(@NotNull PyRequirementRelation relation, @Nullable PyPackageVersion parsedVersion, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.relation = relation;
        this.parsedVersion = parsedVersion;
        this.version = version2;
    }

    @Override
    @NotNull
    public PyRequirementRelation getRelation() {
        return this.relation;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean matches(@NotNull String version2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Comparator<String> comparator = PyPackageVersionComparator.getSTR_COMPARATOR();
        switch (WhenMappings.$EnumSwitchMapping$0[this.relation.ordinal()]) {
            case 1: {
                if (comparator.compare(version2, this.version) < 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (comparator.compare(version2, this.version) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (comparator.compare(version2, this.version) > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if (comparator.compare(version2, this.version) >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean publicVersionsAreSame;
                Intrinsics.checkNotNull((Object)this.parsedVersion);
                Pair<String, String> publicAndLocalVersions = this.splitIntoPublicAndLocalVersions(this.parsedVersion);
                Pair<String, String> otherPublicAndLocalVersions = this.splitIntoPublicAndLocalVersions(version2);
                boolean bl2 = publicVersionsAreSame = comparator.compare((String)otherPublicAndLocalVersions.getFirst(), (String)publicAndLocalVersions.getFirst()) == 0;
                return publicVersionsAreSame && (((CharSequence)publicAndLocalVersions.getSecond()).length() == 0 || Intrinsics.areEqual((Object)otherPublicAndLocalVersions.getSecond(), (Object)publicAndLocalVersions.getSecond()));
            }
            case 6: {
                if (comparator.compare(version2, this.version) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                Intrinsics.checkNotNull((Object)this.parsedVersion);
                return PyRequirementsKt.pyRequirementVersionSpec(PyRequirementRelation.GTE, this.parsedVersion).matches(version2) && PyRequirementsKt.pyRequirementVersionSpec(PyRequirementRelation.EQ, this.toEqPartOfCompatibleRelation(this.parsedVersion)).matches(version2);
            }
            case 8: {
                bl = Intrinsics.areEqual((Object)version2, (Object)this.version);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final Pair<String, String> splitIntoPublicAndLocalVersions(PyPackageVersion version2) {
        return TuplesKt.to((Object)PyPackageVersion.copy$default(version2, null, null, null, null, null, null, 31, null).getPresentableText(), (Object)StringUtil.notNullize((String)version2.getLocal()));
    }

    private final Pair<String, String> splitIntoPublicAndLocalVersions(String version2) {
        char[] cArray = new char[]{'+'};
        List publicAndLocalVersions = StringsKt.split$default((CharSequence)version2, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String publicVersion = (String)publicAndLocalVersions.get(0);
        String localVersion = publicAndLocalVersions.size() == 1 ? "" : (String)publicAndLocalVersions.get(1);
        return TuplesKt.to((Object)publicVersion, (Object)localVersion);
    }

    private final PyPackageVersion toEqPartOfCompatibleRelation(PyPackageVersion version2) {
        PyPackageVersion pyPackageVersion;
        String release = version2.getRelease();
        int lastPoint = StringsKt.lastIndexOf$default((CharSequence)release, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastPoint == -1) {
            pyPackageVersion = version2;
        } else {
            String string = version2.getEpoch();
            String string2 = release.substring(0, lastPoint + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            pyPackageVersion = new PyPackageVersion(string, string2 + "*", null, null, null, null);
        }
        return pyPackageVersion;
    }

    private final PyRequirementRelation component1() {
        return this.relation;
    }

    private final PyPackageVersion component2() {
        return this.parsedVersion;
    }

    private final String component3() {
        return this.version;
    }

    @NotNull
    public final PyRequirementVersionSpecImpl copy(@NotNull PyRequirementRelation relation, @Nullable PyPackageVersion parsedVersion, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return new PyRequirementVersionSpecImpl(relation, parsedVersion, version2);
    }

    public static /* synthetic */ PyRequirementVersionSpecImpl copy$default(PyRequirementVersionSpecImpl pyRequirementVersionSpecImpl, PyRequirementRelation pyRequirementRelation, PyPackageVersion pyPackageVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            pyRequirementRelation = pyRequirementVersionSpecImpl.relation;
        }
        if ((n & 2) != 0) {
            pyPackageVersion = pyRequirementVersionSpecImpl.parsedVersion;
        }
        if ((n & 4) != 0) {
            string = pyRequirementVersionSpecImpl.version;
        }
        return pyRequirementVersionSpecImpl.copy(pyRequirementRelation, pyPackageVersion, string);
    }

    @NotNull
    public String toString() {
        return "PyRequirementVersionSpecImpl(relation=" + this.relation + ", parsedVersion=" + this.parsedVersion + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result2 = this.relation.hashCode();
        result2 = result2 * 31 + (this.parsedVersion == null ? 0 : this.parsedVersion.hashCode());
        result2 = result2 * 31 + this.version.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PyRequirementVersionSpecImpl)) {
            return false;
        }
        PyRequirementVersionSpecImpl pyRequirementVersionSpecImpl = (PyRequirementVersionSpecImpl)other;
        if (this.relation != pyRequirementVersionSpecImpl.relation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parsedVersion, (Object)pyRequirementVersionSpecImpl.parsedVersion)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)pyRequirementVersionSpecImpl.version);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PyRequirementRelation.values().length];
            try {
                nArray[PyRequirementRelation.LT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.LTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.GT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.GTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.EQ.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.NE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.COMPATIBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PyRequirementRelation.STR_EQ.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

