/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.SftpChannelNoSuchFileException;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObjectKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjLazyLstatHolder;", "", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "path", "", "value", "Lnet/schmizz/sshj/sftp/FileAttributes;", "surelyImaginary", "", "<init>", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Lnet/schmizz/sshj/sftp/FileAttributes;Z)V", "error", "Lcom/intellij/ssh/SftpChannelException;", "fill", "", "logNoSuchFileError", "clear", "getOrThrow", "isFileExist", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjRemoteFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjLazyLstatHolder\n+ 2 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 3 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObjectKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n33#2,6:249\n40#2,28:270\n233#3,15:255\n1#4:298\n*S KotlinDebug\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjLazyLstatHolder\n*L\n195#1:249,6\n195#1:270,28\n196#1:255,15\n*E\n"})
final class SshjLazyLstatHolder {
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final String path;
    @Nullable
    private FileAttributes value;
    @Nullable
    private SftpChannelException error;

    public SshjLazyLstatHolder(@NotNull SFTPClient sftp, @NotNull String path, @Nullable FileAttributes value, boolean surelyImaginary) {
        Intrinsics.checkNotNullParameter((Object)sftp, (String)"sftp");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sftp = sftp;
        this.path = path;
        this.value = value;
        this.error = surelyImaginary ? (SftpChannelException)new SftpChannelNoSuchFileException(this.path + " was created as surely imaginary file", new Throwable()) : null;
    }

    public /* synthetic */ SshjLazyLstatHolder(SFTPClient sFTPClient, String string, FileAttributes fileAttributes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(sFTPClient, string, fileAttributes, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void fill(boolean logNoSuchFileError) {
        SshjLazyLstatHolder sshjLazyLstatHolder = this;
        synchronized (sshjLazyLstatHolder) {
            boolean bl;
            boolean bl2 = false;
            if (this.value == null && this.error == null) {
                try {
                    void file$iv;
                    FileAttributes fileAttributes;
                    void logNoSuchFileError$iv;
                    String string = this.path;
                    boolean bl3 = logNoSuchFileError;
                    SshjLazyLstatHolder sshjLazyLstatHolder2 = this;
                    boolean log$iv = true;
                    boolean $i$f$wrapSshjSftpException = false;
                    void var9_14 = logNoSuchFileError$iv;
                    boolean log$iv$iv = log$iv;
                    boolean $i$f$wrapSshjSftpException2 = false;
                    try {
                        FileAttributes fileAttributes2;
                        boolean bl4 = false;
                        boolean $i$f$measureCall = false;
                        if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            boolean bl5 = false;
                            fileAttributes2 = this.sftp.lstat(this.path);
                        } else {
                            FileAttributes fileAttributes3;
                            long start$iv = System.nanoTime();
                            String state$iv = "ok";
                            try {
                                boolean bl6 = false;
                                fileAttributes3 = this.sftp.lstat(this.path);
                            }
                            catch (Throwable e$iv) {
                                state$iv = "exception";
                                throw e$iv;
                            }
                            finally {
                                long end$iv = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl7 = false;
                                logger.debug("Called " + ("sftp.lstat(" + this.path + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(end$iv - start$iv) / 1000000.0) + " ms (" + state$iv + ")");
                            }
                            fileAttributes2 = fileAttributes3;
                        }
                        fileAttributes = fileAttributes2;
                    }
                    catch (SFTPException e$iv$iv) {
                        IOException it$iv = (IOException)((Object)e$iv$iv);
                        boolean bl8 = false;
                        String message$iv$iv = "File " + (String)file$iv + ": " + it$iv.getMessage();
                        Response.StatusCode statusCode = e$iv$iv.getStatusCode();
                        switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                            case 1: {
                                if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                    UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                                }
                                UtilKt.getSSHJ_LOG().info(message$iv$iv);
                                break;
                            }
                            case 2: {
                                void logNoSuchFileError$iv$iv;
                                if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                    UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                                }
                                if (logNoSuchFileError$iv$iv == false) break;
                                UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                                break;
                            }
                            default: {
                                UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                            }
                        }
                        throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
                    }
                    catch (IOException e$iv$iv) {
                        IOException it$iv = e$iv$iv;
                        boolean bl9 = false;
                        String message$iv$iv = "File " + (String)file$iv + ": " + it$iv.getMessage();
                        UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                        throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
                    }
                    sshjLazyLstatHolder2.value = fileAttributes;
                    UtilKt.getSSHJ_LOG().debug("Fetched and cached permissions of " + this.path + ": " + this.value);
                }
                catch (SftpChannelNoSuchFileException e) {
                    this.error = e;
                }
            }
            boolean bl10 = bl = this.value == null != (this.error == null);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        SshjLazyLstatHolder sshjLazyLstatHolder = this;
        synchronized (sshjLazyLstatHolder) {
            boolean bl = false;
            if (this.value != null || this.error != null) {
                UtilKt.getSSHJ_LOG().debug("Clearing permission cache of " + this.path);
                this.value = null;
                this.error = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final FileAttributes getOrThrow() {
        this.fill(true);
        FileAttributes fileAttributes = this.value;
        if (fileAttributes != null) {
            FileAttributes it = fileAttributes;
            boolean bl = false;
            return it;
        }
        SftpChannelException sftpChannelException = this.error;
        Intrinsics.checkNotNull((Object)((Object)sftpChannelException));
        throw sftpChannelException;
    }

    public final boolean isFileExist() {
        boolean bl;
        this.fill(false);
        SftpChannelException e = this.error;
        if (e == null) {
            bl = true;
        } else if (e instanceof SftpChannelNoSuchFileException) {
            bl = false;
        } else {
            throw e;
        }
        return bl;
    }
}

