/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.community;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceBundleInstaller;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
@NonNullByDefault
public class CommunityBundleAddonHandler
extends MarketplaceBundleInstaller
implements MarketplaceAddonHandler {
    private static final List<String> SUPPORTED_EXT_TYPES = List.of("automation", "binding", "misc", "persistence", "transformation", "ui", "voice");
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final BundleContext bundleContext;
    private boolean isReady = false;

    @Activate
    public CommunityBundleAddonHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.scheduler.execute(() -> {
            this.ensureCachedBundlesAreInstalled(bundleContext);
            this.isReady = true;
        });
    }

    @Override
    public boolean supports(String type, String contentType) {
        return SUPPORTED_EXT_TYPES.contains(type) && contentType.equals("application/vnd.openhab.bundle");
    }

    @Override
    public boolean isInstalled(String id) {
        return this.isBundleInstalled(this.bundleContext, id);
    }

    @Override
    public void install(Addon addon) throws MarketplaceHandlerException {
        try {
            URL sourceUrl = new URL((String)addon.getProperties().get("jar_download_url"));
            this.addBundleToCache(addon.getUid(), sourceUrl);
            this.installFromCache(this.bundleContext, addon.getUid());
        }
        catch (MalformedURLException e) {
            throw new MarketplaceHandlerException("Malformed source URL: " + e.getMessage(), e);
        }
    }

    @Override
    public void uninstall(Addon addon) throws MarketplaceHandlerException {
        this.uninstallBundle(this.bundleContext, addon.getUid());
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }
}

