/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;

public class StopSizeCommand
extends ComPortCommand {
    private int stopSize;

    public StopSizeCommand(int[] bytes) {
        super("SET-STOPSIZE", 4, bytes);
        this.stopSize = bytes[2];
        switch (this.stopSize) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid stop size value " + this.stopSize);
            }
        }
    }

    public StopSizeCommand(boolean client, int stopSize) {
        this(new int[]{44, client ? 4 : 104, stopSize});
    }

    @Override
    public String toString() {
        String desc;
        switch (this.stopSize) {
            case 0: {
                desc = "REQUEST";
                break;
            }
            case 1: {
                desc = "1";
                break;
            }
            case 2: {
                desc = "2";
                break;
            }
            case 3: {
                desc = "1.5";
                break;
            }
            default: {
                desc = "?";
            }
        }
        return this.getName() + " " + desc;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseStopSize(this);
    }

    public int getStopSize() {
        return this.stopSize;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

