/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConditionalClientScopeAuthenticator
implements ConditionalAuthenticator {
    protected static final ConditionalClientScopeAuthenticator SINGLETON = new ConditionalClientScopeAuthenticator();
    private static final Logger logger = Logger.getLogger(ConditionalClientScopeAuthenticator.class);

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticatorConfigModel configModel = context.getAuthenticatorConfig();
        if (configModel == null || configModel.getConfig() == null) {
            logger.warnf("No configuration defined for the conditional client scope authenticator.", new Object[0]);
            return false;
        }
        String clientScopeName = (String)configModel.getConfig().get("client_scope");
        boolean negateOutput = Boolean.parseBoolean((String)configModel.getConfig().get("negate"));
        if (clientScopeName == null) {
            logger.warnf("No client scope configured in the option '%s' of the configuration '%s'.", (Object)"client_scope", (Object)configModel.getAlias());
            return false;
        }
        RealmModel realm = context.getRealm();
        ClientScopeModel targetClientScope = KeycloakModelUtils.getClientScopeByName((RealmModel)context.getRealm(), (String)clientScopeName);
        if (targetClientScope == null) {
            logger.warnf("No client scope '%s' defined in the realm '%s'.", (Object)clientScopeName, (Object)realm.getName());
            return false;
        }
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        boolean clientScopePresent = TokenManager.getRequestedClientScopes(context.getSession(), authSession.getClientNote("scope"), authSession.getClient(), authSession.getAuthenticatedUser()).anyMatch(clientScope -> targetClientScope.getId().equals(clientScope.getId()));
        return negateOutput != clientScopePresent;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

