/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import jakarta.persistence.EntityManager;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.store.JPAPermissionTicketStore;
import org.keycloak.authorization.jpa.store.JPAPolicyStore;
import org.keycloak.authorization.jpa.store.JPAResourceServerStore;
import org.keycloak.authorization.jpa.store.JPAResourceStore;
import org.keycloak.authorization.jpa.store.JPAScopeStore;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;

public class JPAStoreFactory
implements StoreFactory {
    private final PolicyStore policyStore;
    private final ResourceServerStore resourceServerStore;
    private final ResourceStore resourceStore;
    private final ScopeStore scopeStore;
    private final JPAPermissionTicketStore permissionTicketStore;
    private boolean readOnly;

    public JPAStoreFactory(EntityManager entityManager, AuthorizationProvider provider) {
        this.policyStore = new JPAPolicyStore(entityManager, provider);
        this.resourceServerStore = new JPAResourceServerStore(entityManager, provider);
        this.resourceStore = new JPAResourceStore(entityManager, provider);
        this.scopeStore = new JPAScopeStore(entityManager, provider);
        this.permissionTicketStore = new JPAPermissionTicketStore(entityManager, provider);
    }

    public PolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public ResourceServerStore getResourceServerStore() {
        return this.resourceServerStore;
    }

    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ScopeStore getScopeStore() {
        return this.scopeStore;
    }

    public PermissionTicketStore getPermissionTicketStore() {
        return this.permissionTicketStore;
    }

    public void close() {
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

