/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;

public class CompositeRepresentation
implements Representation {
    private final List<Representation> representations;

    public CompositeRepresentation(List<Representation> representations) {
        if (representations == null) {
            throw new IllegalArgumentException("The given representations should not be null");
        }
        this.representations = representations.stream().sorted(Comparator.comparingInt(Representation::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public String toStringOf(Object object) {
        for (Representation representation : this.representations) {
            String value = representation.toStringOf(object);
            if (value == null) continue;
            return value;
        }
        return StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(object);
    }

    @Override
    public String unambiguousToStringOf(Object object) {
        for (Representation representation : this.representations) {
            String value = representation.unambiguousToStringOf(object);
            if (value == null) continue;
            return value;
        }
        return StandardRepresentation.STANDARD_REPRESENTATION.unambiguousToStringOf(object);
    }

    public String toString() {
        return this.representations.isEmpty() ? StandardRepresentation.STANDARD_REPRESENTATION.toString() : this.representations.toString();
    }

    public List<Representation> getAllRepresentationsOrderedByPriority() {
        ArrayList<Representation> representationsOrderedByPriority = new ArrayList<Representation>(this.representations);
        representationsOrderedByPriority.add(StandardRepresentation.STANDARD_REPRESENTATION);
        return representationsOrderedByPriority;
    }
}

