/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.profiler.ultimate.hprof.utils.PagedByteBuffer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public interface LongList
extends AutoCloseable {
    public int limit();

    public long get(int var1);

    public void put(int var1, long var2);

    public void swap(int var1, int var2);

    public static LongList wrap(long @NotNull [] values) {
        if (values == null) {
            LongList.$$$reportNull$$$0(0);
        }
        return new InMemory(values);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/profiler/ultimate/hprof/utils/LongList", "wrap"));
    }

    public static class InMemory
    implements LongList {
        private final long @NotNull [] myArray;

        public InMemory(int capacity) {
            this.myArray = new long[capacity];
        }

        public InMemory(long @NotNull [] values) {
            if (values == null) {
                InMemory.$$$reportNull$$$0(0);
            }
            this.myArray = values;
        }

        @Override
        public int limit() {
            return this.myArray.length;
        }

        @Override
        public long get(int index) {
            return this.myArray[index];
        }

        @Override
        public void put(int index, long value) {
            this.myArray[index] = value;
        }

        @Override
        public void swap(int i, int j) {
            long t = this.myArray[i];
            this.myArray[i] = this.myArray[j];
            this.myArray[j] = t;
        }

        @Override
        public void close() throws Exception {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/profiler/ultimate/hprof/utils/LongList$InMemory", "<init>"));
        }
    }

    public static class FileBuffer
    implements LongList {
        @NotNull
        private final PagedByteBuffer myBuffer;

        public FileBuffer(int size, @NotNull Path path, StandardOpenOption ... options) throws IOException {
            if (path == null) {
                FileBuffer.$$$reportNull$$$0(0);
            }
            this.myBuffer = new PagedByteBuffer((long)size << 3, 8, path, options);
        }

        @Override
        public int limit() {
            return (int)(this.myBuffer.getSize() >> 3);
        }

        @Override
        public long get(int index) {
            return this.myBuffer.getLong((long)index << 3);
        }

        @Override
        public void put(int index, long value) {
            this.myBuffer.putLong((long)index << 3, value);
        }

        @Override
        public void swap(int i, int j) {
            long t = this.get(i);
            this.put(i, this.get(j));
            this.put(j, t);
        }

        @Override
        public void close() throws Exception {
            this.myBuffer.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/profiler/ultimate/hprof/utils/LongList$FileBuffer", "<init>"));
        }
    }

    public static interface Sequence
    extends LongList {
        public long get();

        public void put(long var1);

        public int position();

        public void position(int var1);
    }
}

