/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.P4ConfigConnectionDiagnoseDialog;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@Service(value={Service.Level.PROJECT})
public final class PerforceConnectionProblemsNotifier
extends GenericNotifierImpl<Object, Object> {
    private static final char NEW_LINE_CHAR = '\n';
    private boolean myConnectionProblems = false;
    private boolean myParametersProblems = false;
    private final PerforceSettings mySettings = PerforceSettings.getSettings(this.myProject);

    public PerforceConnectionProblemsNotifier(Project project) {
        super(project, "Perforce", PerforceBundle.message("connection.problems", new Object[0]), NotificationType.ERROR);
    }

    protected void configureNotification(@NotNull Notification notification, @NotNull Object obj) {
        if (notification == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(0);
        }
        if (obj == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(1);
        }
        NotificationAction inspectAction = NotificationAction.createSimple((String)PerforceBundle.message("action.inspect.text", new Object[0]), (String)"inspect", () -> PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, false));
        notification.addAction((AnAction)inspectAction);
        if (this.myConnectionProblems) {
            NotificationAction retryAction = NotificationAction.createSimple((String)PerforceBundle.message("action.retry.text", new Object[0]), (String)"retry", () -> {
                if (PerforceLoginManager.getInstance(this.myProject).checkAndRepairAll()) {
                    notification.expire();
                }
            });
            notification.addAction((AnAction)retryAction);
            NotificationAction disableAction = NotificationAction.createSimple((String)PerforceBundle.message("action.gooffline.text", new Object[0]), (String)"offline", () -> {
                this.mySettings.disable(true);
                notification.expire();
            });
            notification.addAction((AnAction)disableAction);
        }
    }

    protected boolean ask(Object obj, String description) {
        return false;
    }

    public static void showConnectionState(Project project, boolean refreshBefore) {
        PerforceSettings settings = PerforceSettings.getSettings(project);
        final PerforceBaseInfoWorker perforceBaseInfoWorker = (PerforceBaseInfoWorker)project.getService(PerforceBaseInfoWorker.class);
        final PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(project);
        if (settings.useP4CONFIG) {
            ConnectionDiagnoseRefresher refresher = new ConnectionDiagnoseRefresher(){

                @Override
                public void refresh() {
                    connectionManager.updateConnections();
                    PerforceMultipleConnections object = connectionManager.getMultipleConnectionObject();
                    Map<VirtualFile, P4Connection> allConnections = object.getAllConnections();
                    PerforceConnectionProblemsNotifier.refreshChecker(allConnections, perforceBaseInfoWorker);
                }

                @Override
                public PerforceMultipleConnections getMultipleConnections() {
                    return connectionManager.getMultipleConnectionObject();
                }

                @Override
                public P4RootsInformation getP4RootsInformation() {
                    return perforceBaseInfoWorker.getCheckerResults();
                }
            };
            Runnable showDialog = () -> {
                P4ConfigConnectionDiagnoseDialog dialog2 = new P4ConfigConnectionDiagnoseDialog(project, refresher);
                dialog2.show();
            };
            if (refreshBefore) {
                PerforceConnectionProblemsNotifier.underProgress(project, () -> refresher.refresh(), showDialog);
            } else {
                showDialog.run();
            }
        } else {
            Runnable showResults = () -> {
                P4RootsInformation checkerResults = perforceBaseInfoWorker.getCheckerResults();
                PerforceConnectionProblemsNotifier.showSingleConnectionState(project, checkerResults);
            };
            if (refreshBefore) {
                PerforceConnectionProblemsNotifier.underProgress(project, () -> PerforceConnectionProblemsNotifier.refreshChecker(connectionManager.getAllConnections(), perforceBaseInfoWorker), showResults);
            } else {
                showResults.run();
            }
        }
    }

    private static void refreshChecker(Map<VirtualFile, P4Connection> allConnections, PerforceBaseInfoWorker perforceBaseInfoWorker) {
        perforceBaseInfoWorker.scheduleRefresh();
        if (!allConnections.isEmpty()) {
            P4Connection connection = allConnections.values().iterator().next();
            try {
                perforceBaseInfoWorker.getInfo(connection);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }
    }

    private static void underProgress(Project project, final Runnable runnable, final Runnable onSuccess) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PerforceBundle.message("connection.refresh.state", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            public void onSuccess() {
                onSuccess.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionProblemsNotifier$2", "run"));
            }
        });
    }

    public static void showSingleConnectionState(Project project, P4RootsInformation checkerResults) {
        if (!(checkerResults.hasAnyErrors() || checkerResults.hasNotAuthorized() || checkerResults.hasNoConnections())) {
            Messages.showMessageDialog((Project)project, (String)PerforceBundle.message("connection.successful", new Object[0]), (String)PerforceBundle.message("connection.state.title", new Object[0]), (Icon)Messages.getInformationIcon());
        } else {
            @Nls StringBuilder sb = new StringBuilder(PerforceBundle.message("connection.problems.message", new Object[0])).append('\n');
            MultiMap<P4Connection, VcsException> errors = checkerResults.getErrors();
            if (checkerResults.hasNoConnections()) {
                sb.append(PerforceBundle.message("connection.no.valid.connections", new Object[0])).append('\n');
            }
            for (VcsException exception : errors.values()) {
                sb.append(exception.getMessage()).append('\n');
            }
            if (checkerResults.hasNotAuthorized()) {
                sb.append('\n').append(PerforceBundle.message("connection.not.logged.in", new Object[0]));
            }
            Map<P4Connection, PerforceClientRootsChecker.WrongRoots> map = checkerResults.getMap();
            for (PerforceClientRootsChecker.WrongRoots wrongRoots : map.values()) {
                sb.append('\n').append(PerforceBundle.message("config.wrong.client.spec", new Object[0])).append('\n').append(PerforceBundle.message("config.client.roots", new Object[0])).append(' ').append('\n');
                for (String string : wrongRoots.getActualInClientSpec()) {
                    sb.append(string).append('\n');
                }
                sb.append(PerforceBundle.message("config.actual.root", new Object[0])).append(' ').append('\n');
                for (VirtualFile virtualFile : wrongRoots.getWrong()) {
                    sb.append(virtualFile.getPath()).append('\n');
                }
            }
            Messages.showMessageDialog((String)sb.toString(), (String)PerforceBundle.message("connection.problems.title", new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    private void recalculateState() {
        if (this.mySettings.ENABLED && (this.myConnectionProblems || this.myParametersProblems)) {
            if (this.mySettings.myCanGoOffline && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> this.mySettings.disable(), ModalityState.nonModal());
            }
            this.ensureNotify((Object)this);
        } else {
            this.clear();
        }
    }

    public void setProblems(boolean connectionProblems, boolean parametersProblems) {
        this.myConnectionProblems = connectionProblems;
        this.myParametersProblems = parametersProblems;
        this.recalculateState();
    }

    public boolean hasConnectionProblems() {
        return this.myConnectionProblems;
    }

    @NotNull
    public static PerforceConnectionProblemsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(2);
        }
        PerforceConnectionProblemsNotifier perforceConnectionProblemsNotifier = (PerforceConnectionProblemsNotifier)((Object)project.getService(PerforceConnectionProblemsNotifier.class));
        if (perforceConnectionProblemsNotifier == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(3);
        }
        return perforceConnectionProblemsNotifier;
    }

    @NotNull
    protected Object getKey(Object obj) {
        Object object = obj;
        if (object == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NlsContexts.NotificationContent
    @NotNull
    protected String getNotificationContent(Object obj) {
        if (this.myConnectionProblems) {
            String string = PerforceBundle.message("connection.server.not.available", new Object[0]);
            if (string == null) {
                PerforceConnectionProblemsNotifier.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = PerforceBundle.message("connection.server.not.available.inspect", new Object[0]);
        if (string == null) {
            PerforceConnectionProblemsNotifier.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionProblemsNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionProblemsNotifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureNotification";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

