/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.ScrollingUtil;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalCommandUpDownScrolling;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "up", "", "<init>", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal.frontend"})
public abstract class TerminalCommandUpDownScrolling
extends TerminalPromotedDumbAwareAction {
    private final boolean up;

    public TerminalCommandUpDownScrolling(boolean up) {
        this.up = up;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)TerminalDataContextUtils.INSTANCE.getEditor(e));
        if (lookup == null) {
            return;
        }
        if (!lookup.isFocused()) {
            boolean semiFocused = lookup.getLookupFocusDegree() == LookupFocusDegree.SEMI_FOCUSED;
            lookup.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            if (!this.up && !semiFocused) {
                return;
            }
        }
        if (this.up) {
            ScrollingUtil.moveUp((JList)lookup.getList(), (int)0);
        } else {
            ScrollingUtil.moveDown((JList)lookup.getList(), (int)0);
        }
        lookup.markSelectionTouched();
        lookup.refreshUi(false, true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        if (editor == null || LookupManager.getActiveLookup((Editor)editor) == null || !TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor)) {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

