/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.AbstractScale;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "", "name", "", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;)V", "b", "Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;)V", "isContinuous", "", "()Z", "isContinuousDomain", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "getTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "createScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "shortenLabels", "getBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "hasBreaks", "with", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "MyBuilder", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDiscreteScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n766#2:116\n857#2,2:117\n766#2:119\n857#2,2:120\n1549#2:122\n1620#2,3:123\n*S KotlinDebug\n*F\n+ 1 DiscreteScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale\n*L\n55#1:116\n55#1:117,2\n75#1:119\n75#1:120,2\n76#1:122\n76#1:123,3\n*E\n"})
public final class DiscreteScale
extends AbstractScale<Object> {
    @NotNull
    private final DiscreteTransform discreteTransform;
    private final boolean isContinuous;
    private final boolean isContinuousDomain;

    @Override
    @NotNull
    public Transform getTransform() {
        return this.discreteTransform;
    }

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    public DiscreteScale(@NotNull String name, @NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        super(name);
        this.discreteTransform = discreteTransform;
        this.setMultiplicativeExpand(0.0);
        this.setAdditiveExpand(0.2);
    }

    private DiscreteScale(MyBuilder b2) {
        super(b2);
        this.discreteTransform = b2.getDiscreteTransform();
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        throw new IllegalStateException("No breaks generator for discrete scale '" + this.getName() + '\'');
    }

    @Override
    public boolean hasBreaks() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ScaleBreaks createScaleBreaks(boolean shortenLabels) {
        List list2;
        List list3;
        Object element$iv$iv;
        if (this.getProvidedBreaks() != null) {
            void $this$filterTo$iv$iv;
            Set breaksSet = CollectionsKt.toSet((Iterable)this.getProvidedBreaks());
            Iterable $this$filter$iv = this.discreteTransform.getEffectiveDomain();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!breaksSet.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = this.discreteTransform.getEffectiveDomain();
        }
        List breaksEffective = list3;
        List<String> list4 = this.getProvidedLabels();
        if (list4 != null) {
            List<String> it = list4;
            boolean bl = false;
            if (!this.getTransform().hasDomainLimits()) {
                List<Object> list5 = this.getProvidedBreaks();
                if (list5 == null) {
                    list5 = this.discreteTransform.getInitialDomain();
                }
                List breaksFull = list5;
                list2 = AbstractScale.Companion.alignLablesAndBreaks(breaksFull, it);
            } else if (this.getProvidedBreaks() == null) {
                list2 = AbstractScale.Companion.alignLablesAndBreaks(breaksEffective, it);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object it2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                List<String> labelsAligned = AbstractScale.Companion.alignLablesAndBreaks(this.getProvidedBreaks(), it);
                Map labelByBreak = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.getProvidedBreaks(), (Iterable)labelsAligned));
                element$iv$iv = this.discreteTransform.getEffectiveDomain();
                boolean $i$f$filter = false;
                void bl2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator3 = $this$filterTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv$iv2;
                    it2 = element$iv$iv2 = iterator3.next();
                    boolean bl3 = false;
                    if (!labelByBreak.containsKey(it2)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Object item$iv$iv;
                    it2 = item$iv$iv = iterator3.next();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add((String)MapsKt.getValue((Map)labelByBreak, it2));
                }
                list2 = (List)destination$iv$iv;
            }
        } else {
            list2 = null;
        }
        List labels = list2;
        return ScaleBreaks.Fixed.INSTANCE.withTransform(breaksEffective, this.getTransform(), (Function1<Object, String>)((Function1)new Function1<Object, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull Object p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DiscreteScale)this.receiver).formatValue(p0);
            }
        }), labels, shortenLabels ? Integer.valueOf(this.getLabelLengthLimit()) : null);
    }

    @Override
    @NotNull
    public Scale.Builder with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ DiscreteScale(MyBuilder b2, DefaultConstructorMarker $constructor_marker) {
        this(b2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;)V", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "getDiscreteTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "setDiscreteTransform", "(Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;)V", "breaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "v", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "build", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "plot-base"})
    private static final class MyBuilder
    extends AbstractScale.AbstractBuilder<Object> {
        @NotNull
        private DiscreteTransform discreteTransform;

        public MyBuilder(@NotNull DiscreteScale scale) {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            super(scale);
            this.discreteTransform = scale.discreteTransform;
        }

        @NotNull
        public final DiscreteTransform getDiscreteTransform() {
            return this.discreteTransform;
        }

        public final void setDiscreteTransform(@NotNull DiscreteTransform discreteTransform) {
            Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"<set-?>");
            this.discreteTransform = discreteTransform;
        }

        @Override
        @NotNull
        public Scale.Builder breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            throw new IllegalStateException("Not applicable to scale with discrete domain");
        }

        @Override
        @NotNull
        public Scale.Builder continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder discreteTransform(@NotNull DiscreteTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.discreteTransform = v;
            return this;
        }

        @Override
        @NotNull
        public Scale build() {
            return new DiscreteScale(this, null);
        }
    }
}

