/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallChunkBlockBuilder {
    public static final String FRAGMENT_DEBUG_NAME = "chainFragment";
    public static final String CHAINED_CALL_DEBUG_NAME = "chainedCall";
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final FormattingMode myFormattingMode;
    private final Indent mySmartIndent;
    private final boolean myUseRelativeIndents;
    private boolean isFirst;

    public CallChunkBlockBuilder(@NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (settings == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(0);
        }
        if (javaSettings == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(2);
        }
        this.isFirst = true;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
        this.myUseRelativeIndents = this.myIndentSettings != null && this.myIndentSettings.USE_RELATIVE_INDENTS;
        this.mySmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)this.myUseRelativeIndents);
    }

    @NotNull
    public Block create(@NotNull List<? extends ASTNode> subNodes, Wrap wrap, @Nullable Alignment alignment, int relativeIndentSize) {
        if (subNodes == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(3);
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode firstNode = subNodes.get(0);
        if (JavaFormatterUtil.isStartOfCallChunk(this.mySettings, firstNode)) {
            AlignmentStrategy strategy = AlignmentStrategy.getNullStrategy();
            Indent indent = relativeIndentSize > 0 ? Indent.getSpaceIndent((int)relativeIndentSize) : Indent.getNoneIndent();
            Block block = AbstractJavaBlock.newJavaBlock(firstNode, this.mySettings, this.myJavaSettings, indent, null, strategy, this.myFormattingMode);
            subBlocks.add(block);
            if (subNodes.size() > 1) {
                subBlocks.addAll(this.createJavaBlocks(subNodes.subList(1, subNodes.size())));
            }
            Block block2 = this.createSyntheticBlock(subBlocks, this.getChainedBlockIndent(true), alignment, wrap, CHAINED_CALL_DEBUG_NAME);
            if (block2 == null) {
                CallChunkBlockBuilder.$$$reportNull$$$0(4);
            }
            return block2;
        }
        Block block = this.createSyntheticBlock(this.createJavaBlocks(subNodes), this.getChainedBlockIndent(false), alignment, null, FRAGMENT_DEBUG_NAME);
        if (block == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(5);
        }
        return block;
    }

    private Block createSyntheticBlock(@NotNull List<Block> subBlocks, @NotNull Indent chainedBlockIndent, @Nullable Alignment alignment, @Nullable Wrap wrap, final @NotNull String debugName) {
        if (subBlocks == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(6);
        }
        if (chainedBlockIndent == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(7);
        }
        if (debugName == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(8);
        }
        return new SyntheticCodeBlock(subBlocks, alignment, this.mySettings, this.myJavaSettings, chainedBlockIndent, wrap){

            public String getDebugName() {
                return debugName + ": " + SyntheticCodeBlock.class.getSimpleName();
            }
        };
    }

    private Indent getChainedBlockIndent(boolean isChainedCall) {
        if (this.isFirst) {
            this.isFirst = false;
            return Indent.getNoneIndent();
        }
        return isChainedCall ? this.mySmartIndent : Indent.getContinuationIndent((boolean)this.myUseRelativeIndents);
    }

    @NotNull
    private List<Block> createJavaBlocks(@NotNull List<? extends ASTNode> subNodes) {
        if (subNodes == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(9);
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode aSTNode : subNodes) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
            result.add(AbstractJavaBlock.newJavaBlock(aSTNode, this.mySettings, this.myJavaSettings, indent, null, AlignmentStrategy.getNullStrategy(), this.myFormattingMode));
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            CallChunkBlockBuilder.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subNodes";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/CallChunkBlockBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chainedBlockIndent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/CallChunkBlockBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSyntheticBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createJavaBlocks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10 -> new IllegalStateException(string);
        };
    }
}

