/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingClassBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingClassBodyFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_RECORD_COMPONENT)) {
            astNode = BasicJavaAstTreeUtil.getRecordComponentContainingClass(astNode);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.CLASS_SET) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_TYPE_PARAMETER)) {
            return;
        }
        if (BasicJavaAstTreeUtil.getLBrace(astNode) == null && astNode != null) {
            ASTNode lastChild = astNode.getLastChildNode();
            int offset = astNode.getTextRange().getEndOffset();
            if (BasicJavaAstTreeUtil.is(lastChild, TokenType.ERROR_ELEMENT)) {
                ASTNode previous = lastChild.getTreePrev();
                offset = BasicJavaAstTreeUtil.isWhiteSpace(previous) ? previous.getTextRange().getStartOffset() : lastChild.getTextRange().getStartOffset();
            }
            if (BasicJavaAstTreeUtil.isInterfaceEnumClassOrRecord(astNode, JavaTokenType.RECORD_KEYWORD) && BasicJavaAstTreeUtil.getRecordHeader(astNode) == null) {
                editor.getDocument().insertString(offset, (CharSequence)"() {}");
                editor.getCaretModel().moveToOffset(offset + 1);
                processor.setSkipEnter(true);
            } else {
                processor.insertBracesWithNewLine(editor, offset);
                editor.getCaretModel().moveToOffset(offset + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/MissingClassBodyFixer", "apply"));
    }
}

