/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.ASTNodeEnterProcessor;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeaveCodeBlockEnterProcessor
implements ASTNodeEnterProcessor {
    private final ParentAwareTokenSet CONTROL_FLOW_ELEMENT_TYPES = ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_IF_STATEMENT, BasicJavaElementType.BASIC_WHILE_STATEMENT, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT, BasicJavaElementType.BASIC_FOR_STATEMENT, BasicJavaElementType.BASIC_FOREACH_STATEMENT});

    @Override
    public boolean doEnter(@NotNull Editor editor, @NotNull ASTNode astNode, boolean isModified) {
        int i;
        CharSequence text;
        ASTNode parent;
        if (editor == null) {
            LeaveCodeBlockEnterProcessor.$$$reportNull$$$0(0);
        }
        if (astNode == null) {
            LeaveCodeBlockEnterProcessor.$$$reportNull$$$0(1);
        }
        if (!BasicJavaAstTreeUtil.is(parent = astNode.getTreeParent(), BasicJavaElementType.BASIC_CODE_BLOCK)) {
            return false;
        }
        if (this.CONTROL_FLOW_ELEMENT_TYPES.contains(astNode.getElementType())) {
            return false;
        }
        boolean leaveCodeBlock = LeaveCodeBlockEnterProcessor.isControlFlowBreak(astNode);
        if (!leaveCodeBlock) {
            return false;
        }
        int offset = parent.getTextRange().getEndOffset();
        if (offset < (text = editor.getDocument().getCharsSequence()).length() - 1 && (i = CharArrayUtil.shiftForward((CharSequence)text, (int)(offset + 1), (String)" \t")) < text.length() && text.charAt(i) == '\n') {
            editor.getCaretModel().moveToOffset(offset + 1);
            EditorActionManager actionManager = EditorActionManager.getInstance();
            EditorActionHandler actionHandler = actionManager.getActionHandler("EditorLineEnd");
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            actionHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
            return true;
        }
        editor.getCaretModel().moveToOffset(offset);
        return false;
    }

    private static boolean isControlFlowBreak(@Nullable ASTNode element) {
        return BasicJavaAstTreeUtil.is(element, BasicJavaElementType.BASIC_RETURN_STATEMENT) || BasicJavaAstTreeUtil.is(element, BasicJavaElementType.BASIC_THROW_STATEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "astNode";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/smartEnter/LeaveCodeBlockEnterProcessor";
        objectArray[2] = "doEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

