/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.performanceTesting.backend.split;

import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.SnapshotOpener;
import com.jetbrains.rdserver.actions.copyPaste.BackendFileTransmissionInitiatorKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000f\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/performanceTesting/backend/split/RemoteClientSnapshotUploader;", "Lcom/jetbrains/performancePlugin/profilers/SnapshotOpener;", "<init>", "()V", "canOpen", "", "snapshot", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "getPresentableName", "", "Lorg/jetbrains/annotations/Nls;", "open", "", "intellij.performanceTesting.backend.split"})
@SourceDebugExtension(value={"SMAP\nRemoteClientSnapshotUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteClientSnapshotUploader.kt\ncom/intellij/performanceTesting/backend/split/RemoteClientSnapshotUploader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,29:1\n24#2:30\n*S KotlinDebug\n*F\n+ 1 RemoteClientSnapshotUploader.kt\ncom/intellij/performanceTesting/backend/split/RemoteClientSnapshotUploader\n*L\n23#1:30\n*E\n"})
public final class RemoteClientSnapshotUploader
implements SnapshotOpener {
    public boolean canOpen(@NotNull File snapshot, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return project != null && AppMode.isRemoteDevHost();
    }

    @Nullable
    public String getPresentableName() {
        return PerformanceTestingBundle.message((String)"profiling.load.snapshot.to.client.action.text", (Object[])new Object[0]);
    }

    public void open(@NotNull File snapshot, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (project == null) {
            RemoteClientSnapshotUploader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RemoteClientSnapshotUploader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to load a snapshot without a project");
            return;
        }
        BackendFileTransmissionInitiatorKt.initiateFileUpload((List)CollectionsKt.listOf((Object)snapshot.getAbsolutePath()), (Project)project);
    }
}

