/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.sudo;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.sudo.SendResult;
import com.intellij.profiler.sudo.SudoPasswordWriter;
import com.intellij.profiler.sudo.ValidationResult;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\r\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002H\u0000\u001a&\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00022\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\b\u001a\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\r\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007\u001a\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007\u001a&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u000fH\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u000fX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"sudoCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Lorg/jetbrains/annotations/NotNull;", "sudoProcess", "Ljava/lang/Process;", "commandWithParameters", "", "", "([Ljava/lang/String;)Ljava/lang/Process;", "", "startSudoProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "password", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/execution/process/OSProcessHandler;", "SIGINT", "", "SIGKILL", "sudoSendSIGINT", "Lcom/intellij/profiler/sudo/SendResult;", "process", "pid", "sudoSendSIGKILL", "sudoSendSignal", "signal", "validateSudoPassword", "Lcom/intellij/profiler/sudo/ValidationResult;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeoutInMilliseconds", "intellij.profiler.common"})
public final class ExecSudoCommandKt {
    public static final int SIGINT = 2;
    public static final int SIGKILL = 9;

    @NotNull
    public static final GeneralCommandLine sudoCmd() {
        String[] stringArray = new String[]{"sudo"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        stringArray = new String[]{"-k"};
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
        stringArray = new String[]{"-S"};
        GeneralCommandLine generalCommandLine3 = generalCommandLine2.withParameters(stringArray);
        stringArray = new String[]{"-p", "\"\""};
        GeneralCommandLine generalCommandLine4 = generalCommandLine3.withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine4, (String)"withParameters(...)");
        return generalCommandLine4;
    }

    private static final Process sudoProcess(String ... commandWithParameters) {
        return ExecSudoCommandKt.sudoProcess(ArraysKt.toList((Object[])commandWithParameters));
    }

    private static final Process sudoProcess(List<String> commandWithParameters) {
        Process process = ExecSudoCommandKt.sudoCmd().withParameters(commandWithParameters).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        return process;
    }

    @NotNull
    public static final OSProcessHandler startSudoProcess(@NotNull String password, String ... commandWithParameters) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)commandWithParameters, (String)"commandWithParameters");
        return ExecSudoCommandKt.startSudoProcess(password, ArraysKt.toList((Object[])commandWithParameters));
    }

    @NotNull
    public static final OSProcessHandler startSudoProcess(@NotNull String password, @NotNull List<String> commandWithParameters) {
        OSProcessHandler oSProcessHandler;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(commandWithParameters, (String)"commandWithParameters");
        OSProcessHandler $this$startSudoProcess_u24lambda_u240 = oSProcessHandler = new OSProcessHandler(ExecSudoCommandKt.sudoProcess(commandWithParameters), "sudo " + CollectionsKt.joinToString$default((Iterable)commandWithParameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        boolean bl = false;
        $this$startSudoProcess_u24lambda_u240.addProcessListener((ProcessListener)new SudoPasswordWriter(password, false, 2, null));
        return oSProcessHandler;
    }

    @NotNull
    public static final SendResult sudoSendSIGINT(@NotNull Process process, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSIGINT(OSProcessUtil.getProcessID((Process)process), password);
    }

    @NotNull
    public static final SendResult sudoSendSIGINT(int pid, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSignal(pid, 2, password);
    }

    @NotNull
    public static final SendResult sudoSendSIGKILL(@NotNull Process process, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSIGKILL(OSProcessUtil.getProcessID((Process)process), password);
    }

    @NotNull
    public static final SendResult sudoSendSIGKILL(int pid, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return ExecSudoCommandKt.sudoSendSignal(pid, 9, password);
    }

    @NotNull
    public static final SendResult sudoSendSignal(int pid, int signal, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String[] stringArray = new String[]{"kill", "-" + signal, String.valueOf(pid)};
        CapturingProcessHandler handler = new CapturingProcessHandler(ExecSudoCommandKt.sudoProcess(stringArray), null, "sudo kill -" + signal + " " + pid);
        handler.addProcessListener((ProcessListener)new SudoPasswordWriter(password, true));
        ProcessOutput processOutput = handler.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput result2 = processOutput;
        if (result2.getExitCode() == 1) {
            String string = result2.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"no such process", (boolean)false, (int)2, null)) {
                return SendResult.NO_SUCH_PROCESS;
            }
        }
        if (result2.getExitCode() == 0) {
            return SendResult.OK;
        }
        return SendResult.FAILED;
    }

    @NotNull
    public static final ValidationResult validateSudoPassword(@NotNull String password, @Nullable ProgressIndicator progressIndicator, int timeoutInMilliseconds) {
        ProcessOutput result2;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String[] stringArray = new String[]{"echo", "OK"};
        CapturingProcessHandler handler = new CapturingProcessHandler(ExecSudoCommandKt.sudoProcess(stringArray), null, "sudo echo OK");
        handler.addProcessListener((ProcessListener)new SudoPasswordWriter(password, true));
        ProgressIndicator progressIndicator2 = progressIndicator;
        ProcessOutput processOutput = result2 = progressIndicator2 != null ? handler.runProcessWithProgressIndicator(progressIndicator2, timeoutInMilliseconds, true) : handler.runProcess(timeoutInMilliseconds);
        if (result2.isCancelled()) {
            return ValidationResult.CANCELED;
        }
        return result2.getExitCode() == 0 && Intrinsics.areEqual((Object)result2.getStdout(), (Object)"OK\n") ? ValidationResult.VALID : ValidationResult.INVALID;
    }

    public static /* synthetic */ ValidationResult validateSudoPassword$default(String string, ProgressIndicator progressIndicator, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            progressIndicator = null;
        }
        if ((n2 & 4) != 0) {
            n = 10000;
        }
        return ExecSudoCommandKt.validateSudoPassword(string, progressIndicator, n);
    }
}

