/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.debug;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerActionListener;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.WithFixAction;
import com.intellij.profiler.WithUserFriendlyMessage;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationStateBase;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorListener;
import com.intellij.profiler.ultimate.debug.ProfileOnRunToCursorStateObserver;
import com.intellij.profiler.ultimate.debug.ProfilerOnDebugConfigurationState;
import com.intellij.util.system.CpuArch;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u001e\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J3\u0010\u0014\u001a\u00020\u0015\"\f\b\u0000\u0010\u0016*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0017\u001a\u0002H\u00162\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010'\u001a\u00020(H\u0014J\f\u0010)\u001a\u00020\u0005*\u00020*H\u0002R\u0014\u0010+\u001a\u00020,8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension;", "Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase;", "<init>", "()V", "isApplicableFor", "", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "isEnabledFor", "applicableConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "isSupportedJdk", "Lcom/intellij/execution/CommonJavaRunConfigurationParameters;", "unsupportedJdk", "reason", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "getSettings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;", "executor", "Lcom/intellij/execution/Executor;", "doUpdateJavaParameters", "", "T", "configuration", "settings", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;Lcom/intellij/execution/configurations/JavaParameters;)V", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "throwable", "", "attachToProcess", "profilerConfigurationState", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "profilerParameters", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "runConfiguration", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "containsInfoAboutIncorrectArchitecture", "", "mainCommand", "Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "getMainCommand", "()Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "UnsupportedJvmReason", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nIntelliJProfilerOnDebugExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n14#2:175\n14#2:176\n*S KotlinDebug\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension\n*L\n72#1:175\n151#1:176\n*E\n"})
public final class IntelliJProfilerOnDebugExtension
extends AsyncProfilerConfigurationExtensionBase {
    @Override
    protected boolean isApplicableFor(@Nullable RunnerSettings runnerSettings) {
        return !AppMode.isRemoteDevHost() && ProfileOnRunToCursorStateObserver.Companion.getInstance().getEnabled() && AsyncProfilerExtractor.INSTANCE.getAsyncProfilerInstance() != null && runnerSettings instanceof GenericDebuggerRunnerSettings;
    }

    public boolean isEnabledFor(@NotNull RunConfigurationBase<?> applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(applicableConfiguration, (String)"applicableConfiguration");
        return ProfileOnRunToCursorStateObserver.Companion.getInstance().getEnabled() && runnerSettings instanceof GenericDebuggerRunnerSettings && this.isApplicableFor(applicableConfiguration) && applicableConfiguration instanceof CommonJavaRunConfigurationParameters && !UtilsKt.willRunOnTarget((RunProfile)applicableConfiguration) && this.isSupportedJdk((CommonJavaRunConfigurationParameters)applicableConfiguration);
    }

    private final boolean isSupportedJdk(CommonJavaRunConfigurationParameters $this$isSupportedJdk) {
        CpuArch arch;
        String jdkHome;
        String jdk;
        String string;
        block10: {
            block9: {
                string = $this$isSupportedJdk.getAlternativeJrePath();
                if (string == null) break block9;
                String it = string;
                boolean bl = false;
                Sdk sdk = ProjectJdkTable.getInstance().findJdk(it);
                string = sdk;
                if (sdk != null) break block10;
            }
            string = ProjectRootManager.getInstance((Project)$this$isSupportedJdk.getProject()).getProjectSdk();
        }
        String string2 = jdk = string;
        String string3 = jdkHome = string2 != null ? string2.getHomePath() : null;
        if (jdkHome == null) {
            return this.unsupportedJdk($this$isSupportedJdk, UnsupportedJvmReason.HomeNotFound.INSTANCE);
        }
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = SdkVersionUtil.getJdkVersionInfo((String)jdkHome);
        Object object = arch = jdkVersionInfo != null ? jdkVersionInfo.arch : null;
        if (arch == null) {
            return this.unsupportedJdk($this$isSupportedJdk, UnsupportedJvmReason.CantDetect.INSTANCE);
        }
        CpuArch cpuArch = arch;
        switch (WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1: 
            case 2: {
                if (SystemInfo.isWindows && CpuArch.isArm64() && arch == CpuArch.X86_64) {
                    return this.unsupportedJdk($this$isSupportedJdk, UnsupportedJvmReason.X86OnWindowsArm.INSTANCE);
                }
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Detected JDK with a 64-bit architecture '" + arch + "'. Profiling will be turned on.");
                return true;
            }
        }
        return this.unsupportedJdk($this$isSupportedJdk, new UnsupportedJvmReason.UnsupportedArchitecture(arch));
    }

    private final boolean unsupportedJdk(CommonJavaRunConfigurationParameters $this$unsupportedJdk, UnsupportedJvmReason reason) {
        reason.log();
        UnsupportedJvmReason unsupportedJvmReason = reason;
        CpuArch arch = unsupportedJvmReason instanceof UnsupportedJvmReason.UnsupportedArchitecture ? ((UnsupportedJvmReason.UnsupportedArchitecture)reason).getCpuArch() : (unsupportedJvmReason instanceof UnsupportedJvmReason.X86OnWindowsArm ? CpuArch.X86_64 : CpuArch.UNKNOWN);
        ProfilerUsageTriggerCollector.INSTANCE.logAutoDisableProfileDuringRunToCursor($this$unsupportedJdk.getProject(), arch);
        return false;
    }

    @Override
    @Nullable
    protected AsyncProfilerConfigurationStateBase getSettings(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return new ProfilerOnDebugConfigurationState();
    }

    @Override
    protected <T extends RunConfigurationBase<?>> void doUpdateJavaParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationStateBase settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        try {
            super.doUpdateJavaParameters(configuration, settings, params);
        }
        catch (Throwable t) {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.showNotification(project, t);
        }
    }

    private final void showNotification(Project project, Throwable throwable) {
        Object[] objectArray;
        String message = throwable instanceof WithUserFriendlyMessage ? ((WithUserFriendlyMessage)throwable).getUserFriendlyMessage() : throwable.getMessage();
        Object[] $this$showNotification_u24lambda_u243 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        AnAction anAction = ActionManager.getInstance().getAction("profiler.DisableProfileOnRunToCursor");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.project.DumbAwareAction");
        $this$showNotification_u24lambda_u243.add((DumbAwareAction)anAction);
        if (throwable instanceof WithFixAction) {
            DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)((WithFixAction)throwable).getFixActionName(), arg_0 -> IntelliJProfilerOnDebugExtension.showNotification$lambda$3$lambda$2(arg_0 -> IntelliJProfilerOnDebugExtension.showNotification$lambda$3$lambda$1(throwable, project, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
            $this$showNotification_u24lambda_u243.add(dumbAwareAction);
        }
        List actions = CollectionsKt.build((List)objectArray);
        objectArray = new Object[1];
        String string = message;
        if (string == null) {
            string = UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.unknown.reason", new Object[0]);
        }
        objectArray[0] = string;
        ProfilerManager.INSTANCE.showStickyWarning(UltimateProfilerBundleKt.profilerMessage("action.profiler.profileOnRunToCursor.cant.start.message", objectArray), project, (Collection)actions);
    }

    @Override
    protected void attachToProcess(@NotNull ProfilerConfigurationState profilerConfigurationState, @NotNull AgentConfiguration profilerParameters, @NotNull RunConfigurationBase<?> runConfiguration, @NotNull ProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)profilerConfigurationState, (String)"profilerConfigurationState");
        Intrinsics.checkNotNullParameter((Object)profilerParameters, (String)"profilerParameters");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (handler instanceof ExternalSystemProcessHandler) {
            return;
        }
        if (!(handler instanceof OSProcessHandler)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("unexpected process handler: '" + handler + "'");
            throw new ExecutionException(UltimateProfilerBundleKt.profilerMessage("profiler.exception.cant.start", new Object[0]));
        }
        ProfilerProcessCommunicator communicator = UtilsKt.doCreateProfilerCommunicator$default(runConfiguration, (OSProcessHandler)handler, null, 4, null);
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AsyncProfilerProcess process = new AsyncProfilerProcess(project, communicator, profilerConfigurationState, profilerParameters, System.currentTimeMillis());
        ProfileOnRunToCursorListener listener = new ProfileOnRunToCursorListener(process);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(this, runConfiguration){
            final /* synthetic */ IntelliJProfilerOnDebugExtension this$0;
            final /* synthetic */ RunConfigurationBase<?> $runConfiguration;
            {
                this.this$0 = $receiver;
                this.$runConfiguration = $runConfiguration;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputType.STDERR) {
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (IntelliJProfilerOnDebugExtension.access$containsInfoAboutIncorrectArchitecture(this.this$0, string)) {
                        ProfilerManager.showStickyError$default((ProfilerManager)ProfilerManager.INSTANCE, (String)UltimateProfilerBundleKt.profilerMessage("action.profiler.profileOnRunToCursor.disabled", new Object[0]), (Project)this.$runConfiguration.getProject(), null, (int)4, null);
                    }
                }
                super.onTextAvailable(event, outputType);
            }
        });
        RunConfigurationBase<?> $this$attachToProcess_u24lambda_u244 = runConfiguration;
        boolean bl = false;
        DebuggerManager.getInstance((Project)$this$attachToProcess_u24lambda_u244.getProject()).addDebugProcessListener(handler, (DebugProcessListener)listener);
        $this$attachToProcess_u24lambda_u244.getProject().getMessageBus().connect((Disposable)process).subscribe(DebuggerActionListener.TOPIC, (Object)listener);
    }

    private final boolean containsInfoAboutIncorrectArchitecture(String $this$containsInfoAboutIncorrectArchitecture) {
        return StringsKt.contains$default((CharSequence)$this$containsInfoAboutIncorrectArchitecture, (CharSequence)"32-bit platform", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)$this$containsInfoAboutIncorrectArchitecture, (CharSequence)"libasyncProfiler", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    protected AgentOptions.MainCommand getMainCommand() {
        return AgentOptions.MainCommand.Version.INSTANCE;
    }

    private static final Unit showNotification$lambda$3$lambda$1(Throwable $throwable, Project $project, AnActionEvent it) {
        ((WithFixAction)$throwable).fixAction($project);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$containsInfoAboutIncorrectArchitecture(IntelliJProfilerOnDebugExtension $this, String $receiver) {
        return $this.containsInfoAboutIncorrectArchitecture($receiver);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "", "logMessage", "", "<init>", "(Ljava/lang/String;)V", "getLogMessage", "()Ljava/lang/String;", "log", "", "HomeNotFound", "CantDetect", "UnsupportedArchitecture", "X86OnWindowsArm", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$CantDetect;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$HomeNotFound;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$UnsupportedArchitecture;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$X86OnWindowsArm;", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nIntelliJProfilerOnDebugExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n14#2:175\n*S KotlinDebug\n*F\n+ 1 IntelliJProfilerOnDebugExtension.kt\ncom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason\n*L\n170#1:175\n*E\n"})
    private static abstract class UnsupportedJvmReason {
        @NotNull
        private final String logMessage;

        private UnsupportedJvmReason(String logMessage) {
            this.logMessage = logMessage;
        }

        @NotNull
        public final String getLogMessage() {
            return this.logMessage;
        }

        public final void log() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntelliJProfilerOnDebugExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(this.logMessage + "; disabling profiling to prevent possible debug sessions crashes");
        }

        public /* synthetic */ UnsupportedJvmReason(String logMessage, DefaultConstructorMarker $constructor_marker) {
            this(logMessage);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$CantDetect;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class CantDetect
        extends UnsupportedJvmReason {
            @NotNull
            public static final CantDetect INSTANCE = new CantDetect();

            private CantDetect() {
                super("Couldn't detect configuration JDK architecture", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$HomeNotFound;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class HomeNotFound
        extends UnsupportedJvmReason {
            @NotNull
            public static final HomeNotFound INSTANCE = new HomeNotFound();

            private HomeNotFound() {
                super("Couldn't detect configuration JDK", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$UnsupportedArchitecture;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "cpuArch", "Lcom/intellij/util/system/CpuArch;", "<init>", "(Lcom/intellij/util/system/CpuArch;)V", "getCpuArch", "()Lcom/intellij/util/system/CpuArch;", "intellij.profiler.ultimate"})
        public static final class UnsupportedArchitecture
        extends UnsupportedJvmReason {
            @NotNull
            private final CpuArch cpuArch;

            public UnsupportedArchitecture(@NotNull CpuArch cpuArch) {
                Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
                super("Unsupported configuration JDK architecture: " + cpuArch, null);
                this.cpuArch = cpuArch;
            }

            @NotNull
            public final CpuArch getCpuArch() {
                return this.cpuArch;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason$X86OnWindowsArm;", "Lcom/intellij/profiler/ultimate/debug/IntelliJProfilerOnDebugExtension$UnsupportedJvmReason;", "<init>", "()V", "intellij.profiler.ultimate"})
        public static final class X86OnWindowsArm
        extends UnsupportedJvmReason {
            @NotNull
            public static final X86OnWindowsArm INSTANCE = new X86OnWindowsArm();

            private X86OnWindowsArm() {
                super("X86 JDKs in compatibility mode are not supported on Windows on ARM", null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

