/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceWrapper;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookUsagesContributorFactory;
import com.intellij.kotlin.jupyter.core.editor.find.PsiAwareKt;
import com.intellij.kotlin.jupyter.core.editor.find.ReferenceSearchStrategy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0003H\u0002R\u0015\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/KotlinNotebookElementFindUsagesHandler;", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "element", "Lcom/intellij/psi/PsiElement;", "searchWithAdditionalCellDeclarationResolve", "", "isJVMCompliedDeclaration", "<init>", "(Lcom/intellij/psi/PsiElement;ZZ)V", "notebookFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "targetElementInfo", "Lkotlin/Triple;", "Lcom/intellij/kotlin/jupyter/core/editor/find/TargetElementInfo;", "getPrimaryElements", "", "()[Lcom/intellij/psi/PsiElement;", "findReferencesToHighlight", "", "Lcom/intellij/psi/PsiReference;", "target", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "processElementUsages", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/usageView/UsageInfo;", "options", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "ensureProperTextRangeShiftInFile", "Lcom/intellij/openapi/util/TextRange;", "usage", "findUsageForElement", "", "targetElement", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nfindUsagesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findUsagesHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/find/KotlinNotebookElementFindUsagesHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,185:1\n11228#2:186\n11563#2,3:187\n32#3,2:190\n*S KotlinDebug\n*F\n+ 1 findUsagesHandler.kt\ncom/intellij/kotlin/jupyter/core/editor/find/KotlinNotebookElementFindUsagesHandler\n*L\n95#1:186\n95#1:187,3\n111#1:190,2\n*E\n"})
public final class KotlinNotebookElementFindUsagesHandler
extends FindUsagesHandler {
    @Nullable
    private VirtualFile notebookFile;
    @NotNull
    private final Triple<PsiElement, Boolean, Boolean> targetElementInfo;

    public KotlinNotebookElementFindUsagesHandler(@NotNull PsiElement element, boolean searchWithAdditionalCellDeclarationResolve, boolean isJVMCompliedDeclaration) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        VirtualFileWindow virtualFileWindow = virtualFile instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile : null;
        this.notebookFile = virtualFileWindow != null ? virtualFileWindow.getDelegate() : null;
        this.targetElementInfo = new Triple((Object)element, (Object)searchWithAdditionalCellDeclarationResolve, (Object)(!searchWithAdditionalCellDeclarationResolve && isJVMCompliedDeclaration ? 1 : 0));
    }

    public /* synthetic */ KotlinNotebookElementFindUsagesHandler(PsiElement psiElement, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(psiElement, bl, bl2);
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.myPsiElement.getNavigationElement(), (String)"getNavigationElement(...)");
        return psiElementArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        Collection collection;
        PsiElement[] foundRefs;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Object object = foundRefs = NotebookUsagesContributorFactory.INSTANCE.invokeElementUsagesContributor(this.targetElementInfo, searchScope);
        if (foundRefs != null) {
            void $this$mapTo$iv$iv;
            PsiElement[] $this$map$iv = object;
            boolean $i$f$map = false;
            PsiElement[] psiElementArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_12 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                TextRange properFileRange = this.ensureProperTextRangeShiftInFile((PsiElement)it);
                collection2.add(new NotebookReferenceWrapper(target, (PsiElement)it, properFileRange, true));
            }
            object = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            if (object != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = new LinkedHashSet();
        return collection;
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        ReadActionProcessor refProcessor2 = (ReadActionProcessor)new ReadActionProcessor<PsiReference>(processor){
            final /* synthetic */ Processor<? super UsageInfo> $processor;
            {
                this.$processor = $processor;
            }

            public boolean processInReadAction(PsiReference ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                return this.$processor.process((Object)new UsageInfo(ref.getElement(), ref.getRangeInElement(), false));
            }
        };
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        ActionsKt.runReadAction(() -> KotlinNotebookElementFindUsagesHandler.processElementUsages$lambda$2(this, element, result2, refProcessor2));
        return result2.element;
    }

    private final TextRange ensureProperTextRangeShiftInFile(PsiElement usage) {
        TextRange textRange;
        TextRange fileRange = usage.getContainingFile().getTextRange();
        TextRange textRange2 = TextRange.create((int)usage.getTextRangeInParent().getStartOffset(), (int)usage.getTextRangeInParent().getEndOffset()).shiftRight(usage.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
        TextRange rangeToStore = textRange2;
        int lDiff = rangeToStore.getStartOffset() > fileRange.getEndOffset() ? rangeToStore.getStartOffset() - fileRange.getEndOffset() : 0;
        int rDiff = rangeToStore.getEndOffset() > fileRange.getEndOffset() ? rangeToStore.getEndOffset() - fileRange.getEndOffset() : 0;
        int maxDiff = Math.max(lDiff, rDiff);
        PsiElement firstChild = usage.getFirstChild();
        if (usage instanceof PsiNameIdentifierOwner) {
            PsiElement psiElement = ((PsiNameIdentifierOwner)usage).getNameIdentifier();
            if (psiElement == null || (psiElement = psiElement.getTextRangeInParent()) == null) {
                TextRange textRange3 = ((PsiNameIdentifierOwner)usage).getTextRangeInParent();
                psiElement = textRange3;
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"getTextRangeInParent(...)");
            }
            return psiElement;
        }
        if (maxDiff != 0) {
            TextRange textRange4 = usage.getTextRangeInParent().shiftLeft(usage.getTextRangeInParent().getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"shiftLeft(...)");
            return textRange4;
        }
        PsiElement psiElement = firstChild;
        boolean bl = psiElement != null ? FindUsagesHandlerKt.isIdentifier(psiElement) : false;
        if (bl) {
            TextRange textRange5 = firstChild.getTextRangeInParent();
            textRange = textRange5;
            Intrinsics.checkNotNullExpressionValue((Object)textRange5, (String)"getTextRangeInParent(...)");
        } else {
            TextRange textRange6 = usage.getTextRangeInParent();
            textRange = textRange6;
            Intrinsics.checkNotNullExpressionValue((Object)textRange6, (String)"getTextRangeInParent(...)");
        }
        return textRange;
    }

    private final Set<PsiElement> findUsageForElement(PsiElement targetElement) {
        VirtualFile virtualFile = this.notebookFile;
        if (virtualFile == null) {
            return null;
        }
        VirtualFile notebookFileState = virtualFile;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return PsiAwareKt.searchForElementDeclarationOrUsages(project, FindUsagesHandlerKt.adjustElement(targetElement), notebookFileState, ReferenceSearchStrategy.REFERENCES);
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit processElementUsages$lambda$2(KotlinNotebookElementFindUsagesHandler this$0, PsiElement $element, Ref.BooleanRef $result, ReadActionProcessor $refProcessor) {
        block4: {
            block3: {
                foundUsages = this$0.findUsageForElement($element);
                v0 = foundUsages;
                if (v0 == null || (v0 = v0.iterator()) == null) break block3;
                $this$forEach$iv = v0;
                $i$f$forEach = false;
                var7_7 = $this$forEach$iv;
                while (var7_7.hasNext()) {
                    element$iv = var7_7.next();
                    it = (PsiElement)element$iv;
                    $i$a$-forEach-KotlinNotebookElementFindUsagesHandler$processElementUsages$1$1 = false;
                    properFileRange = this$0.ensureProperTextRangeShiftInFile(it);
                    if (!$result.element) ** GOTO lbl-1000
                    v1 = this$0.myPsiElement;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"myPsiElement");
                    if ($refProcessor.processInReadAction((Object)new NotebookReferenceWrapper(v1, it, properFileRange, true))) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    $result.element = v2;
                }
                v3 = Unit.INSTANCE;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }
}

