/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.search;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenModulePsiReference;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

final class MavenModuleReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    private static final String DELIMITER = "/";
    private static final String DELIMITER_REGEX = "((?<=%1$s)|(?=%1$s))".formatted("/");

    MavenModuleReferenceSearcher() {
    }

    @NotNull
    private static List<PsiReference> getPomTagReferencesToDirectory(@Nullable XmlTag tag, @NotNull VirtualFile pomFile, @NotNull VirtualFile directory) {
        if (pomFile == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(1);
        }
        try {
            return MavenModuleReferenceSearcher.doGetPomTagReferencesToDirectory(tag, pomFile, directory);
        }
        catch (InvalidPathException ignored) {
            List<PsiReference> list = List.of();
            if (list == null) {
                MavenModuleReferenceSearcher.$$$reportNull$$$0(2);
            }
            return list;
        }
    }

    @NotNull
    private static List<PsiReference> doGetPomTagReferencesToDirectory(@Nullable XmlTag tag, @NotNull VirtualFile pomFile, @NotNull VirtualFile directory) {
        if (pomFile == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(4);
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        if (null != tag) {
            ASTNode node;
            ASTNode textTag;
            Path oldDirectoryPath = Paths.get(directory.getPath(), new String[0]).normalize();
            String modulePath = tag.getValue().getTrimmedText();
            Path tmpPath = Paths.get(pomFile.getParent().getPath(), new String[0]).normalize();
            Path referencedDirectoryPath = Paths.get(pomFile.getParent().getPath(), modulePath).normalize();
            if (referencedDirectoryPath.startsWith(oldDirectoryPath) && tag instanceof ASTNode && null != (textTag = (node = (ASTNode)tag).findChildByType(XmlElementType.XML_TEXT))) {
                String[] items;
                int from = textTag.getStartOffsetInParent();
                int length = directory.getName().length();
                for (String item : items = modulePath.split(DELIMITER_REGEX)) {
                    tmpPath = Paths.get(tmpPath.toString(), item).normalize();
                    if (!DELIMITER.equals(item) && tmpPath.equals(oldDirectoryPath)) {
                        references.add(new MavenModulePsiReference((PsiElement)tag, tag.getText(), new TextRange(from, from + length)));
                    }
                    from += item.length();
                }
            }
        }
        ArrayList<PsiReference> arrayList = references;
        if (arrayList == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void processModule(@NotNull Project project, @NotNull Module module, @NotNull PsiDirectory directory, @NotNull Processor<? super PsiReference> consumer) {
        MavenProjectsManager projectsManager;
        if (project == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (module == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(9);
        }
        if (!(projectsManager = MavenProjectsManager.getInstance(project)).isMavenizedModule(module)) {
            return;
        }
        MavenProject mavenProject = projectsManager.findProject(module);
        if (null == mavenProject) {
            return;
        }
        VirtualFile pomFile = mavenProject.getFile();
        MavenDomProjectModel mavenModel = (MavenDomProjectModel)ReadAction.compute(() -> MavenDomUtil.getMavenDomProjectModel(project, pomFile));
        if (null == mavenModel) {
            return;
        }
        List references = (List)ReadAction.compute(() -> mavenModel.getModules().getModules().stream().flatMap(mavenModule -> MavenModuleReferenceSearcher.getPomTagReferencesToDirectory(mavenModule.getXmlTag(), pomFile, directory.getVirtualFile()).stream()).toList());
        for (PsiReference reference : references) {
            consumer.process((Object)reference);
        }
    }

    public void processQuery(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement psiElement;
        if (consumer == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(10);
        }
        if (queryParameters == null) {
            MavenModuleReferenceSearcher.$$$reportNull$$$0(11);
        }
        if ((psiElement = queryParameters.getElementToSearch()) instanceof PsiDirectory) {
            Module[] modules;
            PsiDirectory directory = (PsiDirectory)psiElement;
            Project project = queryParameters.getProject();
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                MavenModuleReferenceSearcher.processModule(project, module, directory, consumer);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomFile";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/search/MavenModuleReferenceSearcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/search/MavenModuleReferenceSearcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPomTagReferencesToDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetPomTagReferencesToDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPomTagReferencesToDirectory";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetPomTagReferencesToDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processModule";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

