/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsLogAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (selection == null) {
            return;
        }
        selection.requestFullDetails(details -> {
            MultiMap grouped = this.groupCommits(project, (Collection)details, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (project == null || selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project, selection);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project, @NotNull MultiMap<Repo, Hash> grouped) {
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(3);
        }
        if (grouped == null) {
            VcsLogAction.$$$reportNull$$$0(4);
        }
        AbstractRepositoryManager<Repo> manager = this.getRepositoryManager(project);
        return grouped.keySet().stream().noneMatch(manager::isExternal);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project, @NotNull VcsLogCommitSelection selection) {
        MultiMap commitIds;
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(5);
        }
        if (selection == null) {
            VcsLogAction.$$$reportNull$$$0(6);
        }
        if ((commitIds = this.groupCommits(project, ContainerUtil.getFirstItems((List)selection.getCommits(), (int)1000), CommitId::getRoot)) == null) {
            return null;
        }
        MultiMap hashes = MultiMap.create();
        for (Map.Entry entry : commitIds.entrySet()) {
            hashes.putValues((Object)((Repository)entry.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), CommitId::getHash));
        }
        return hashes;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project, @NotNull Collection<? extends T> commits, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(7);
        }
        if (commits == null) {
            VcsLogAction.$$$reportNull$$$0(8);
        }
        if (rootGetter == null) {
            VcsLogAction.$$$reportNull$$$0(9);
        }
        MultiMap map = MultiMap.create();
        for (T commit : commits) {
            Repo root = this.getRepositoryForRoot(project, (VirtualFile)rootGetter.fun(commit));
            if (root == null) {
                return null;
            }
            map.putValue(root, commit);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/VcsLogAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/VcsLogAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "groupFirstPackOfCommits";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "groupCommits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

