/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.diff;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.CodeReviewAdvancedSettings;
import com.intellij.collaboration.ui.codereview.action.ImmutableToolbarLabelAction;
import com.intellij.collaboration.ui.codereview.diff.AsyncDiffRequestProcessorFactory;
import com.intellij.collaboration.util.KeyValuePair;
import com.intellij.collaboration.util.RefComparisonChange;
import com.intellij.collaboration.util.RefComparisonChangeKt;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffChangeViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffServiceKt;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.review.GHPRReviewViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.create.GHPRCreateDiffChangeViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.create.GHPRCreateDiffViewModel;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffService;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "cs", "createGHPRDiffProcessor", "Lcom/intellij/diff/impl/DiffEditorViewer;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "createGHNewPRDiffProcessor", "Companion", "intellij.vcs.github"})
@ApiStatus.Internal
public final class GHPRDiffService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public GHPRDiffService(@NotNull Project project, @NotNull CoroutineScope parentCs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        this.project = project;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (String)string, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (boolean)false, (int)4, null);
    }

    @NotNull
    public final DiffEditorViewer createGHPRDiffProcessor(@NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        DiffEditorViewer processor2 = CodeReviewAdvancedSettings.INSTANCE.isCombinedDiffEnabled() ? (DiffEditorViewer)GHPRDiffService.Companion.createCombinedDiffProcessor(this.project, this.cs, repository, pullRequest) : (DiffEditorViewer)Companion.createDiffRequestProcessor(this.project, this.cs, repository, pullRequest);
        processor2.getContext().putUserData(DiffUserDataKeysEx.COMBINED_DIFF_TOGGLE, (Object)CodeReviewAdvancedSettings.INSTANCE.getCodeReviewCombinedDiffToggle());
        return processor2;
    }

    @NotNull
    public final DiffEditorViewer createGHNewPRDiffProcessor(@NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        DiffEditorViewer processor2 = CodeReviewAdvancedSettings.INSTANCE.isCombinedDiffEnabled() ? (DiffEditorViewer)GHPRDiffService.Companion.createCombinedDiffProcessor(this.project, this.cs, repository) : (DiffEditorViewer)GHPRDiffService.Companion.createDiffRequestProcessor(this.project, this.cs, repository);
        processor2.getContext().putUserData(DiffUserDataKeysEx.COMBINED_DIFF_TOGGLE, (Object)CodeReviewAdvancedSettings.INSTANCE.getCodeReviewCombinedDiffToggle());
        return processor2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffService$Companion;", "", "<init>", "()V", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "createCombinedDiffProcessor", "Lcom/intellij/diff/tools/combined/CombinedDiffComponentProcessor;", "createDiffContext", "", "Lcom/intellij/collaboration/util/KeyValuePair;", "vm", "Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffViewModel;", "getChangeDiffVmPresentation", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "changeVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/diff/GHPRDiffChangeViewModel;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/create/GHPRCreateDiffChangeViewModel;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiffRequestProcessor createDiffRequestProcessor(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
            Flow vmFlow = GHPRDiffServiceKt.access$findDiffVm(project, repository, pullRequest);
            return AsyncDiffRequestProcessorFactory.INSTANCE.createIn(cs, project, vmFlow, new Function1<GHPRDiffViewModel, List<? extends KeyValuePair<?>>>(this){

                public final List<KeyValuePair<?>> invoke(GHPRDiffViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$createDiffContext((Companion)this.receiver, p0);
                }
            }, (Function1)new Function1<GHPRDiffChangeViewModel, PresentableChange>((Object)this){

                public final PresentableChange invoke(GHPRDiffChangeViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$getChangeDiffVmPresentation((Companion)this.receiver, p0);
                }
            });
        }

        private final CombinedDiffComponentProcessor createCombinedDiffProcessor(Project project, CoroutineScope cs, GHRepositoryCoordinates repository, GHPRIdentifier pullRequest) {
            Flow vmFlow = GHPRDiffServiceKt.access$findDiffVm(project, repository, pullRequest);
            return AsyncDiffRequestProcessorFactory.INSTANCE.createCombinedIn(cs, project, vmFlow, new Function1<GHPRDiffViewModel, List<? extends KeyValuePair<?>>>(this){

                public final List<KeyValuePair<?>> invoke(GHPRDiffViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$createDiffContext((Companion)this.receiver, p0);
                }
            }, (Function1)new Function1<GHPRDiffChangeViewModel, PresentableChange>((Object)this){

                public final PresentableChange invoke(GHPRDiffChangeViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$getChangeDiffVmPresentation((Companion)this.receiver, p0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<KeyValuePair<?>> createDiffContext(GHPRDiffViewModel vm2) {
            void $this$createDiffContext_u24lambda_u241_u24lambda_u240;
            Object[] objectArray;
            List list;
            ActionManager actionManager = ActionManager.getInstance();
            List $this$createDiffContext_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createDiffContext_u24lambda_u241.add(new KeyValuePair(GHPRDiffViewModel.Companion.getKEY(), (Object)vm2));
            Key key = DiffUserDataKeys.DATA_PROVIDER;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"DATA_PROVIDER");
            Object[] objectArray2 = objectArray = new GenericDataProvider();
            Key key2 = key;
            List list2 = $this$createDiffContext_u24lambda_u241;
            boolean bl2 = false;
            $this$createDiffContext_u24lambda_u241_u24lambda_u240.putData(GHPRDiffViewModel.Companion.getDATA_KEY(), (Object)vm2);
            $this$createDiffContext_u24lambda_u241_u24lambda_u240.putData(GHPRReviewViewModel.Companion.getDATA_KEY(), (Object)vm2.getReviewVm());
            Unit unit = Unit.INSTANCE;
            Object[] objectArray3 = objectArray;
            Key key3 = key2;
            list2.add(new KeyValuePair(key3, (Object)objectArray3));
            Key key4 = DiffUserDataKeys.CONTEXT_ACTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"CONTEXT_ACTIONS");
            objectArray = new AnAction[5];
            String string = CollaborationToolsBundle.message((String)"review.diff.toolbar.label", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            objectArray[0] = new ImmutableToolbarLabelAction(string);
            objectArray[1] = new GHPRDiffReviewThreadsReloadAction();
            objectArray[2] = actionManager.getAction("Github.PullRequest.Review.Submit");
            objectArray[3] = actionManager.getAction("GitHub.Diff.Review.PreviousComment");
            objectArray[4] = actionManager.getAction("GitHub.Diff.Review.NextComment");
            $this$createDiffContext_u24lambda_u241.add(new KeyValuePair(key4, (Object)CollectionsKt.listOf((Object[])objectArray)));
            return CollectionsKt.build((List)list);
        }

        private final PresentableChange getChangeDiffVmPresentation(GHPRDiffChangeViewModel changeVm) {
            return new PresentableChange(changeVm){
                final /* synthetic */ GHPRDiffChangeViewModel $changeVm;
                {
                    this.$changeVm = $changeVm;
                }

                public FilePath getFilePath() {
                    return RefComparisonChangeKt.getFilePath((RefComparisonChange)this.$changeVm.getChange());
                }

                public FileStatus getFileStatus() {
                    return RefComparisonChangeKt.getFileStatus((RefComparisonChange)this.$changeVm.getChange());
                }
            };
        }

        private final DiffRequestProcessor createDiffRequestProcessor(Project project, CoroutineScope cs, GHRepositoryCoordinates repository) {
            Flow vmFlow = GHPRDiffServiceKt.access$findDiffVm(project, repository);
            return AsyncDiffRequestProcessorFactory.INSTANCE.createIn(cs, project, vmFlow, Companion::createDiffRequestProcessor$lambda$2, (Function1)new Function1<GHPRCreateDiffChangeViewModel, PresentableChange>((Object)this){

                public final PresentableChange invoke(GHPRCreateDiffChangeViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$getChangeDiffVmPresentation((Companion)this.receiver, p0);
                }
            });
        }

        private final CombinedDiffComponentProcessor createCombinedDiffProcessor(Project project, CoroutineScope cs, GHRepositoryCoordinates repository) {
            Flow vmFlow = GHPRDiffServiceKt.access$findDiffVm(project, repository);
            return AsyncDiffRequestProcessorFactory.INSTANCE.createCombinedIn(cs, project, vmFlow, Companion::createCombinedDiffProcessor$lambda$3, (Function1)new Function1<GHPRCreateDiffChangeViewModel, PresentableChange>((Object)this){

                public final PresentableChange invoke(GHPRCreateDiffChangeViewModel p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService$Companion.access$getChangeDiffVmPresentation((Companion)this.receiver, p0);
                }
            });
        }

        private final PresentableChange getChangeDiffVmPresentation(GHPRCreateDiffChangeViewModel changeVm) {
            return new PresentableChange(changeVm){
                final /* synthetic */ GHPRCreateDiffChangeViewModel $changeVm;
                {
                    this.$changeVm = $changeVm;
                }

                public FilePath getFilePath() {
                    return RefComparisonChangeKt.getFilePath((RefComparisonChange)this.$changeVm.getChange());
                }

                public FileStatus getFileStatus() {
                    return RefComparisonChangeKt.getFileStatus((RefComparisonChange)this.$changeVm.getChange());
                }
            };
        }

        private static final List createDiffRequestProcessor$lambda$2(GHPRCreateDiffViewModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CollectionsKt.emptyList();
        }

        private static final List createCombinedDiffProcessor$lambda$3(GHPRCreateDiffViewModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return CollectionsKt.emptyList();
        }

        public static final /* synthetic */ List access$createDiffContext(Companion $this, GHPRDiffViewModel vm2) {
            return $this.createDiffContext(vm2);
        }

        public static final /* synthetic */ PresentableChange access$getChangeDiffVmPresentation(Companion $this, GHPRDiffChangeViewModel changeVm) {
            return $this.getChangeDiffVmPresentation(changeVm);
        }

        public static final /* synthetic */ PresentableChange access$getChangeDiffVmPresentation(Companion $this, GHPRCreateDiffChangeViewModel changeVm) {
            return $this.getChangeDiffVmPresentation(changeVm);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

