/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.NamedLineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.GroupComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBox;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBreak;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendComponentLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendComponentSpec;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponent;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBox;", "spec", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentSpec;", "panelTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentSpec;Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelTheme;)V", "getSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentSpec;", "appendGuideContent", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "contentRoot", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "createBreakElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "br", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySize", "keyLabelBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelBox", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "legendBreak", "size", "plot-builder"})
public final class LegendComponent
extends LegendBox {
    @NotNull
    private final LegendComponentSpec spec;
    @NotNull
    private final PanelTheme panelTheme;

    public LegendComponent(@NotNull LegendComponentSpec spec, @NotNull PanelTheme panelTheme) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)panelTheme, (String)"panelTheme");
        this.spec = spec;
        this.panelTheme = panelTheme;
    }

    @Override
    @NotNull
    public LegendComponentSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        LegendComponentLayout layout = this.getSpec().getLayout();
        Iterator<DoubleRectangle> keyLabelBoxes = layout.getKeyLabelBoxes().iterator();
        Iterator<DoubleRectangle> labelBoxes = layout.getLabelBoxes().iterator();
        Iterator<DoubleVector> keySizes = layout.getKeySizes().iterator();
        for (LegendBreak br : this.getSpec().getBreaks$plot_builder()) {
            DoubleRectangle keyLabelBox = keyLabelBoxes.next();
            DoubleRectangle labelBox = labelBoxes.next();
            DoubleVector keySize = keySizes.next();
            SvgElement breakElement = this.createBreakElement(br, keySize, keyLabelBox, labelBox);
            contentRoot.children().add(breakElement);
        }
        if (this.getDebug()) {
            DoubleRectangle graphBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), layout.getGraphSize());
            contentRoot.children().add(LegendBox.Companion.createTransparentRect(graphBounds, Color.Companion.getDARK_BLUE(), 1.0));
        }
        return layout.getSize();
    }

    private final SvgElement createBreakElement(LegendBreak br, DoubleVector keySize, DoubleRectangle keyLabelBox, DoubleRectangle labelBox) {
        GroupComponent breakComponent = new GroupComponent();
        breakComponent.add(this.createKeyElement(br, keySize));
        MultilineLabel label = new MultilineLabel(br.getLabel(), 0, false, 6, null);
        double lineHeight = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height();
        label.addClassName("legend-item");
        label.setHorizontalAnchor(Text.HorizontalAnchor.LEFT);
        label.setLineHeight(lineHeight);
        label.moveTo(labelBox.getOrigin().add(new DoubleVector(0.0, lineHeight * 0.35)));
        breakComponent.add(label);
        breakComponent.moveTo(keyLabelBox.getOrigin());
        return breakComponent.getRootGroup();
    }

    private final SvgGElement createKeyElement(LegendBreak legendBreak, DoubleVector size2) {
        SvgRectElement backgroundRect;
        SvgGElement g = new SvgGElement();
        if (this.getTheme().showKeyRect()) {
            backgroundRect = LegendKeyElementFactory.Companion.createBackgroundRect(size2, this.getTheme().keyRectColor(), this.getTheme().keyRectFill(), this.getTheme().keyRectStrokeWidth(), this.getTheme().keyLineType());
            g.children().add(backgroundRect);
        } else if (this.panelTheme.showRect()) {
            backgroundRect = LegendKeyElementFactory.Companion.createBackgroundRect(size2, this.panelTheme.rectFill(), this.panelTheme.rectFill(), 0.0, NamedLineType.SOLID);
            g.children().add(backgroundRect);
        }
        DoubleVector innerSize = new DoubleVector(size2.getX() - (double)2, size2.getY() - (double)2);
        SvgGElement keyElement = legendBreak.createKeyElement(innerSize);
        SvgTransform keyElementTransform = SvgComponent.Companion.buildTransform(new DoubleVector(1.0, 1.0), 0.0);
        keyElement.transform().set(keyElementTransform);
        g.children().add(keyElement);
        return g;
    }
}

