/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.QQStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J;\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\fH\u0016J:\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u00132\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0015H\u0002J\u0012\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0015H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQ2LineStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "lineQuantiles", "Lkotlin/Pair;", "", "(Lkotlin/Pair;)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "", "xs", "ys", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nQQ2LineStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQ2LineStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQ2LineStat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n766#2:79\n857#2,2:80\n1549#2:82\n1620#2,3:83\n766#2:86\n857#2,2:87\n1549#2:89\n1620#2,3:90\n*S KotlinDebug\n*F\n+ 1 QQ2LineStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQ2LineStat\n*L\n41#1:79\n41#1:80,2\n41#1:82\n41#1:83,3\n42#1:86\n42#1:87,2\n42#1:89\n42#1:90,3\n*E\n"})
public final class QQ2LineStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pair<Double, Double> lineQuantiles;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public QQ2LineStat(@NotNull Pair<Double, Double> lineQuantiles) {
        Intrinsics.checkNotNullParameter(lineQuantiles, (String)"lineQuantiles");
        super(DEF_MAPPING);
        this.lineQuantiles = lineQuantiles;
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
                Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
                Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
                if (!this.hasRequiredValues(data2, aesArray)) break block2;
                aesArray = new Aes[]{Aes.Companion.getY()};
                if (this.hasRequiredValues(data2, aesArray)) break block3;
            }
            return this.withEmptyStatValues();
        }
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(data2.getNumeric(TransformVar.INSTANCE.getX()), data2.getNumeric(TransformVar.INSTANCE.getY()));
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getX())).putNumeric(Stats.INSTANCE.getY(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getY())).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> xs, List<Double> ys) {
        Object[] objectArray;
        Pair[] $this$mapTo$iv$iv;
        Pair[] $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        boolean bl;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = xs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            double d;
            Double d2 = (Double)element$iv$iv;
            bl = false;
            Double d3 = d2;
            boolean bl2 = d3 != null ? !Double.isInfinite(d = d3.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Double d = (Double)item$iv$iv;
            collection = destination$iv$iv;
            bl = false;
            Double d4 = d;
            Intrinsics.checkNotNull((Object)d4);
            collection.add(Double.valueOf(d4));
        }
        List sortedX = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv2 = ys;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object t : $this$filterTo$iv$iv) {
            double d;
            Double it2 = (Double)t;
            boolean bl3 = false;
            Double d5 = it2;
            boolean bl4 = d5 != null ? !Double.isInfinite(d = d5.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl4) continue;
            destination$iv$iv2.add(t);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            Double it2 = (Double)t;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            void v5 = it;
            Intrinsics.checkNotNull((Object)v5);
            collection.add(v5.doubleValue());
        }
        List sortedY = CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
        if (!CollectionsKt.any((Iterable)sortedX) || !CollectionsKt.any((Iterable)sortedY)) {
            $this$map$iv = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), (Object)CollectionsKt.emptyList()), TuplesKt.to((Object)Stats.INSTANCE.getY(), (Object)CollectionsKt.emptyList())};
            return MapsKt.mutableMapOf((Pair[])$this$map$iv);
        }
        Pair quantilesX = new Pair((Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedX, ((Number)this.lineQuantiles.getFirst()).doubleValue()), (Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedX, ((Number)this.lineQuantiles.getSecond()).doubleValue()));
        Pair quantilesY = new Pair((Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedY, ((Number)this.lineQuantiles.getFirst()).doubleValue()), (Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedY, ((Number)this.lineQuantiles.getSecond()).doubleValue()));
        if (((Number)quantilesX.getFirst()).doubleValue() == ((Number)quantilesX.getSecond()).doubleValue()) {
            $this$mapTo$iv$iv = new Pair[2];
            objectArray = new Double[]{quantilesX.getFirst(), quantilesX.getSecond()};
            $this$mapTo$iv$iv[0] = TuplesKt.to((Object)Stats.INSTANCE.getX(), (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new Double[]{CollectionsKt.first((List)sortedY), CollectionsKt.last((List)sortedY)};
            $this$mapTo$iv$iv[1] = TuplesKt.to((Object)Stats.INSTANCE.getY(), (Object)CollectionsKt.listOf((Object[])objectArray));
            return MapsKt.mutableMapOf((Pair[])$this$mapTo$iv$iv);
        }
        Function1<Double, Double> line2 = QQStatUtil.INSTANCE.lineByPoints((Pair<Double, Double>)quantilesX, (Pair<Double, Double>)quantilesY);
        objectArray = new Pair[2];
        Object[] objectArray2 = new Double[]{CollectionsKt.first((List)sortedX), CollectionsKt.last((List)sortedX)};
        objectArray[0] = TuplesKt.to((Object)Stats.INSTANCE.getX(), (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Double[]{line2.invoke(CollectionsKt.first((List)sortedX)), line2.invoke(CollectionsKt.last((List)sortedX))};
        objectArray[1] = TuplesKt.to((Object)Stats.INSTANCE.getY(), (Object)CollectionsKt.listOf((Object[])objectArray2));
        return MapsKt.mutableMapOf((Pair[])objectArray);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQ2LineStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

