/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.xml;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.xml.Lexer;
import org.jetbrains.letsPlot.commons.xml.Token;
import org.jetbrains.letsPlot.commons.xml.TokenType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\nJ\b\u0010\u001c\u001a\u00020\nH\u0002J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u001e\u001a\u00020\u00032\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00190!0 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Lexer;", "", "input", "", "(Ljava/lang/String;)V", "getInput", "()Ljava/lang/String;", "pos", "", "<set-?>", "Lorg/jetbrains/letsPlot/commons/xml/Token;", "token", "getToken", "()Lorg/jetbrains/letsPlot/commons/xml/Token;", "tokenPos", "getTokenPos", "()I", "advance", "", "()Ljava/lang/Character;", "eq", "Lkotlin/reflect/KFunction1;", "Lkotlin/ParameterName;", "name", "other", "", "char", "nextToken", "nextTokenImpl", "peek", "readUntil", "predicate", "", "Lkotlin/Function1;", "commons"})
@SourceDebugExtension(value={"SMAP\nLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lexer.kt\norg/jetbrains/letsPlot/commons/xml/Lexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1747#3,3:96\n*S KotlinDebug\n*F\n+ 1 Lexer.kt\norg/jetbrains/letsPlot/commons/xml/Lexer\n*L\n86#1:96,3\n*E\n"})
public final class Lexer {
    @NotNull
    private final String input;
    @NotNull
    private Token token;
    private int tokenPos;
    private int pos;

    public Lexer(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.token = Token.Companion.getEOF();
        this.nextToken();
    }

    @NotNull
    public final String getInput() {
        return this.input;
    }

    @NotNull
    public final Token getToken() {
        return this.token;
    }

    public final int getTokenPos() {
        return this.tokenPos;
    }

    private final Character peek() {
        return StringsKt.getOrNull((CharSequence)this.input, (int)this.pos);
    }

    private final Character advance() {
        int n = this.pos;
        this.pos = n + 1;
        return StringsKt.getOrNull((CharSequence)this.input, (int)n);
    }

    @NotNull
    public final Token nextToken() {
        this.tokenPos = this.pos;
        this.token = this.nextTokenImpl();
        return this.token;
    }

    /*
     * WARNING - void declaration
     */
    private final Token nextTokenImpl() {
        Token token;
        if (this.pos >= this.input.length()) {
            return Token.Companion.getEOF();
        }
        Character c = this.peek();
        if (c == null) {
            token = Token.Companion.getEOF();
        } else {
            char c2 = '<';
            if (c.charValue() == c2) {
                this.advance();
                Character c3 = this.peek();
                c2 = '/';
                if (c3 != null && c3.charValue() == c2) {
                    Token token2;
                    Token it = token2 = Token.Companion.getLT_SLASH();
                    boolean bl = false;
                    this.advance();
                    token = token2;
                } else {
                    token = Token.Companion.getLT();
                }
            } else {
                c2 = '>';
                if (c.charValue() == c2) {
                    Token token3;
                    Token it = token3 = Token.Companion.getGT();
                    boolean bl = false;
                    this.advance();
                    token = token3;
                } else {
                    c2 = '/';
                    if (c.charValue() == c2) {
                        this.advance();
                        Character c4 = this.peek();
                        c2 = '>';
                        if (c4 != null && c4.charValue() == c2) {
                            Token token4;
                            Token it = token4 = Token.Companion.getSLASH_GT();
                            boolean bl = false;
                            this.advance();
                            token = token4;
                        } else {
                            token = Token.Companion.getSLASH();
                        }
                    } else {
                        c2 = '=';
                        if (c.charValue() == c2) {
                            Token token5;
                            Token it = token5 = Token.Companion.getEQUALS();
                            boolean bl = false;
                            this.advance();
                            token = token5;
                        } else {
                            c2 = '\"';
                            if (c.charValue() == c2) {
                                this.advance();
                                Token token6 = new Token(TokenType.QUOTED_STRING, this.readUntil(CollectionsKt.listOf(this.eq('\"'))));
                                this.advance();
                                token = token6;
                            } else {
                                char token6 = '\'';
                                if (c.charValue() == token6) {
                                    void var2_8;
                                    this.advance();
                                    Token token7 = new Token(TokenType.QUOTED_STRING, this.readUntil(CollectionsKt.listOf(this.eq('\''))));
                                    this.advance();
                                    token = var2_8;
                                } else if (CharsKt.isWhitespace((char)c.charValue())) {
                                    Token token8;
                                    Token it = token8 = new Token(TokenType.WHITESPACE, c.toString());
                                    boolean bl = false;
                                    this.advance();
                                    token = token8;
                                } else {
                                    Object[] objectArray = new KFunction[]{this.eq('<'), this.eq('/'), this.eq('>'), this.eq('\"'), this.eq('='), nextTokenImpl.6.INSTANCE};
                                    Token token9 = new Token(TokenType.TEXT, this.readUntil(CollectionsKt.listOf((Object[])objectArray)));
                                    token = token9;
                                }
                            }
                        }
                    }
                }
            }
        }
        return token;
    }

    @NotNull
    public final KFunction<Boolean> eq(char c) {
        return (KFunction)new Function1<Object, Boolean>((Object)Character.valueOf(c)){

            @NotNull
            public final Boolean invoke(@Nullable Object p0) {
                return this.receiver.equals(p0);
            }
        };
    }

    private final String readUntil(List<? extends Function1<? super Character, Boolean>> predicate) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            boolean bl;
            block5: {
                Character c = this.peek();
                if (c == null) {
                    break;
                }
                char c2 = c.charValue();
                Iterable $this$any$iv = predicate;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Function1 it = (Function1)element$iv;
                        boolean bl2 = false;
                        if (!((Boolean)it.invoke((Object)Character.valueOf(c2))).booleanValue()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) break;
            sb.append(this.advance());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

