%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in SLH-DSA-Module-2024.

-module('SLH-DSA-Module-2024').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("SLH-DSA-Module-2024.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'SLH-DSA-Module-2024'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_SLH-DSA-PublicKey'/2,
'enc_SLH-DSA-PrivateKey'/2
]).

-export([
'dec_SLH-DSA-PublicKey'/2,
'dec_SLH-DSA-PrivateKey'/2
]).

-export([
'enc_sa-slh-dsa-sha2-128s'/3,
'enc_sa-slh-dsa-sha2-128f'/3,
'enc_sa-slh-dsa-sha2-192s'/3,
'enc_sa-slh-dsa-sha2-192f'/3,
'enc_sa-slh-dsa-sha2-256s'/3,
'enc_sa-slh-dsa-sha2-256f'/3,
'enc_sa-slh-dsa-shake-128s'/3,
'enc_sa-slh-dsa-shake-128f'/3,
'enc_sa-slh-dsa-shake-192s'/3,
'enc_sa-slh-dsa-shake-192f'/3,
'enc_sa-slh-dsa-shake-256s'/3,
'enc_sa-slh-dsa-shake-256f'/3,
'enc_pk-slh-dsa-sha2-128s'/3,
'enc_pk-slh-dsa-sha2-128f'/3,
'enc_pk-slh-dsa-sha2-192s'/3,
'enc_pk-slh-dsa-sha2-192f'/3,
'enc_pk-slh-dsa-sha2-256s'/3,
'enc_pk-slh-dsa-sha2-256f'/3,
'enc_pk-slh-dsa-shake-128s'/3,
'enc_pk-slh-dsa-shake-128f'/3,
'enc_pk-slh-dsa-shake-192s'/3,
'enc_pk-slh-dsa-shake-192f'/3,
'enc_pk-slh-dsa-shake-256s'/3,
'enc_pk-slh-dsa-shake-256f'/3,
'enc_sa-slh-dsa-shake-192f_smimeCaps'/3,
'enc_sa-slh-dsa-shake-192s_smimeCaps'/3,
'enc_sa-slh-dsa-shake-128f_smimeCaps'/3,
'enc_sa-slh-dsa-shake-128s_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-256f_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-256s_smimeCaps'/3,
'enc_sa-slh-dsa-shake-256f_smimeCaps'/3,
'enc_sa-slh-dsa-shake-256s_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-192f_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-192s_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-128f_smimeCaps'/3,
'enc_sa-slh-dsa-sha2-128s_smimeCaps'/3
]).

-export([
'dec_sa-slh-dsa-sha2-128s'/3,
'dec_sa-slh-dsa-sha2-128f'/3,
'dec_sa-slh-dsa-sha2-192s'/3,
'dec_sa-slh-dsa-sha2-192f'/3,
'dec_sa-slh-dsa-sha2-256s'/3,
'dec_sa-slh-dsa-sha2-256f'/3,
'dec_sa-slh-dsa-shake-128s'/3,
'dec_sa-slh-dsa-shake-128f'/3,
'dec_sa-slh-dsa-shake-192s'/3,
'dec_sa-slh-dsa-shake-192f'/3,
'dec_sa-slh-dsa-shake-256s'/3,
'dec_sa-slh-dsa-shake-256f'/3,
'dec_pk-slh-dsa-sha2-128s'/3,
'dec_pk-slh-dsa-sha2-128f'/3,
'dec_pk-slh-dsa-sha2-192s'/3,
'dec_pk-slh-dsa-sha2-192f'/3,
'dec_pk-slh-dsa-sha2-256s'/3,
'dec_pk-slh-dsa-sha2-256f'/3,
'dec_pk-slh-dsa-shake-128s'/3,
'dec_pk-slh-dsa-shake-128f'/3,
'dec_pk-slh-dsa-shake-192s'/3,
'dec_pk-slh-dsa-shake-192f'/3,
'dec_pk-slh-dsa-shake-256s'/3,
'dec_pk-slh-dsa-shake-256f'/3,
'dec_sa-slh-dsa-shake-192f_smimeCaps'/3,
'dec_sa-slh-dsa-shake-192s_smimeCaps'/3,
'dec_sa-slh-dsa-shake-128f_smimeCaps'/3,
'dec_sa-slh-dsa-shake-128s_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-256f_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-256s_smimeCaps'/3,
'dec_sa-slh-dsa-shake-256f_smimeCaps'/3,
'dec_sa-slh-dsa-shake-256s_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-192f_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-192s_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-128f_smimeCaps'/3,
'dec_sa-slh-dsa-sha2-128s_smimeCaps'/3
]).

-export([
getenc_SignatureAlgorithmSet/1,
getenc_SMimeCaps/1
]).

-export([
getdec_SignatureAlgorithmSet/1,
getdec_SMimeCaps/1
]).

-export([
nistAlgorithms/0,
sigAlgs/0,
'id-slh-dsa-sha2-128s'/0,
'id-slh-dsa-sha2-128f'/0,
'id-slh-dsa-sha2-192s'/0,
'id-slh-dsa-sha2-192f'/0,
'id-slh-dsa-sha2-256s'/0,
'id-slh-dsa-sha2-256f'/0,
'id-slh-dsa-shake-128s'/0,
'id-slh-dsa-shake-128f'/0,
'id-slh-dsa-shake-192s'/0,
'id-slh-dsa-shake-192f'/0,
'id-slh-dsa-shake-256s'/0,
'id-slh-dsa-shake-256f'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('SLH-DSA-PublicKey', Data) -> 'enc_SLH-DSA-PublicKey'(Data);
encode_disp('SLH-DSA-PrivateKey', Data) -> 'enc_SLH-DSA-PrivateKey'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('SLH-DSA-PublicKey', Data) -> 'dec_SLH-DSA-PublicKey'(Data);
decode_disp('SLH-DSA-PrivateKey', Data) -> 'dec_SLH-DSA-PrivateKey'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  SLH-DSA-PublicKey
%%================================
'enc_SLH-DSA-PublicKey'(Val) ->
    'enc_SLH-DSA-PublicKey'(Val, [<<4>>]).

'enc_SLH-DSA-PublicKey'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_SLH-DSA-PublicKey'(Tlv) ->
   'dec_SLH-DSA-PublicKey'(Tlv, [4]).

'dec_SLH-DSA-PublicKey'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 32 =< C1, C1 =< 64 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SLH-DSA-PrivateKey
%%================================
'enc_SLH-DSA-PrivateKey'(Val) ->
    'enc_SLH-DSA-PrivateKey'(Val, [<<4>>]).

'enc_SLH-DSA-PrivateKey'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_SLH-DSA-PrivateKey'(Tlv) ->
   'dec_SLH-DSA-PrivateKey'(Tlv, [4]).

'dec_SLH-DSA-PrivateKey'(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 64 =< C1, C1 =< 128 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.

nistAlgorithms() ->
{2,16,840,1,101,3,4}.

sigAlgs() ->
{2,16,840,1,101,3,4,3}.

'id-slh-dsa-sha2-128s'() ->
{2,16,840,1,101,3,4,3,20}.

'id-slh-dsa-sha2-128f'() ->
{2,16,840,1,101,3,4,3,21}.

'id-slh-dsa-sha2-192s'() ->
{2,16,840,1,101,3,4,3,22}.

'id-slh-dsa-sha2-192f'() ->
{2,16,840,1,101,3,4,3,23}.

'id-slh-dsa-sha2-256s'() ->
{2,16,840,1,101,3,4,3,24}.

'id-slh-dsa-sha2-256f'() ->
{2,16,840,1,101,3,4,3,25}.

'id-slh-dsa-shake-128s'() ->
{2,16,840,1,101,3,4,3,26}.

'id-slh-dsa-shake-128f'() ->
{2,16,840,1,101,3,4,3,27}.

'id-slh-dsa-shake-192s'() ->
{2,16,840,1,101,3,4,3,28}.

'id-slh-dsa-shake-192f'() ->
{2,16,840,1,101,3,4,3,29}.

'id-slh-dsa-shake-256s'() ->
{2,16,840,1,101,3,4,3,30}.

'id-slh-dsa-shake-256f'() ->
{2,16,840,1,101,3,4,3,31}.




%%================================
%%  sa-slh-dsa-sha2-128s
%%================================
'enc_sa-slh-dsa-sha2-128s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-128s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-128s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-128s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-128s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-128s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-128s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-128s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-sha2-128f
%%================================
'enc_sa-slh-dsa-sha2-128f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-128f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-128f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-128f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-128f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-128f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-128f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-128f_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-sha2-192s
%%================================
'enc_sa-slh-dsa-sha2-192s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-192s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-192s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-192s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-192s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-192s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-192s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-192s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-sha2-192f
%%================================
'enc_sa-slh-dsa-sha2-192f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-192f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-192f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-192f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-192f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-192f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-192f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-192f_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-sha2-256s
%%================================
'enc_sa-slh-dsa-sha2-256s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-256s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-256s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-256s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-256s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-256s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-256s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-256s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-sha2-256f
%%================================
'enc_sa-slh-dsa-sha2-256f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-256f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-sha2-256f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-sha2-256f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-sha2-256f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-256f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-sha2-256f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-sha2-256f_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-128s
%%================================
'enc_sa-slh-dsa-shake-128s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-128s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-128s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-128s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-128s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-128s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-128s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-128s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-128f
%%================================
'enc_sa-slh-dsa-shake-128f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-128f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-128f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-128f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-128f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-128f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-128f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-128f_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-192s
%%================================
'enc_sa-slh-dsa-shake-192s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-192s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-192s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-192s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-192s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-192s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-192s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-192s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-192f
%%================================
'enc_sa-slh-dsa-shake-192f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-192f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-192f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-192f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-192f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-192f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-192f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-192f_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-256s
%%================================
'enc_sa-slh-dsa-shake-256s'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-256s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-256s'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-256s_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-256s'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-256s'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-256s'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-256s_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-slh-dsa-shake-256f
%%================================
'enc_sa-slh-dsa-shake-256f'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-256f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-slh-dsa-shake-256f'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-slh-dsa-shake-256f_smimeCaps'(H, Val, T).


'dec_sa-slh-dsa-shake-256f'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-256f'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-slh-dsa-shake-256f'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-slh-dsa-shake-256f_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-slh-dsa-sha2-128s
%%================================
'enc_pk-slh-dsa-sha2-128s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-128s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-128s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-128s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-128s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-128s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-sha2-128f
%%================================
'enc_pk-slh-dsa-sha2-128f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-128f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-128f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-128f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-128f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-128f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-sha2-192s
%%================================
'enc_pk-slh-dsa-sha2-192s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-192s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-192s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-192s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-192s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-192s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-sha2-192f
%%================================
'enc_pk-slh-dsa-sha2-192f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-192f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-192f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-192f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-192f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-192f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-sha2-256s
%%================================
'enc_pk-slh-dsa-sha2-256s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-256s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-256s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-256s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-256s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-256s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-sha2-256f
%%================================
'enc_pk-slh-dsa-sha2-256f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-256f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-sha2-256f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-sha2-256f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-256f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-sha2-256f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-128s
%%================================
'enc_pk-slh-dsa-shake-128s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-128s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-128s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-128s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-128s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-128s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-128f
%%================================
'enc_pk-slh-dsa-shake-128f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-128f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-128f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-128f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-128f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-128f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-192s
%%================================
'enc_pk-slh-dsa-shake-192s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-192s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-192s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-192s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-192s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-192s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-192f
%%================================
'enc_pk-slh-dsa-shake-192f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-192f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-192f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-192f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-192f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-192f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-256s
%%================================
'enc_pk-slh-dsa-shake-256s'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-256s'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-256s'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-256s'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-256s'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-256s'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  pk-slh-dsa-shake-256f
%%================================
'enc_pk-slh-dsa-shake-256f'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-256f'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-slh-dsa-shake-256f'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-slh-dsa-shake-256f'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-256f'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-slh-dsa-shake-256f'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-192f_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-192f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-192f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-192s_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-192s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-192s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-128f_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-128f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-128f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-128s_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-128s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-128s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-256f_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-256f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-256f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-256s_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-256s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-256s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-256f_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-256f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-256f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-shake-256s_smimeCaps
%%================================
'enc_sa-slh-dsa-shake-256s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-shake-256s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-192f_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-192f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-192f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-192s_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-192s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-192s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-128f_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-128f_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-128f_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-slh-dsa-sha2-128s_smimeCaps
%%================================
'enc_sa-slh-dsa-sha2-128s_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-slh-dsa-sha2-128s_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  SignatureAlgorithmSet
%%================================
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,20} ->
    fun 'enc_sa-slh-dsa-sha2-128s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,21} ->
    fun 'enc_sa-slh-dsa-sha2-128f'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,22} ->
    fun 'enc_sa-slh-dsa-sha2-192s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,23} ->
    fun 'enc_sa-slh-dsa-sha2-192f'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,24} ->
    fun 'enc_sa-slh-dsa-sha2-256s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,25} ->
    fun 'enc_sa-slh-dsa-sha2-256f'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,26} ->
    fun 'enc_sa-slh-dsa-shake-128s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,27} ->
    fun 'enc_sa-slh-dsa-shake-128f'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,28} ->
    fun 'enc_sa-slh-dsa-shake-192s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,29} ->
    fun 'enc_sa-slh-dsa-shake-192f'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,30} ->
    fun 'enc_sa-slh-dsa-shake-256s'/3;
getenc_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,31} ->
    fun 'enc_sa-slh-dsa-shake-256f'/3;
getenc_SignatureAlgorithmSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,20} ->
    fun 'dec_sa-slh-dsa-sha2-128s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,21} ->
    fun 'dec_sa-slh-dsa-sha2-128f'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,22} ->
    fun 'dec_sa-slh-dsa-sha2-192s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,23} ->
    fun 'dec_sa-slh-dsa-sha2-192f'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,24} ->
    fun 'dec_sa-slh-dsa-sha2-256s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,25} ->
    fun 'dec_sa-slh-dsa-sha2-256f'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,26} ->
    fun 'dec_sa-slh-dsa-shake-128s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,27} ->
    fun 'dec_sa-slh-dsa-shake-128f'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,28} ->
    fun 'dec_sa-slh-dsa-shake-192s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,29} ->
    fun 'dec_sa-slh-dsa-shake-192f'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,30} ->
    fun 'dec_sa-slh-dsa-shake-256s'/3;
getdec_SignatureAlgorithmSet(Id) when Id =:= {2,16,840,1,101,3,4,3,31} ->
    fun 'dec_sa-slh-dsa-shake-256f'/3;
getdec_SignatureAlgorithmSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCaps
%%================================
getenc_SMimeCaps({2,16,840,1,101,3,4,3,20}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,21}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,22}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,23}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,24}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,25}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,27}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,28}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,29}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,30}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({2,16,840,1,101,3,4,3,31}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,20}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,21}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,22}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,23}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,24}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,25}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,27}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,28}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,29}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,30}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({2,16,840,1,101,3,4,3,31}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCaps(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).
