/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.util.ManifestEntryVerifier;

public class JarInputStream
extends ZipInputStream {
    private Manifest man;
    private JarEntry first;
    private JarVerifier jv;
    private ManifestEntryVerifier mev;
    private final boolean doVerify;
    private boolean tryManifest;

    public JarInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public JarInputStream(InputStream inputStream, boolean bl) throws IOException {
        super(inputStream);
        this.doVerify = bl;
        JarEntry jarEntry = (JarEntry)super.getNextEntry();
        if (jarEntry != null && jarEntry.getName().equalsIgnoreCase("META-INF/")) {
            jarEntry = (JarEntry)super.getNextEntry();
        }
        this.first = this.checkManifest(jarEntry);
    }

    private JarEntry checkManifest(JarEntry jarEntry) throws IOException {
        if (jarEntry != null && "META-INF/MANIFEST.MF".equalsIgnoreCase(jarEntry.getName())) {
            JarEntry jarEntry2;
            this.man = new Manifest();
            byte[] byArray = this.getBytes(new BufferedInputStream(this));
            this.man.read(new ByteArrayInputStream(byArray));
            this.closeEntry();
            if (this.doVerify) {
                this.jv = new JarVerifier(jarEntry.getName(), byArray);
                this.mev = new ManifestEntryVerifier(this.man, this.jv.manifestName);
            }
            if ((jarEntry2 = (JarEntry)super.getNextEntry()) != null && "META-INF/MANIFEST.MF".equalsIgnoreCase(jarEntry2.getName())) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("WARNING: Multiple MANIFEST.MF found. Treat JAR file as unsigned.");
                }
                this.jv = null;
                this.mev = null;
            }
            return jarEntry2;
        }
        return jarEntry;
    }

    private byte[] getBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Manifest getManifest() {
        return this.man;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        JarEntry jarEntry;
        if (this.first == null) {
            jarEntry = (JarEntry)super.getNextEntry();
            if (this.tryManifest) {
                jarEntry = this.checkManifest(jarEntry);
                this.tryManifest = false;
            }
        } else {
            jarEntry = this.first;
            if (this.first.getName().equalsIgnoreCase("META-INF/INDEX.LIST")) {
                this.tryManifest = true;
            }
            this.first = null;
        }
        if (this.jv != null && jarEntry != null) {
            if (this.jv.nothingToVerify()) {
                this.jv = null;
                this.mev = null;
            } else {
                this.jv.beginEntry(jarEntry, this.mev);
            }
        }
        return jarEntry;
    }

    public JarEntry getNextJarEntry() throws IOException {
        return (JarEntry)this.getNextEntry();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.first == null ? super.read(byArray, n, n2) : -1;
        if (this.jv != null) {
            this.jv.update(n3, byArray, n, n2, this.mev);
        }
        return n3;
    }

    @Override
    protected ZipEntry createZipEntry(String string) {
        JarEntry jarEntry = new JarEntry(string);
        if (this.man != null) {
            jarEntry.attr = this.man.getAttributes(string);
        }
        return jarEntry;
    }
}

