/* Benchmarks for multibyte functions.
   Copyright (C) 2023-2024 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#include "striconv.h"

/* Quintus Horatius Flaccus
   Sermones
   Liber I, Sermo IX
 */
static char const text_latin_ascii[] =
#define TEXT_LATIN_ASCII_LINE1 \
  "ibam forte via sacra, sicut meus est mos,\n"
  TEXT_LATIN_ASCII_LINE1
  "nescio quid meditans nugarum, totus in illis:\n"
  "accurrit quidam notus mihi nomine tantum\n"
  "arreptaque manu 'quid agis, dulcissime rerum?'\n"
  "'suaviter, ut nunc est,' inquam 'et cupio omnia quae vis.'\n"
  "cum adsectaretur, 'numquid vis?' occupo. at ille\n"
  "'noris nos' inquit; 'docti sumus.' hic ego 'pluris\n"
  "hoc' inquam 'mihi eris.' misere discedere quaerens\n"
  "ire modo ocius, interdum consistere, in aurem\n"
  "dicere nescio quid puero, cum sudor ad imos\n"
  "manaret talos. 'o te, Bolane, cerebri\n"
  "felicem' aiebam tacitus, cum quidlibet ille\n"
  "garriret, vicos, urbem laudaret. ut illi\n"
  "nil respondebam, 'misere cupis' inquit 'abire:\n"
  "iamdudum video; sed nil agis: usque tenebo;\n"
  "persequar hinc quo nunc iter est tibi.' 'nil opus est te\n"
  "circumagi: quendam volo visere non tibi notum;\n"
  "trans Tiberim longe cubat is prope Caesaris hortos.'\n"
  "'nil habeo quod agam et non sum piger: usque sequar te.'\n"
  "demitto auriculas, ut iniquae mentis asellus,\n"
  "cum gravius dorso subiit onus. incipit ille:\n"
  "'si bene me novi, non Viscum pluris amicum,\n"
  "non Varium facies; nam quis me scribere pluris\n"
  "aut citius possit versus? quis membra movere\n"
  "mollius? invideat quod et Hermogenes, ego canto.'\n"
  "interpellandi locus hic erat 'est tibi mater,\n"
  "cognati, quis te salvo est opus?' 'haud mihi quisquam.\n"
  "omnis conposui.' 'felices. nunc ego resto.\n"
  "confice; namque instat fatum mihi triste, Sabella\n"
  "quod puero cecinit divina mota anus urna:\n"
  "\"hunc neque dira venena nec hosticus auferet ensis\n"
  "nec laterum dolor aut tussis nec tarda podagra:\n"
  "garrulus hunc quando consumet cumque: loquaces,\n"
  "si sapiat, vitet, simul atque adoleverit aetas.\"'\n"
  "ventum erat ad Vestae, quarta iam parte diei\n"
  "praeterita, et casu tum respondere vadato\n"
  "debebat, quod ni fecisset, perdere litem.\n"
  "'si me amas,' inquit 'paulum hic ades.' 'inteream, si\n"
  "aut valeo stare aut novi civilia iura;\n"
  "et propero quo scis.' 'dubius sum, quid faciam', inquit,\n"
  "'tene relinquam an rem.' 'me, sodes.' 'non faciam' ille,\n"
  "et praecedere coepit; ego, ut contendere durum\n"
  "cum victore, sequor. 'Maecenas quomodo tecum?'\n"
  "hinc repetit. 'paucorum hominum et mentis bene sanae.'\n"
  "nemo dexterius fortuna est usus. haberes\n"
  "magnum adiutorem, posset qui ferre secundas,\n"
  "hunc hominem velles si tradere: dispeream, ni\n"
  "summosses omnis.' 'non isto vivimus illic,\n"
  "quo tu rere, modo; domus hac nec purior ulla est\n"
  "nec magis his aliena malis; nil mi officit, inquam,\n"
  "ditior hic aut est quia doctior; est locus uni\n"
  "cuique suus.' 'magnum narras, vix credibile.' 'atqui\n"
  "sic habet.' 'accendis quare cupiam magis illi\n"
  "proximus esse.' 'velis tantummodo: quae tua virtus,\n"
  "expugnabis: et est qui vinci possit eoque\n"
  "difficilis aditus primos habet.' 'haud mihi dero:\n"
  "muneribus servos corrumpam; non, hodie si\n"
  "exclusus fuero, desistam; tempora quaeram,\n"
  "occurram in triviis, deducam. nil sine magno\n"
  "vita labore dedit mortalibus.' haec dum agit, ecce\n"
  "Fuscus Aristius occurrit, mihi carus et illum\n"
  "qui pulchre nosset. consistimus. 'unde venis et\n"
  "quo tendis?' rogat et respondet. vellere coepi\n"
  "et pressare manu lentissima bracchia, nutans,\n"
  "distorquens oculos, ut me eriperet. male salsus\n"
  "ridens dissimulare; meum iecur urere bilis.\n"
  "'certe nescio quid secreto velle loqui te\n"
  "aiebas mecum.' 'memini bene, sed meliore\n"
  "tempore dicam; hodie tricensima sabbata: vin tu\n"
  "curtis Iudaeis oppedere?' 'nulla mihi' inquam\n"
  "'relligio est.' 'at mi: sum paulo infirmior, unus\n"
  "multorum. ignosces; alias loquar.' huncine solem\n"
  "tam nigrum surrexe mihi! fugit inprobus ac me\n"
  "sub cultro linquit. casu venit obvius illi\n"
  "adversarius et 'quo tu, turpissime?' magna\n"
  "inclamat voce, et 'licet antestari?' ego vero\n"
  "oppono auriculam. rapit in ius; clamor utrimque,\n"
  "undique concursus. sic me servavit Apollo.\n"
  ;

static char const text_french_utf8[] =
#define TEXT_FRENCH_UTF8_LINE1 \
  "J'errais par hasard sur une voie sacrée, comme c'est ma coutume,\n"
  TEXT_FRENCH_UTF8_LINE1
  "Méditant je ne sais quoi de frivole, totalement absorbé par ces pensées :\n"
  "Arrive soudain quelqu'un de connu, seulement par son nom,\n"
  "Et me saisissant par la main, il dit : « Comment vas-tu, ô douceur des choses ? »\n"
  "« Agréablement, comme toujours, » dis-je, « et je désire tout ce que tu veux. »\n"
  "Alors qu'il me suivait, je l'interromps : « Veux-tu quelque chose ? » Mais lui,\n"
  "« Tu nous connais », dit-il, « nous sommes cultivés. » Ici, je réponds :\n"
  "« Tu me seras plus précieux à cause de cela. » Misérable, cherchant à partir,\n"
  "À aller maintenant plus vite, parfois à m'arrêter, à murmurer\n"
  "Je ne sais quoi à un garçon à l'oreille, tandis que la sueur descendait\n"
  "Jusqu'à mes chevilles. Silencieusement, je disais : « Ô toi, Bolanus, heureux d'esprit »,\n"
  "Tandis qu'il babillait sur tout et louait les rues et la ville.\n"
  "Comme je ne lui répondais rien, il dit : « Tu as envie de t'en aller misérablement :\n"
  "Je le vois depuis longtemps ; mais tu ne fais rien : je te retiendrai toujours ;\n"
  "Je te poursuivrai là où ton chemin mène maintenant. » « Il n'est pas nécessaire de tourner autour :\n"
  "Je veux rendre visite à quelqu'un qui ne te connaît pas ;\n"
  "Il repose loin au-delà du Tibre, près des jardins de César. »\n"
  "« Je n'ai rien à faire et je ne suis pas paresseux : je te suivrai toujours. »\n"
  "Je baisse les oreilles, comme un âne à l'esprit injuste,\n"
  "Lorsqu'un fardeau plus lourd s'abat sur son dos. Il commence :\n"
  "« Si je me connais bien, tu n'estimes pas plus Visque, mon ami,\n"
  "Ni Varron : car qui peut écrire des vers plus nombreux\n"
  "Et plus rapidement que moi ? Qui peut bouger\n"
  "Les membres plus gracieusement ? Qu'Hermogène l'envie,\n"
  "Je chante mieux que lui. » C'est ici que j'ai l'occasion de l'interrompre :\n"
  "« As-tu une mère, des parents, as-tu besoin de ton salut ? »\n"
  "« Je n'ai besoin de personne. J'ai tout arrangé. »\n"
  "« Heureux homme. Maintenant, je reste.\n"
  "Termine ; car un triste destin m'attend, que la vieille Sibylle\n"
  "A prophétisé pour moi, enfant, en secouant sa divine urne :\n"
  "\"Ni les venins maléfiques, ni l'épée ennemie\n"
  "Ni la douleur des côtes, ni la toux, ni la goutte lente :\n"
  "Ce bavard, chaque fois qu'il consomme, avec l'âge,\n"
  "Évite les bavards s'il a de la sagesse.\" »\n"
  "Nous étions arrivés devant le temple de Vesta, déjà le quart de la journée\n"
  "Passé, et par hasard, à ce moment-là, il devait répondre en caution,\n"
  "Car sinon il perdrait son procès. « Si tu m'aimes », dit-il, « reste ici un peu. »\n"
  "« Que je meure si je connais les lois civiles\n"
  "Ou si je peux me tenir debout ; et je me dépêche où tu le sais. »\n"
  "« Je suis indécis sur ce que je dois faire », dit-il,\n"
  "« Dois-je rester ou partir ? » « Reste, je t'en prie. » « Je ne le ferai pas », dit-il,\n"
  "Et il commença à marcher devant ; moi, comme un adversaire\n"
  "Acharné, je le suivis. « Comment ça va avec toi, Mécène ? »\n"
  "Il reprit à partir de là. « Pour quelques hommes et pour des esprits bien sains. »\n"
  "Personne n'a utilisé la fortune plus habilement. Tu avais\n"
  "Un grand soutien, quelqu'un qui pourrait t'apporter le succès,\n"
  "Si tu voulais livrer cet homme : Que je disparaisse si\n"
  "Tu ne l'avais pas écarté. « Nous ne vivons pas là-bas,\n"
  "Où tu le penses maintenant ; aucune maison n'est plus pure que celle-ci\n"
  "Et aucune n'est plus étrangère à ces maux ; rien ne me gêne, dis-je,\n"
  "Il est plus riche ou plus instruit ; chaque endroit a le sien. »\n"
  "« Tu racontes quelque chose de grand, à peine croyable. » « Et pourtant,\n"
  "C'est ainsi. » « Tu allumes en moi un désir plus grand d'être proche de lui. »\n"
  "« Tu le souhaites seulement : si ta vertu est ce qu'elle est,\n"
  "Tu le conquerras : et il est possible de le vaincre, et il a\n"
  "Une entrée difficile. » « Je ne m'abandonnerai pas :\n"
  "Je corromprai ses esclaves par des cadeaux ; non, même si\n"
  "Je suis exclu aujourd'hui, je n'abandonnerai pas ; je chercherai du temps,\n"
  "Je le rencontrerai aux carrefours, je le ramènerai. Rien n'est donné\n"
  "Aux mortels sans un grand labeur. » Alors qu'il parlait ainsi, voici\n"
  "Que Fuscus Aristius arrive, cher pour moi et qui connaissait aussi\n"
  "Très bien cet homme. Nous nous arrêtons. « D'où viens-tu et\n"
  "Où vas-tu ? » il demande et il répond. J'ai commencé à le tirer\n"
  "Et à presser sa main avec une lenteur extrême, en hochant la tête,\n"
  "En tournant les yeux, pour m'échapper de lui. Souriant malicieusement,\n"
  "Il dissimule mal ; il brûle mon foie de bile.\n"
  "« Certes, tu disais vouloir me dire quelque chose en secret,\n"
  "Toi avec moi. » « Je m'en souviens bien, mais je le dirai à une meilleure\n"
  "Occasion ; aujourd'hui, c'est le trentième sabbat : veux-tu\n"
  "T'opposer aux Juifs superstitieux ? » « Je n'ai aucune\n"
  "Religion. » « Moi, j'en ai un peu, je suis plus faible, l'un\n"
  "Parmi tant d'autres. Tu pardonneras ; je parlerai d'autre chose. »\n"
  "Ce soleil s'est-il levé si sombre pour moi ! Il s'enfuit méchamment et me\n"
  "Laisse sous le couteau. Par hasard, un adversaire vient à sa rencontre,\n"
  "Et lui crie à haute voix : « Où vas-tu, ô le plus vil des hommes ? »\n"
  "Et « Puis-je t'assigner devant un témoin ? » Et moi, bien sûr,\n"
  "Je lui tends l'oreille. Il l'entraîne devant le tribunal ; des cris de part et d'autre,\n"
  "Une foule se rassemble de tous côtés. Ainsi Apollon m'a sauvé.\n"
  ;

static char const *text_french_iso8859;

static char const text_greek_utf8[] =
#define TEXT_GREEK_UTF8_LINE1 \
  "περιπάτων μέντοι κατά την ιερή οδό, όπως είναι η συνήθειά μου,\n"
  TEXT_GREEK_UTF8_LINE1
  "σκεφτόμενος άσχημα πράγματα, πλήρως αφοσιωμένος σε αυτά:\n"
  "έρχεται ένας γνωστός με όνομα μόνον,\n"
  "και αρπάζοντας το χέρι μου, λέει \"τι κάνεις, πιο γλυκέ των πραγμάτων;\"\n"
  "\"υπέροχα,\" απαντώ \"και θέλω ό,τι θέλεις εσύ.\"\n"
  "Όταν αυτός με ακολουθεί, λέω \"θέλεις κάτι;\" και τον προλαβαίνω. Αλλά αυτός\n"
  "λέει \"γνωρίζεις μας, είμαστε παιδεμένοι.\" Τότε εγώ λέω \"θα αξίζεις περισσότερα από αυτό.\"\n"
  "Επιζητώντας απεγνωσμένα να απομακρυνθεί,\n"
  "πηγαίνω ταχύτερα, μερικές φορές σταματώ, και προς το αυτί του αγοριού\n"
  "λέω κάτι, ενώ ο ιδρώτας κυλά στους αστραγάλους μου.\n"
  "\"Ω, Βόλανε, ευτυχισμένε τον νου σου\" λέω στον εαυτό μου σιωπηλά, ενώ αυτός\n"
  "λαλεί οτιδήποτε, επαινεί τους δρόμους, την πόλη. Επειδή δεν του απαντάω τίποτα,\n"
  "λέει \"θέλεις να φύγεις κακά; το βλέπω εδώ και καιρό, αλλά δεν κάνεις τίποτα· θα σε ακολουθήσω\n"
  "από 'δω που πας τώρα.\" \"Δεν χρειάζεται να περιστρέφεσαι: θέλω να δω κάποιον\n"
  "που δεν γνωρίζεις. Κοιμάται μακριά από τον Τίβερη, κοντά στους κήπους του Καίσαρα.\"\n"
  "\"Δεν έχω τίποτα άλλο να κάνω και δεν είμαι αργός: θα σε ακολουθήσω παντού.\"\n"
  "Αφήνω τα αυτιά μου, σαν ένας άτυχος γάιδαρος του νου,\n"
  "όταν φορτώνεται βαριά. Ξεκινάει λοιπόν:\n"
  "\"Αν με ξέρω καλά, δεν θεωρείς τον Βίσκο πιο φίλο,\n"
  "ούτε τον Βάριο· γιατί ποιος μπορεί να γράψει περισσότερα\n"
  "ή πιο γρήγορα ποιήματα; ποιος μπορεί να κινεί τα μέλη\n"
  "πιο απαλά; Ας ζηλεύει αυτόν ο Ερμογένης, εγώ τραγουδώ.\"\n"
  "Εδώ ήταν η ευκαιρία για διακοπή. \"Έχεις μητέρα,\n"
  "συγγενείς, χρειάζεσαι τη βοήθειά τους;\" \"Όχι, δεν χρειάζομαι κανέναν.\n"
  "Έχω οργανώσει τα πάντα.\" \"Είσαι ευτυχής. Εγώ τώρα\n"
  "μένω. Ολοκλήρωσε, γιατί με περιμένει ένα σκοτεινό πεπρωμένο,\n"
  "που προέβλεψε η ιερή γριά με τον κινούμενο αγγείο για το αγόρι:\n"
  "\"Ούτε φονικά φίλτρα ούτε εχθρικό σπαθί\n"
  "ούτε πόνος στο πλευρό ή βήχα ή βηματισμός ποδιού:\n"
  "αυτός ο λαλιάρης, κάποτε θα τον φάει τελείως: λοιπόν, αν είναι έξυπνος,\n"
  "ας τον αποφεύγει, όσο είναι νέος.\"\n"
  "Ήμασταν ήδη στην πλατεία της Βέστης, το τέταρτο μέρος της ημέρας\n"
  "είχε περάσει, και τυχαία έπρεπε να απαντήσει σε κάποιον δικαστή,\n"
  "αλλιώς θα έχανε τη δίκη. \"Αν με αγαπάς,\" λέει, \"μείνε εδώ λίγο.\" \"Να πεθάνω αν\n"
  "μπορώ να σταθώ ή αν γνωρίζω το πολιτικό δίκαιο·\n"
  "και βιάζομαι όπως ξέρεις.\" \"Διστάζω, τι να κάνω,\" λέει,\n"
  "\"να τον αφήσω ή να κρατήσω την υπόθεση.\" \"Εμένα, παρακαλώ.\" \"Δεν θα το κάνω,\" εκείνος λέει,\n"
  "και αρχίζει να προχωρά: εγώ, σαν να παλέυω με το δυσάρεστο\n"
  "νικητή, τον ακολουθώ. \"Μαικηνά, πώς είσαι με τον Μαίκηνα;\" ξαναρχίζει. \"Λέω εγώ.\n"
  "Για μερικούς ανθρώπους και τον νου τους που λειτουργεί καλά.\"\n"
  "Κανείς δεν είχε καλύτερη τύχη από τον Φορτούνατο. Αν είχες\n"
  "έναν μεγάλο βοηθό, που μπορούσε να σε φέρει σε ευνοϊκές θέσεις,\n"
  "θα τον ήθελες να σε παραδώσεις. Ας χαθώ, αν δεν\n"
  "απέκρουε όλους.\" \"Δεν ζούμε εκεί, όπου νομίζεις εσύ· αυτό το σπίτι\n"
  "δεν είναι πιο καθαρό από οποιοδήποτε άλλο,\n"
  "ούτε πιο ξένο σε κακά· δεν με ενοχλεί τίποτα, λέω,\n"
  "είτε είναι πιο πλούσιος ή είτε πιο μορφωμένος· κάθε ένας έχει τον δικό του τόπο.\"\n"
  "\"Μου λες κάτι μεγάλο, μόλις πιστεύω.\" \"Αλλά είναι έτσι.\"\n"
  "\"Ανάβεις την επιθυμία μου να είμαι πιο κοντά σε αυτόν.\" \"Απλά εύχεσαι: αν υπάρχει\n"
  "τέχνη στο να υποτάσσεται κανείς, θα τον κατακτήσεις: και υπάρχει κάποιος που μπορεί να ηττηθεί και γι' αυτό\n"
  "έχει δύσκολη πρόσβαση στην αρχή.\" \"Δεν θα το κάνω αυτό: θα διαφθείρω τους δούλους με δώρα· όχι, αν\n"
  "αποκλειστώ σήμερα, δεν θα εγκαταλείψω· θα βρω καιρό,\n"
  "θα του βρεθώ στις διασταυρώσεις, θα τον συνοδεύσω. Τίποτα δεν δίνεται στους θνητούς χωρίς μεγάλη προσπάθεια.\"\n"
  "Καθώς αυτό είπε, ιδού\n"
  "ο Φούσκος Αρίστιος έρχεται, φίλος μου και τον γνώριζε καλά. Σταθμεύουμε. \"Από πού έρχεσαι και\n"
  "πού πηγαίνεις;\" ρωτά και απαντώ. Άρχισα να τραβάω\n"
  "και να πιέζω τα πιο αργά μπράτσα με το χέρι, κουνώντας\n"
  "τα μάτια μου, για να με απελευθερώσει. Κακόγευστος,\n"
  "γελώντας προσπαθεί να το κρύψει· η χολή μου καίει το συκώτι.\n"
  "\"Σίγουρα είπες ότι θες να μιλήσεις μυστικά\n"
  "μαζί μου.\" \"Θυμάμαι καλά, αλλά θα σου το πω σε καλύτερη\n"
  "στιγμή· σήμερα είναι ο τριακοστός Σάββατος. Θες\n"
  "να πειράξεις τους Ιουδαίους στη συναγωγή;\" \"Για μένα δεν\n"
  "έχει καμία σημασία.\" \"Για μένα ναι: είμαι λίγο πιο αδύναμος, ένας\n"
  "από πολλούς. Θα με συγχωρέσεις· θα μιλήσω αλλού.\" Ο ήλιος\n"
  "αυτός, που ανατέλλει τόσο μαύρος για μένα! Αποδρά, με\n"
  "αφήνει με το μαχαίρι. Τυχαία συναντάει εκείνον τον αντίπαλο\n"
  "και φωνάζει με μεγάλη\n"
  "φωνή, \"Πού πηγαίνεις, εσύ, ελεεινός;\" και \"Μπορώ να μαρτυρήσω;\" Εγώ πραγματικά\n"
  "το αυτί. Τον παρασύρει στη δικαιοσύνη· φωνές από κάθε πλευρά,\n"
  "πλήθος που συρρέει. Έτσι με έσωσε ο Απόλλωνας.\n"
  ;

static char const *text_greek_iso8859;

static char const text_chinese_utf8[] =
#define TEXT_CHINESE_UTF8_LINE1 \
  "我偶然走在圣路上，正如我的习惯，\n"
  TEXT_CHINESE_UTF8_LINE1
  "心里想着一些无聊的事情，全神贯注其中：\n"
  "突然有个熟人从我身边跑过，只知道我的名字，\n"
  "他一把抓住我的手说：“你好，最甜蜜的人！”\n"
  "我说：“很好，就像现在这样，我希望你愿意的一切。”\n"
  "他追问道：“你想做什么吗？”我匆忙回答。但他\n"
  "说：“你认识我们，我们很有学问。”我回答：“你在我眼中\n"
  "更有价值。”我想悲伤地告别，急着走得更快，有时候停下来，\n"
  "低声对一个小男孩说了一些话，汗水流到脚踝上。\n"
  "我默默地说：“哦，波拉斯，你的头脑是幸福的。”他尽情地\n"
  "胡扯，称赞街道，赞美城市。而我却\n"
  "没有回应他，他说：“你真想要离开，\n"
  "我早就知道了，但是你一直没有行动：我会一直陪着你，\n"
  "一直追随你的脚步。”我说：“没必要\n"
  "围绕我转，我想看望一个你不认识的人；\n"
  "他在蒂伯河对岸附近的凯撒花园附近。”\n"
  "“我无所事事，也不懒惰，我会一直跟着你。”\n"
  "我放低耳朵，就像一只不服管束的愚蠢的驴子，\n"
  "当背上的负担更沉重时。他开始说：\n"
  "“如果我了解自己，没有比维斯克斯更亲密的朋友，\n"
  "也没有比瓦里乌斯更有面子的人；因为谁能比我更快地\n"
  "写诗？谁能更优雅地运动肢体？连赫尔莫根尼斯都对此羡慕，\n"
  "我在唱歌。”在此刻插话：“你有母亲，\n"
  "亲戚，需要你吗？” “没有人需要我。\n"
  "我已经和他们都和解了。” “幸福啊，那我留下吧。\n"
  "写完吧，因为悲惨的命运正向我逼近，正如那个塞贝拉\n"
  "通过神圣的缸子预言给孩子的：\n"
  "‘他不会被致命的毒药、敌人的刀剑\n"
  "也不会被腰痛、咳嗽和痛风所杀；\n"
  "这个多话的家伙将一直说下去：假如有智慧，\n"
  "就该避免他，一旦年岁到了就远离他。’”\n"
  "我们到了维斯塔女神庙，已经过去了四分之一天，\n"
  "而他必须即时回应原告的请求，\n"
  "否则将败诉。他说：“如果你爱我，请在这里等一下。”\n"
  "“我会失去一切，如果我无法站立或了解公民的法律；\n"
  "而你知道我正匆匆赶去哪里。” “我很犹豫，不知道该做什么。”他说，\n"
  "“是留下还是走。” “拜托你，求求你。” “我不会这样做。”\n"
  "他开始走在前面，而我像一个与胜利者激烈竞争一样艰难地\n"
  "跟在他后面。 “梅塞纳斯，你和麦克纳斯怎样相处？”他又问了一次。\n"
  "他回答：“我们只和少数人以及头脑健全的人相处。”\n"
  "没有人比他更巧妙地运用运气。如果你有一个\n"
  "强大的帮手，可以承担起成功的重担，\n"
  "你一定会希望将他交给那个人：除非\n"
  "你把所有人都赶走。” “我们不是住在你\n"
  "认为的地方，最近的地方；这里没有比这个更纯净的房子，\n"
  "也没有比这个更遥远的灾难；我告诉你，我并不妨碍你，\n"
  "因为这里更富有也更有学问；每个人都有自己的位置。”\n"
  "“你说得很好，我几乎不能相信。” “然而，情况就是这样。”\n"
  "“你引起了我对他更加亲近的愿望。” “你只是愿意这样，你的才华，\n"
  "你会征服：而且有人可以战胜他，\n"
  "他的第一步是多么困难。” “我不会放弃的：\n"
  "我会用礼物收买奴仆；如果今天\n"
  "被排除在外，我不会放弃；我会寻找机会，\n"
  "在交叉路口遇到你，引领你。生活没有辛劳\n"
  "是不会给予凡人什么的。”当我在说这些话时，突然\n"
  "弗斯库斯·阿里斯提乌斯出现了，他对我和对他\n"
  "都很亲近。我们停下来。“你从哪里来，你要去哪里？”他问，\n"
  "并回答了他的问题。我试图拉他\n"
  "并用我迟缓的手臂拍打他，晃动着，\n"
  "歪曲着眼睛，希望他解救我。他狡猾地\n"
  "笑着假装不知道；我的胆汁烧灼着我的肝脏。\n"
  "“你显然想要和我私下交谈，”\n"
  "你说你会告诉我好的消息，但更好的时机\n"
  "我会在今天的星期三告诉你：你是不是\n"
  "在跟犹太人争论合法性？”我说：“对我来说没有\n"
  "宗教可言。” “但对我来说有：我稍微有些虚弱，是\n"
  "众多人中的一个。原谅我，我会说别的话。”\n"
  "“太阳为什么对我这样黑暗！这个卑鄙的人逃走了，\n"
  "并把我留在刀剑下。偶然地，一个敌人\n"
  "迎面走来，大声喊道：“你这个无耻之徒，你敢\n"
  "宣誓吗？”我当然伸出耳朵。他抓住我去上庭；\n"
  "双方都喊叫着，四处乱哄哄。阿波罗保护着我。\n"
  ;

static char const *text_chinese_gb18030;

/* 2000 random bytes (including NUL bytes) followed by NUL.  Generated by:
   od -An -N2000 -to1 /dev/urandom | sed 's/  *''/\\/g; s/.*''/  "&"/'
   in the C locale.  */
static char const text_random_bytes[] =
  "\002\025\262\356\251\052\313\037\234\000\160\247\162\250\011\140"
  "\212\121\014\223\070\256\312\363\204\362\130\226\374\256\365\364"
  "\173\131\373\270\066\034\021\216\072\021\050\250\106\146\167\327"
  "\031\301\160\324\346\334\250\111\066\377\315\004\355\167\225\176"
  "\257\070\334\005\354\337\320\037\272\172\156\042\312\077\134\217"
  "\116\240\022\232\014\244\225\114\354\204\224\212\130\062\360\312"
  "\076\323\154\332\127\230\050\377\263\165\346\371\244\070\140\120"
  "\371\313\311\232\256\244\150\003\320\132\045\257\001\112\057\264"
  "\111\334\370\033\022\246\347\224\032\112\130\166\263\140\204\310"
  "\323\315\214\265\313\172\275\100\020\311\215\207\061\031\000\101"
  "\132\044\050\020\372\003\011\347\135\120\026\367\376\213\336\061"
  "\117\223\005\217\330\217\227\121\134\011\353\137\247\255\000\353"
  "\376\147\004\152\261\306\106\341\364\355\067\047\261\167\076\066"
  "\102\353\026\203\165\226\245\270\036\222\003\134\112\200\375\314"
  "\204\023\351\021\240\123\211\165\103\210\100\030\377\205\162\307"
  "\027\024\342\231\216\121\113\243\151\243\045\237\351\346\016\320"
  "\374\127\314\272\226\371\072\030\134\021\311\202\252\060\263\305"
  "\262\261\043\065\341\265\364\225\047\140\347\025\073\054\060\053"
  "\345\202\031\234\246\201\164\313\251\076\022\214\121\331\376\160"
  "\237\145\122\264\214\073\277\254\020\020\322\030\006\221\261\355"
  "\366\023\162\326\137\147\137\132\005\223\312\123\103\330\127\341"
  "\207\240\175\036\277\075\213\255\031\223\366\060\350\361\271\122"
  "\274\145\174\030\333\230\077\323\104\031\062\374\077\345\276\154"
  "\224\006\346\376\101\040\156\060\227\172\336\156\305\050\225\236"
  "\207\233\253\232\062\021\003\110\035\266\315\342\114\162\126\050"
  "\146\216\165\345\125\061\137\350\307\236\205\350\026\221\267\305"
  "\051\115\130\050\103\141\077\251\131\326\262\232\164\060\056\165"
  "\152\027\145\144\323\030\065\247\321\317\153\316\363\232\271\222"
  "\372\012\223\256\064\354\243\305\002\333\075\143\366\214\270\016"
  "\041\320\336\070\250\070\354\354\373\157\365\204\122\215\131\246"
  "\176\147\122\221\101\331\366\001\325\354\271\227\010\152\050\060"
  "\011\254\317\037\107\024\374\127\042\250\012\123\355\216\207\012"
  "\210\007\252\043\244\023\125\142\246\250\325\275\136\247\260\177"
  "\363\063\063\315\263\134\134\347\373\005\001\373\354\274\302\177"
  "\253\343\324\031\050\126\371\251\146\224\276\374\100\054\165\011"
  "\040\032\243\014\320\030\237\111\065\353\043\057\141\343\256\265"
  "\134\221\214\250\242\171\056\277\146\370\031\057\334\352\235\154"
  "\240\233\027\106\206\317\237\236\356\325\241\272\064\137\227\263"
  "\371\043\003\327\117\320\026\313\323\244\077\174\067\273\136\213"
  "\370\057\170\024\266\046\075\045\234\257\311\230\216\303\367\357"
  "\217\021\312\241\210\323\341\220\331\017\354\113\054\171\377\007"
  "\341\171\157\145\371\025\005\112\137\241\271\352\156\161\107\231"
  "\006\365\331\020\023\366\337\336\341\352\014\213\045\337\206\032"
  "\116\230\206\000\353\074\311\240\102\004\124\251\212\261\336\322"
  "\251\344\347\040\205\025\267\324\315\142\164\366\330\047\066\122"
  "\205\270\200\316\142\252\351\246\350\122\217\336\222\266\350\124"
  "\350\370\170\360\256\066\206\043\175\335\054\037\112\131\166\266"
  "\245\054\221\370\370\344\310\332\006\253\317\071\161\310\243\035"
  "\367\212\233\274\043\331\140\212\353\017\022\277\162\020\027\356"
  "\130\040\140\350\016\205\311\156\102\144\250\100\123\334\374\300"
  "\171\353\317\273\126\204\016\200\346\155\172\016\047\357\135\277"
  "\045\216\276\214\017\202\231\000\377\176\005\043\301\277\274\052"
  "\223\101\127\212\260\123\011\051\067\110\330\322\061\272\225\127"
  "\061\011\031\305\043\243\352\376\376\257\035\050\304\267\174\177"
  "\021\171\220\356\004\166\036\307\044\005\305\266\136\042\156\043"
  "\240\226\115\021\202\020\354\011\042\355\156\237\323\006\164\317"
  "\054\212\330\361\373\114\324\325\136\041\367\024\025\247\330\207"
  "\136\075\004\067\220\036\034\231\166\135\066\366\041\061\055\256"
  "\370\340\323\026\234\333\356\076\174\267\124\104\265\050\035\061"
  "\102\052\157\034\167\217\362\031\064\035\313\276\334\317\223\363"
  "\166\306\004\341\010\204\216\066\325\073\170\000\024\263\366\116"
  "\336\346\023\244\242\334\002\376\257\266\312\004\275\047\272\161"
  "\317\373\307\146\252\150\007\072\363\014\166\204\370\303\211\044"
  "\352\152\076\226\017\252\223\054\126\111\121\315\301\305\111\117"
  "\375\204\120\337\152\125\153\320\012\224\344\051\351\227\164\226"
  "\226\243\167\254\133\133\377\125\101\223\375\147\231\074\307\312"
  "\025\324\156\321\144\154\311\262\241\351\374\341\204\050\343\132"
  "\271\015\176\147\117\354\312\244\360\276\027\142\261\351\321\337"
  "\347\065\353\242\145\253\242\270\347\175\330\070\113\030\307\372"
  "\032\215\304\335\364\062\051\265\040\260\175\312\301\356\164\140"
  "\003\071\305\371\374\270\135\370\324\001\114\011\035\131\036\300"
  "\162\117\245\007\311\240\317\230\166\114\140\054\175\256\026\176"
  "\107\341\217\105\032\142\117\036\127\230\355\223\117\272\003\104"
  "\143\041\140\146\046\004\305\376\047\174\334\033\271\156\026\057"
  "\306\363\160\323\156\151\347\347\232\052\111\321\315\337\174\023"
  "\363\312\044\102\310\116\217\226\052\367\344\342\144\235\146\303"
  "\044\351\375\212\237\052\071\335\173\042\057\105\141\101\164\175"
  "\116\366\040\134\075\125\312\233\216\262\345\362\270\274\111\017"
  "\134\272\126\234\053\066\300\026\151\274\317\213\022\202\372\245"
  "\134\056\000\300\152\265\346\207\272\061\135\055\257\134\100\260"
  "\015\056\015\004\365\365\040\031\047\225\326\135\252\031\071\111"
  "\203\032\174\102\072\013\012\135\152\125\060\201\111\074\112\235"
  "\053\266\077\360\302\226\161\247\005\216\050\122\307\064\112\257"
  "\131\017\354\101\031\226\200\040\353\015\303\073\007\025\376\163"
  "\174\050\125\135\366\064\051\044\306\003\271\057\023\300\265\254"
  "\202\110\171\241\150\207\153\266\304\336\265\052\151\123\345\215"
  "\061\314\310\344\364\161\266\052\010\372\067\007\010\217\121\067"
  "\325\145\350\037\066\333\165\142\233\137\016\313\202\162\354\341"
  "\241\126\337\361\107\062\106\140\222\027\022\260\305\156\206\200"
  "\250\251\347\040\115\157\314\114\336\030\256\134\142\270\340\242"
  "\137\215\317\075\112\073\134\007\353\325\310\036\367\050\102\263"
  "\302\113\311\203\254\152\157\216\314\016\140\143\172\154\150\217"
  "\054\024\376\121\336\204\144\210\311\073\204\160\316\363\113\021"
  "\020\142\251\251\053\372\336\220\107\152\011\064\120\063\017\154"
  "\132\266\012\376\171\174\176\230\053\272\104\055\201\103\234\000"
  "\171\044\000\102\211\365\157\330\321\357\065\025\146\127\212\035"
  "\217\224\101\307\016\221\131\231\266\264\166\245\142\032\141\051"
  "\156\110\253\076\054\322\316\007\274\270\240\131\151\131\037\367"
  "\317\162\313\021\367\224\214\301\070\346\121\242\016\215\337\317"
  "\015\030\221\375\156\335\113\173\037\126\056\045\222\250\236\117"
  "\116\230\366\245\210\007\144\001\326\344\350\051\226\215\266\350"
  "\247\231\021\121\057\167\341\307\211\336\362\244\006\124\321\120"
  "\375\211\074\271\174\166\304\347\164\061\072\254\104\332\373\266"
  "\042\140\031\277\366\171\245\076\003\113\105\044\327\356\053\122"
  "\017\056\317\117\244\133\217\012\357\004\327\236\362\170\266\112"
  "\162\171\276\042\226\145\365\013\360\167\067\363\234\212\211\146"
  "\135\334\126\005\351\317\173\060\311\074\126\162\072\217\141\227"
  "\311\013\074\321\176\371\103\206\266\340\004\046\070\150\356\173"
  "\351\024\322\073\007\207\345\372\344\242\074\006\266\337\214\117"
  "\172\253\340\063\120\052\236\260\150\252\161\334\047\145\154\204"
  "\007\334\374\346\322\241\246\126\123\137\016\315\134\370\126\064"
  "\230\014\107\063\172\371\246\262\211\016\364\215\064\340\046\040"
  "\057\023\016\072\377\013\303\161\273\264\240\152\223\312\361\117"
  "\321\253\232\217\142\054\367\156\210\066\215\203\031\346\377\371"
  "\253\067\001\044\245\177\077\236\170\255\226\331\301\360\216\161"
  "\343\325\267\015\025\165\322\134\113\304\030\047\372\064\176\367"
  "\212\272\325\372\103\126\207\002\022\320\213\174\230\311\012\115"
  "\006\037\204\336\337\116\163\345\143\005\365\012\147\343\213\040"
  "\247\337\207\225\341\346\373\176\214\232\250\275\075\276\054\017"
  "\270\112\220\121\205\061\111\125\256\140\212\163\033\317\234\322"
  "\076\321\243\054\301\273\252\063\106\257\005\176\360\334\370\047"
  "\055\134\056\243\356\004\105\331\014\150\304\366\350\143\142\020"
  "\170\171\324\217\142\041\121\165\375\173\377\255\256\167\000\213"
  "\144\006\122\032\322\355\166\020\361\065\073\336\306\145\004\271"
  "\277\005\016\001\116\371\000\376\033\253\117\114\044\215\314\257"
  ;

static void
text_init ()
{
  text_french_iso8859 = str_iconv (text_french_utf8, "UTF-8", "ISO-8859-1");
  text_greek_iso8859 = str_iconv (text_greek_utf8, "UTF-8", "ISO-8859-7");
  text_chinese_gb18030 = str_iconv (text_chinese_utf8, "UTF-8", "GB18030");
}
