%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/moving-the-ends-of-hairpins.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
ヘアピンの端点は @code{Hairpin} オブジェクトの @code{shorten-pair} を@c
セットすることで移動できます。正の値は端点を右に移動し、負の値は左に@c
移動します。@code{minimum-length} プロパティとは異なり、このプロパティは@c
ヘアピンのみの見た目に影響します。水平方向のスペーシングには影響しません
(始点や終点にある強弱記号もです)。そのため、この方法はヘアピンを割り当てられた@c
領域の中で微調整するのに適しています。
"
  doctitleja = "ヘアピンの端点を移動する"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
Le estremità delle forcelle possono essere spostate in modo relativo alla
loro posizione predefinita (offset) impostando la proprietà @code{shorten-pair}
dell'oggetto @code{Hairpin}.  Valori positivi spostano le estremità a
destra, valori negativi le spostano a sinistra. Diversamente dalla
proprietà @code{minimum-length}, questa proprietà modifica solo l'aspetto
della forcella; non cambia la spaziatura orizzontale (inclusa la posizione
delle dinamiche confinanti).  Questo metodo è quindi utile per ritoccare
una forcella entro lo spazio ad essa allocato.

"
  doctitleit = "Spostare le estremità delle forcelle"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Les terminaisons des soufflets peuvent être décalées en jouant sur la
propriété @code{shorten-pair} de l'objet@code{Hairpin}. Les valeurs
positives déplacent vers l'intérieur, les négatives vers l'extérieur.
Contrairement à la propriété @code{minimum-length}, cette propriété
n'affecte que l'apparence du soufflet sans ajuster l'espacement
horizontal (y compris avec les nuances textuelles). Cette méthode est
donc appropriée aux situations dans lesquelles un soufflet requiert un
ajustement fin dans l'espace qui lui est alloué.
"

  doctitlefr = "Déplacer les extrémités de soufflets"

  lsrtags = "expressive-marks"

  texidoc = "
The ends of hairpins may be offset by setting the @code{shorten-pair}
property of the @code{Hairpin} object.  Positive values move endpoints
to the right, negative to the left.  Unlike the @code{minimum-length}
property, this property only affects the appearance of the hairpin; it
does not adjust horizontal spacing (including the position of bounding
dynamics).  This method is thus suitable for fine-tuning a hairpin
within its allotted space.
"

  doctitle = "Moving the ends of hairpins"
} % begin verbatim


{
  c'1~\<
  c'2~ c'\!
  \once \override Hairpin.shorten-pair = #'(2 . 2)
  c'1~\<
  c'2~ c'\!
  \once \override Hairpin.shorten-pair = #'(-2 . -2)
  c'1~\<
  c'2~ c'\!
  c'1~\p-\tweak shorten-pair #'(2 . 0)\<
  c'2~ c'\ffff
}



% ****************************************************************
% end ly snippet
% ****************************************************************
