%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/positioning-opposing-fermatas-on-a-bar-line.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.13.

\version "2.23.13"

\header {
%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Dans l'extrait suivant est construite une commande qui permet d'imprimer
un point d'orgue à la fois en surplomb et en dessous d'une barre de
mesure. Dans le cas où il n'y aurait normalement pas de barre à cet
endroit, sera ajoutée une double barre. Sémantiquement, cette commande
constuit une césure plus longue que la normale, ce qui pourrait être
considéré comme un usage abusif selon le cas.
"

  doctitlefr = "Positionnement de points d'orgue en opposition sur une barre de mesure"

  lsrtags = "rhythms"

  texidoc = "
This snippet demonstrates a command that prints fermatas both above
and below a bar line.  If there would not otherwise be a bar line, it
adds a double bar line.  Semantically, the command codes a
longer-than-normal caesura, which might be considered misuse depending
on the situation.
"

  doctitle = "Positioning opposing fermatas on a bar line"
} % begin verbatim


twoWayFermata = {
  \once \set Staff.caesuraType = #'((underlying-bar-line . "||"))
  \once \set Staff.caesuraTypeTransform = ##f
  \caesura ^\fermata _\fermata
}

music = {
  f'1 \twoWayFermata
  R1
  f'2 \twoWayFermata f'2
  R1
  b'1 \twoWayFermata \fine
}

\new GrandStaff <<
  \new Staff \music
  \new Staff \music
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
