/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.evaluation.ConfusionMatrix;
import org.tribuo.classification.evaluation.LabelMetric;
import org.tribuo.classification.evaluation.LabelMetrics;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.provenance.EvaluationProvenance;
import org.tribuo.sequence.SequenceEvaluation;

public class LabelSequenceEvaluation
implements SequenceEvaluation<Label> {
    private static final Logger logger = Logger.getLogger(LabelSequenceEvaluation.class.getName());
    private final Map<MetricID<Label>, Double> results;
    private final LabelMetric.Context ctx;
    private final ConfusionMatrix<Label> cm;
    private final EvaluationProvenance provenance;

    protected LabelSequenceEvaluation(Map<MetricID<Label>, Double> results, LabelMetric.Context ctx, EvaluationProvenance provenance) {
        this.results = results;
        this.ctx = ctx;
        this.cm = ctx.getCM();
        this.provenance = provenance;
    }

    public List<Prediction<Label>> getPredictions() {
        return this.ctx.getPredictions();
    }

    public ConfusionMatrix<Label> getConfusionMatrix() {
        return this.cm;
    }

    public Map<MetricID<Label>, Double> asMap() {
        return Collections.unmodifiableMap(this.results);
    }

    public double confusion(Label predictedLabel, Label trueLabel) {
        return this.cm.confusion(predictedLabel, trueLabel);
    }

    public double tp(Label label) {
        return this.get(label, LabelMetrics.TP);
    }

    public double tp() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.TP);
    }

    public double macroTP() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.TP);
    }

    public double fp(Label label) {
        return this.get(label, LabelMetrics.FP);
    }

    public double fp() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.FP);
    }

    public double macroFP() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.FP);
    }

    public double tn(Label label) {
        return this.get(label, LabelMetrics.TN);
    }

    public double tn() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.TN);
    }

    public double macroTN() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.TN);
    }

    public double fn(Label label) {
        return this.get(label, LabelMetrics.FN);
    }

    public double fn() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.FN);
    }

    public double macroFN() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.FN);
    }

    public double precision(Label label) {
        return this.get(label, LabelMetrics.PRECISION);
    }

    public double microAveragedPrecision() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.PRECISION);
    }

    public double macroAveragedPrecision() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.PRECISION);
    }

    public double recall(Label label) {
        return this.get(label, LabelMetrics.RECALL);
    }

    public double microAveragedRecall() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.RECALL);
    }

    public double macroAveragedRecall() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.RECALL);
    }

    public double f1(Label label) {
        return this.get(label, LabelMetrics.RECALL);
    }

    public double microAveragedF1() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.F1);
    }

    public double macroAveragedF1() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.F1);
    }

    public double accuracy() {
        return this.get(EvaluationMetric.Average.MICRO, LabelMetrics.ACCURACY);
    }

    public double accuracy(Label label) {
        return this.get(label, LabelMetrics.ACCURACY);
    }

    public double balancedErrorRate() {
        return this.get(EvaluationMetric.Average.MACRO, LabelMetrics.BALANCED_ERROR_RATE);
    }

    public EvaluationProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        ArrayList labelOrder = new ArrayList(this.cm.getDomain().getDomain());
        StringBuilder sb = new StringBuilder();
        int tp = 0;
        int fn = 0;
        int fp = 0;
        int n = 0;
        int maxLabelSize = "Balanced Error Rate".length();
        for (Label label : labelOrder) {
            maxLabelSize = Math.max(maxLabelSize, label.getLabel().length());
        }
        String labelFormatString = String.format("%%-%ds", maxLabelSize + 2);
        sb.append(String.format(labelFormatString, "Class"));
        sb.append(String.format("%12s%12s%12s%12s", "n", "tp", "fn", "fp"));
        sb.append(String.format("%12s%12s%12s%n", "recall", "prec", "f1"));
        for (Label label : labelOrder) {
            if (this.cm.support(label) == 0.0) continue;
            n = (int)((double)n + this.cm.support(label));
            tp = (int)((double)tp + this.cm.tp(label));
            fn = (int)((double)fn + this.cm.fn(label));
            fp = (int)((double)fp + this.cm.fp(label));
            sb.append(String.format(labelFormatString, label));
            sb.append(String.format("%,12d%,12d%,12d%,12d", (int)this.cm.support(label), (int)this.cm.tp(label), (int)this.cm.fn(label), (int)this.cm.fp(label)));
            sb.append(String.format("%12.3f%12.3f%12.3f%n", this.recall(label), this.precision(label), this.f1(label)));
        }
        sb.append(String.format(labelFormatString, "Total"));
        sb.append(String.format("%,12d%,12d%,12d%,12d%n", n, tp, fn, fp));
        sb.append(String.format(labelFormatString, "Accuracy"));
        sb.append(String.format("%60.3f%n", (double)tp / (double)n));
        sb.append(String.format(labelFormatString, "Micro Average"));
        sb.append(String.format("%60.3f%12.3f%12.3f%n", this.microAveragedRecall(), this.microAveragedPrecision(), this.microAveragedF1()));
        sb.append(String.format(labelFormatString, "Macro Average"));
        sb.append(String.format("%60.3f%12.3f%12.3f%n", this.macroAveragedRecall(), this.macroAveragedPrecision(), this.macroAveragedF1()));
        sb.append(String.format(labelFormatString, "Balanced Error Rate"));
        sb.append(String.format("%60.3f", this.balancedErrorRate()));
        return sb.toString();
    }

    private double get(MetricTarget<Label> tgt, LabelMetrics metric) {
        return this.get(metric.forTarget(tgt).getID());
    }

    private double get(Label label, LabelMetrics metric) {
        return this.get(metric.forTarget((MetricTarget<Label>)new MetricTarget((Output)label)).getID());
    }

    private double get(EvaluationMetric.Average avg, LabelMetrics metric) {
        return this.get(metric.forTarget((MetricTarget<Label>)new MetricTarget(avg)).getID());
    }
}

