/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class CompressPublicKeyOutput {
    private final ByteBuffer compressedPublicKey;

    protected CompressPublicKeyOutput(BuilderImpl builder) {
        this.compressedPublicKey = builder.compressedPublicKey();
    }

    public ByteBuffer compressedPublicKey() {
        return this.compressedPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer compressedPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CompressPublicKeyOutput model) {
            this.compressedPublicKey = model.compressedPublicKey();
        }

        @Override
        public Builder compressedPublicKey(ByteBuffer compressedPublicKey) {
            this.compressedPublicKey = compressedPublicKey;
            return this;
        }

        @Override
        public ByteBuffer compressedPublicKey() {
            return this.compressedPublicKey;
        }

        @Override
        public CompressPublicKeyOutput build() {
            if (Objects.isNull(this.compressedPublicKey())) {
                throw new IllegalArgumentException("Missing value for required field `compressedPublicKey`");
            }
            return new CompressPublicKeyOutput(this);
        }
    }

    public static interface Builder {
        public Builder compressedPublicKey(ByteBuffer var1);

        public ByteBuffer compressedPublicKey();

        public CompressPublicKeyOutput build();
    }
}

