/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;

public class CreateDefaultCryptographicMaterialsManagerInput {
    private final IKeyring keyring;

    protected CreateDefaultCryptographicMaterialsManagerInput(BuilderImpl builder) {
        this.keyring = builder.keyring();
    }

    public IKeyring keyring() {
        return this.keyring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected IKeyring keyring;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateDefaultCryptographicMaterialsManagerInput model) {
            this.keyring = model.keyring();
        }

        @Override
        public Builder keyring(IKeyring keyring) {
            this.keyring = Keyring.wrap(keyring);
            return this;
        }

        @Override
        public IKeyring keyring() {
            return this.keyring;
        }

        @Override
        public CreateDefaultCryptographicMaterialsManagerInput build() {
            if (Objects.isNull(this.keyring())) {
                throw new IllegalArgumentException("Missing value for required field `keyring`");
            }
            return new CreateDefaultCryptographicMaterialsManagerInput(this);
        }
    }

    public static interface Builder {
        public Builder keyring(IKeyring var1);

        public IKeyring keyring();

        public CreateDefaultCryptographicMaterialsManagerInput build();
    }
}

