/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

public class BeaconKeyMaterials {
    private final String beaconKeyIdentifier;
    private final Map<String, String> encryptionContext;
    private final ByteBuffer beaconKey;
    private final Map<String, ByteBuffer> hmacKeys;

    protected BeaconKeyMaterials(BuilderImpl builder) {
        this.beaconKeyIdentifier = builder.beaconKeyIdentifier();
        this.encryptionContext = builder.encryptionContext();
        this.beaconKey = builder.beaconKey();
        this.hmacKeys = builder.hmacKeys();
    }

    public String beaconKeyIdentifier() {
        return this.beaconKeyIdentifier;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public ByteBuffer beaconKey() {
        return this.beaconKey;
    }

    public Map<String, ByteBuffer> hmacKeys() {
        return this.hmacKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String beaconKeyIdentifier;
        protected Map<String, String> encryptionContext;
        protected ByteBuffer beaconKey;
        protected Map<String, ByteBuffer> hmacKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BeaconKeyMaterials model) {
            this.beaconKeyIdentifier = model.beaconKeyIdentifier();
            this.encryptionContext = model.encryptionContext();
            this.beaconKey = model.beaconKey();
            this.hmacKeys = model.hmacKeys();
        }

        @Override
        public Builder beaconKeyIdentifier(String beaconKeyIdentifier) {
            this.beaconKeyIdentifier = beaconKeyIdentifier;
            return this;
        }

        @Override
        public String beaconKeyIdentifier() {
            return this.beaconKeyIdentifier;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder beaconKey(ByteBuffer beaconKey) {
            this.beaconKey = beaconKey;
            return this;
        }

        @Override
        public ByteBuffer beaconKey() {
            return this.beaconKey;
        }

        @Override
        public Builder hmacKeys(Map<String, ByteBuffer> hmacKeys) {
            this.hmacKeys = hmacKeys;
            return this;
        }

        @Override
        public Map<String, ByteBuffer> hmacKeys() {
            return this.hmacKeys;
        }

        @Override
        public BeaconKeyMaterials build() {
            if (Objects.isNull(this.beaconKeyIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `beaconKeyIdentifier`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            return new BeaconKeyMaterials(this);
        }
    }

    public static interface Builder {
        public Builder beaconKeyIdentifier(String var1);

        public String beaconKeyIdentifier();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder beaconKey(ByteBuffer var1);

        public ByteBuffer beaconKey();

        public Builder hmacKeys(Map<String, ByteBuffer> var1);

        public Map<String, ByteBuffer> hmacKeys();

        public BeaconKeyMaterials build();
    }
}

