/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.transport.ProvisionWorkflowAction;
import org.opensearch.flowframework.transport.ReprovisionWorkflowAction;
import org.opensearch.flowframework.transport.ReprovisionWorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.plugins.PluginsService;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class CreateWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(CreateWorkflowTransportAction.class);
    private final WorkflowProcessSorter workflowProcessSorter;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final Client client;
    private final SdkClient sdkClient;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final PluginsService pluginsService;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public CreateWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, WorkflowProcessSorter workflowProcessSorter, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client, SdkClient sdkClient, PluginsService pluginsService, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow/create", transportService, actionFilters, WorkflowRequest::new);
        this.workflowProcessSorter = workflowProcessSorter;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.client = client;
        this.sdkClient = sdkClient;
        this.pluginsService = pluginsService;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> listener) {
        String tenantId;
        String string = tenantId = request.getTemplate() == null ? null : request.getTemplate().getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, listener)) {
            return;
        }
        User user = ParseUtils.getUserContext(this.client);
        String workflowId = request.getWorkflowId();
        try {
            this.resolveUserAndExecute(user, workflowId, tenantId, this.flowFrameworkSettings.isMultiTenancyEnabled(), listener, () -> this.createExecute(request, user, tenantId, listener));
        }
        catch (Exception e) {
            this.logger.error("Failed to create workflow", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void resolveUserAndExecute(User requestedUser, String workflowId, String tenantId, boolean isMultitenancyEnabled, ActionListener<WorkflowResponse> listener, Runnable function) {
        try {
            if (this.filterByEnabled == Boolean.TRUE) {
                try {
                    ParseUtils.checkFilterByBackendRoles(requestedUser);
                }
                catch (FlowFrameworkException e) {
                    this.logger.error(e.getMessage(), (Throwable)((Object)e));
                    listener.onFailure((Exception)((Object)e));
                    return;
                }
            }
            if (workflowId != null) {
                boolean filterByBackendRole = requestedUser == null ? false : this.filterByEnabled;
                ParseUtils.getWorkflow(requestedUser, workflowId, tenantId, filterByBackendRole, false, isMultitenancyEnabled, listener, function, this.client, this.sdkClient, this.clusterService, this.xContentRegistry);
            } else {
                function.run();
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to create or update workflow";
            if (e instanceof FlowFrameworkException) {
                listener.onFailure(e);
            }
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }

    private void createExecute(WorkflowRequest request, User user, String tenantId, ActionListener<WorkflowResponse> listener) {
        Instant creationTime = Instant.now();
        Template templateWithUser = new Template(request.getTemplate().name(), request.getTemplate().description(), request.getTemplate().useCase(), request.getTemplate().templateVersion(), request.getTemplate().compatibilityVersion(), request.getTemplate().workflows(), request.getTemplate().getUiMetadata(), user, creationTime, creationTime, null, tenantId);
        Object[] validateAll = new String[]{"all"};
        if (Arrays.equals(request.getValidation(), validateAll)) {
            try {
                this.validateWorkflows(templateWithUser);
            }
            catch (Exception e) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Workflow validation failed for template {}", (Object)templateWithUser.name()).getFormattedMessage();
                this.logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)(e instanceof FlowFrameworkException ? e : new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                return;
            }
        }
        String workflowId = request.getWorkflowId();
        TimeValue waitForTimeCompletion = request.getParams().containsKey("wait_for_completion_timeout") ? TimeValue.parseTimeValue((String)request.getParams().get("wait_for_completion_timeout"), (String)"wait_for_completion_timeout") : TimeValue.MINUS_ONE;
        if (workflowId == null) {
            this.checkMaxWorkflows(this.flowFrameworkSettings.getRequestTimeout(), this.flowFrameworkSettings.getMaxWorkflows(), tenantId, (ActionListener<Boolean>)ActionListener.wrap(max -> {
                if (Boolean.FALSE.equals(max)) {
                    String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Maximum workflows limit reached: {}", (Object)this.flowFrameworkSettings.getMaxWorkflows()).getFormattedMessage();
                    this.logger.error(errorMessage);
                    FlowFrameworkException ffe = new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
                    listener.onFailure((Exception)((Object)ffe));
                    return;
                }
                this.flowFrameworkIndicesHandler.initializeConfigIndex(tenantId, (ActionListener<Boolean>)ActionListener.wrap(isInitialized -> {
                    if (Boolean.FALSE.equals(isInitialized)) {
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to initalize config index", RestStatus.INTERNAL_SERVER_ERROR)));
                    } else {
                        this.flowFrameworkIndicesHandler.putTemplateToGlobalContext(templateWithUser, (ActionListener<IndexResponse>)ActionListener.wrap(globalContextResponse -> this.flowFrameworkIndicesHandler.putInitialStateToWorkflowState(globalContextResponse.getId(), tenantId, user, (ActionListener<IndexResponse>)ActionListener.wrap(stateResponse -> {
                            this.logger.info("Creating state workflow doc: {}", (Object)globalContextResponse.getId());
                            if (request.isProvision()) {
                                WorkflowRequest workflowRequest = new WorkflowRequest(globalContextResponse.getId(), Template.createEmptyTemplateWithTenantId(tenantId), request.getParams(), waitForTimeCompletion);
                                this.logger.info("Provisioning parameter is set, continuing to provision workflow {}", (Object)globalContextResponse.getId());
                                this.client.execute((ActionType)ProvisionWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(provisionResponse -> listener.onResponse((Object)(workflowRequest.getWaitForCompletionTimeout() == TimeValue.MINUS_ONE ? new WorkflowResponse(provisionResponse.getWorkflowId()) : new WorkflowResponse(provisionResponse.getWorkflowId(), provisionResponse.getWorkflowState()))), exception -> {
                                    String errorMessage = "Provisioning failed.";
                                    this.logger.error(errorMessage, (Throwable)exception);
                                    if (exception instanceof FlowFrameworkException) {
                                        listener.onFailure(exception);
                                    } else {
                                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                                    }
                                }));
                            } else {
                                listener.onResponse((Object)new WorkflowResponse(globalContextResponse.getId()));
                            }
                        }, exception -> {
                            String errorMessage = "Failed to save workflow state";
                            this.logger.error(errorMessage, (Throwable)exception);
                            if (exception instanceof FlowFrameworkException) {
                                listener.onFailure(exception);
                            } else {
                                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                            }
                        })), exception -> {
                            String errorMessage = "Failed to save use case template";
                            this.logger.error(errorMessage, (Throwable)exception);
                            if (exception instanceof FlowFrameworkException) {
                                listener.onFailure(exception);
                            } else {
                                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                            }
                        }));
                    }
                }, exception -> {
                    String errorMessage = "Failed to initialize config index";
                    this.logger.error(errorMessage, (Throwable)exception);
                    if (exception instanceof FlowFrameworkException) {
                        listener.onFailure(exception);
                    } else {
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                }));
            }, exception -> {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update use case template {}", (Object)request.getWorkflowId()).getFormattedMessage();
                this.logger.error(errorMessage, (Throwable)exception);
                if (exception instanceof FlowFrameworkException) {
                    listener.onFailure(exception);
                } else {
                    listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                }
            }));
        } else {
            this.logger.info("Querying existing workflow from global context: {}", (Object)workflowId);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.getDataObjectAsync(((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-flow-framework-templates")).id(workflowId)).tenantId(tenantId)).build()).whenComplete((r, throwable) -> {
                    block5: {
                        if (throwable == null) {
                            context.restore();
                            try {
                                GetResponse getResponse;
                                GetResponse getResponse2 = getResponse = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                                if (getResponse.isExists()) {
                                    this.handleWorkflowExists(request, templateWithUser, getResponse, waitForTimeCompletion, listener);
                                    break block5;
                                }
                                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
                                this.logger.error(errorMessage);
                                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
                            }
                            catch (IOException e) {
                                this.logger.error("Failed to parse workflow getResponse: {}", (Object)workflowId, (Object)e);
                                listener.onFailure((Exception)e);
                            }
                        } else {
                            Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve template ({}) from global context.", (Object)workflowId).getFormattedMessage();
                            this.logger.error(errorMessage, (Throwable)exception);
                            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                        }
                    }
                });
            }
        }
    }

    private void handleWorkflowExists(WorkflowRequest request, Template templateWithUser, GetResponse getResponse, TimeValue waitForTimeCompletion, ActionListener<WorkflowResponse> listener) throws IOException {
        Template template;
        Template existingTemplate = Template.parse(getResponse.getSourceAsString());
        Template template2 = template = request.isUpdateFields() ? Template.updateExistingTemplate(existingTemplate, templateWithUser) : Template.builder(templateWithUser).createdTime(existingTemplate.createdTime()).lastUpdatedTime(Instant.now()).lastProvisionedTime(existingTemplate.lastProvisionedTime()).tenantId(existingTemplate.getTenantId()).build();
        if (request.isReprovision()) {
            this.handleReprovision(request.getWorkflowId(), existingTemplate, template, waitForTimeCompletion, listener);
        } else {
            this.handleFullDocUpdate(request, template, listener);
        }
    }

    private void handleReprovision(String workflowId, Template existingTemplate, Template template, TimeValue waitForTimeCompletion, ActionListener<WorkflowResponse> listener) {
        ReprovisionWorkflowRequest reprovisionRequest = new ReprovisionWorkflowRequest(workflowId, existingTemplate, template, waitForTimeCompletion);
        this.logger.info("Reprovisioning parameter is set, continuing to reprovision workflow {}", (Object)workflowId);
        this.client.execute((ActionType)ReprovisionWorkflowAction.INSTANCE, (ActionRequest)reprovisionRequest, ActionListener.wrap(reprovisionResponse -> listener.onResponse((Object)new WorkflowResponse(reprovisionResponse.getWorkflowId())), exception -> {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Reprovisioning failed for workflow {}", (Object)workflowId).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)exception);
            if (exception instanceof FlowFrameworkException) {
                listener.onFailure(exception);
            } else {
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }
        }));
    }

    private void handleFullDocUpdate(WorkflowRequest request, Template template, ActionListener<WorkflowResponse> listener) {
        boolean isFieldUpdate = request.isUpdateFields();
        this.flowFrameworkIndicesHandler.updateTemplateInGlobalContext(request.getWorkflowId(), template, (ActionListener<IndexResponse>)ActionListener.wrap(response -> {
            if (!isFieldUpdate) {
                this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(request.getWorkflowId(), template.getTenantId(), Map.ofEntries(Map.entry("state", State.NOT_STARTED), Map.entry("provisioning_progress", ProvisioningProgress.NOT_STARTED)), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                    this.logger.info("updated workflow {} state to {}", (Object)request.getWorkflowId(), (Object)State.NOT_STARTED.name());
                    listener.onResponse((Object)new WorkflowResponse(request.getWorkflowId()));
                }, exception -> {
                    String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update workflow {} in template index", (Object)request.getWorkflowId()).getFormattedMessage();
                    this.logger.error(errorMessage, (Throwable)exception);
                    if (exception instanceof FlowFrameworkException) {
                        listener.onFailure(exception);
                    } else {
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                }));
            } else {
                listener.onResponse((Object)new WorkflowResponse(request.getWorkflowId()));
            }
        }, exception -> {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update use case template {}", (Object)request.getWorkflowId()).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)exception);
            if (exception instanceof FlowFrameworkException) {
                listener.onFailure(exception);
            } else {
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }
        }), isFieldUpdate);
    }

    void checkMaxWorkflows(TimeValue requestTimeOut, Integer maxWorkflow, String tenantId, ActionListener<Boolean> internalListener) {
        if (!this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            internalListener.onResponse((Object)true);
        } else {
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(requestTimeOut);
            SearchDataObjectRequest searchRequest = SearchDataObjectRequest.builder().indices(new String[]{".plugins-flow-framework-templates"}).searchSourceBuilder(searchSourceBuilder).tenantId(tenantId).build();
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((r, throwable) -> {
                    if (throwable == null) {
                        context.restore();
                        try {
                            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)r.parser());
                            internalListener.onResponse((Object)(searchResponse.getHits().getTotalHits().value < (long)maxWorkflow.intValue() ? 1 : 0));
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to parse workflow searchResponse", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        String errorMessage = "Unable to fetch the workflows";
                        this.logger.error(errorMessage, (Throwable)exception);
                        internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                });
            }
            catch (Exception e) {
                String errorMessage = "Unable to fetch the workflows";
                this.logger.error(errorMessage, (Throwable)e);
                internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        }
    }

    private void validateWorkflows(Template template) throws Exception {
        for (Workflow workflow : template.workflows().values()) {
            List<ProcessNode> sortedNodes = this.workflowProcessSorter.sortProcessNodes(workflow, null, Collections.emptyMap(), template.getTenantId());
            this.workflowProcessSorter.validate(sortedNodes, this.pluginsService);
        }
    }
}

