/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.command.Command;
import com.oracle.labs.mlrg.olcut.command.CommandGroup;
import com.oracle.labs.mlrg.olcut.command.CommandInterpreter;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.NullCompleter;
import org.tribuo.Model;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;

public class ModelExplorer
implements CommandGroup {
    private static final Logger logger = Logger.getLogger(ModelExplorer.class.getName());
    private final CommandInterpreter shell = new CommandInterpreter();
    private Model<?> model;

    public ModelExplorer() {
        this.shell.setPrompt("model sh% ");
    }

    public String getName() {
        return "Model Explorer";
    }

    public String getDescription() {
        return "Commands for inspecting a Model.";
    }

    public Completer[] fileCompleter() {
        return new Completer[]{new Completers.FileNameCompleter(), new NullCompleter()};
    }

    public void startShell() {
        this.shell.add((CommandGroup)this);
        this.shell.start();
    }

    @Command(usage="<filename> - Load a model from disk.", completers="fileCompleter")
    public String loadModel(CommandInterpreter ci, File path) {
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));){
            this.model = (Model)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to load class from stream " + path.getAbsolutePath(), e);
            return "Failed to load model";
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to open file " + path.getAbsolutePath(), e);
            return "Failed to load model";
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException when reading from file " + path.getAbsolutePath(), e);
            return "Failed to load model";
        }
        return "Loaded model from path " + path.toString();
    }

    @Command(usage="Does the model generate probabilities")
    public String generatesProbabilities(CommandInterpreter ci) {
        return "" + this.model.generatesProbabilities();
    }

    @Command(usage="Shows the model provenance")
    public String modelProvenance(CommandInterpreter ci) {
        return this.model.getProvenance().toString();
    }

    @Command(usage="Shows the information on a particular feature")
    public String featureInfo(CommandInterpreter ci, String featureName) {
        VariableIDInfo f = this.model.getFeatureIDMap().get(featureName);
        if (f != null) {
            return "" + f.toString();
        }
        return "Feature " + featureName + " not found.";
    }

    @Command(usage="Shows the output information.")
    public String outputInfo(CommandInterpreter ci) {
        return this.model.getOutputIDInfo().toReadableString();
    }

    @Command(usage="<int> - Shows the top N features in the model")
    public String topFeatures(CommandInterpreter ci, int numFeatures) {
        return "" + this.model.getTopFeatures(numFeatures);
    }

    @Command(usage="Shows the number of features in the model")
    public String numFeatures(CommandInterpreter ci) {
        return "" + this.model.getFeatureIDMap().size();
    }

    @Command(usage="<min count> - Shows the number of features that occurred more than min count times.")
    public String minCount(CommandInterpreter ci, int minCount) {
        int counter = 0;
        for (VariableInfo f : this.model.getFeatureIDMap()) {
            if (f.getCount() <= minCount) continue;
            ++counter;
        }
        return counter + " features occurred more than " + minCount + " times.";
    }

    public static void main(String[] args) {
        ModelExplorerOptions options = new ModelExplorerOptions();
        ConfigurationManager cm = new ConfigurationManager(args, (Options)options, false);
        ModelExplorer driver = new ModelExplorer();
        if (options.modelFilename != null) {
            logger.log(Level.INFO, driver.loadModel(driver.shell, new File(options.modelFilename)));
        }
        driver.startShell();
    }

    public static class ModelExplorerOptions
    implements Options {
        @Option(charName=102, longName="filename", usage="Model file to load. Optional.")
        public String modelFilename;
    }
}

