/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.ml;

import com.amazon.randomcutforest.returntypes.RangeVector;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;

public class RCFCasterResult
extends IntermediateResult<ForecastResult> {
    private final RangeVector forecast;
    private final double dataQuality;

    public RCFCasterResult(RangeVector forecast, double dataQuality, long totalUpdates, double rcfScore) {
        super(totalUpdates, rcfScore);
        this.forecast = forecast;
        this.dataQuality = dataQuality;
    }

    public RangeVector getForecast() {
        return this.forecast;
    }

    public double getDataQuality() {
        return this.dataQuality;
    }

    @Override
    public List<ForecastResult> toIndexableResults(Config forecaster, Instant dataStartInstant, Instant dataEndInstant, Instant executionStartInstant, Instant executionEndInstant, List<FeatureData> featureData, Optional<Entity> entity, Integer schemaVersion, String modelId, String taskId, String error) {
        if (this.forecast.values == null || this.forecast.values.length == 0) {
            return Collections.emptyList();
        }
        return ForecastResult.fromRawRCFCasterResult(forecaster.getId(), forecaster.getIntervalInMilliseconds(), this.dataQuality, featureData, dataStartInstant, dataEndInstant, executionStartInstant, executionEndInstant, error, entity, forecaster.getUser(), schemaVersion, modelId, this.forecast.values, this.forecast.upper, this.forecast.lower, taskId);
    }
}

