/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport.monitor;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteMonitorTrigger;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.IndexThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.SearchThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.action.monitor.response.IndexThreatIntelMonitorResponse;
import org.opensearch.securityanalytics.threatIntel.model.monitor.PerIocTypeScanInput;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelInput;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelTriggerDto;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportSearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelMonitorUtils;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndexThreatIntelMonitorAction
extends HandledTransportAction<IndexThreatIntelMonitorRequest, IndexThreatIntelMonitorResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportIndexThreatIntelMonitorAction.class);
    private final TransportSearchThreatIntelMonitorAction transportSearchThreatIntelMonitorAction;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private volatile Boolean filterByEnabled;
    private final TimeValue indexTimeout;

    @Inject
    public TransportIndexThreatIntelMonitorAction(TransportService transportService, TransportSearchThreatIntelMonitorAction transportSearchThreatIntelMonitorAction, ActionFilters actionFilters, ThreadPool threadPool, Settings settings, Client client, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/monitors/write", transportService, actionFilters, IndexThreatIntelMonitorRequest::new);
        this.transportSearchThreatIntelMonitorAction = transportSearchThreatIntelMonitorAction;
        this.threadPool = threadPool;
        this.settings = settings;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.xContentRegistry = namedXContentRegistry;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.client = client;
    }

    protected void doExecute(Task task, IndexThreatIntelMonitorRequest request, ActionListener<IndexThreatIntelMonitorResponse> listener) {
        try {
            User user = this.readUserFromThreadContext(this.threadPool);
            String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
            if (!"".equals(validateBackendRoleMessage)) {
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0]))));
                return;
            }
            this.threadPool.getThreadContext().stashContext();
            if (request.getMethod().equals((Object)RestRequest.Method.PUT)) {
                this.indexMonitor(request, listener, user);
                return;
            }
            SearchRequest threatIntelMonitorsSearchRequest = new SearchRequest();
            threatIntelMonitorsSearchRequest.indices(new String[]{".opendistro-alerting-config"});
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchQuery((String)"monitor.owner", (Object)"security_analytics")));
            boolQueryBuilder.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchQuery((String)"monitor.monitor_type", (Object)"ti_doc_level_monitor")));
            threatIntelMonitorsSearchRequest.source(new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder));
            this.transportSearchThreatIntelMonitorAction.execute(new SearchThreatIntelMonitorRequest(threatIntelMonitorsSearchRequest), ActionListener.wrap(searchResponse -> {
                ArrayList monitorIds;
                List<Object> list = monitorIds = searchResponse.getHits() == null || searchResponse.getHits().getHits() == null ? new ArrayList() : Arrays.stream(searchResponse.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
                if (monitorIds.isEmpty()) {
                    this.indexMonitor(request, listener, user);
                } else {
                    listener.onFailure((Exception)new ResourceAlreadyExistsException(String.format("Threat intel monitor %s already exists.", monitorIds.get(0)), new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException || e.getMessage().contains("Configured indices are not found")) {
                    try {
                        this.indexMonitor(request, listener, user);
                        return;
                    }
                    catch (IOException ex) {
                        log.error(() -> new ParameterizedMessage("Unexpected failure while indexing threat intel monitor {} named {}", (Object)request.getId(), (Object)request.getMonitor().getName()));
                        listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Unexpected failure while indexing threat intel monitor", RestStatus.INTERNAL_SERVER_ERROR, (Exception)e)));
                        return;
                    }
                }
                log.error("Failed to update threat intel monitor alerts status", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (OpenSearchException e2) {
            log.error(() -> new ParameterizedMessage("Unexpected failure while indexing threat intel monitor {} named {}", (Object)request.getId(), (Object)request.getMonitor().getName()));
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Unexpected failure while indexing threat intel monitor", e2.status(), (Exception)((Object)e2))));
        }
        catch (Exception e3) {
            log.error(() -> new ParameterizedMessage("Unexpected failure while indexing threat intel monitor {} named {}", (Object)request.getId(), (Object)request.getMonitor().getName()));
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException("Unexpected failure while indexing threat intel monitor", RestStatus.INTERNAL_SERVER_ERROR, e3)));
        }
    }

    private void indexMonitor(IndexThreatIntelMonitorRequest request, ActionListener<IndexThreatIntelMonitorResponse> listener, User user) throws IOException {
        IndexMonitorRequest indexMonitorRequest = this.buildIndexMonitorRequest(request);
        AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, indexMonitorRequest, this.namedWriteableRegistry, ActionListener.wrap(r -> {
            log.debug("{} threat intel monitor {}", (Object)(request.getMethod() == RestRequest.Method.PUT ? "Updated" : "Created"), (Object)r.getId());
            IndexThreatIntelMonitorResponse response = this.getIndexThreatIntelMonitorResponse((IndexMonitorResponse)r, user);
            listener.onResponse((Object)response);
        }, e -> {
            String errorText = "Failed to create threat intel monitor";
            SecurityAnalyticsException exception = new SecurityAnalyticsException(errorText, RestStatus.INTERNAL_SERVER_ERROR, (Exception)e);
            log.error(errorText, (Throwable)e);
            if (e instanceof OpenSearchException) {
                exception = new SecurityAnalyticsException(errorText, ((OpenSearchException)((Object)((Object)e))).status(), (Exception)e);
            }
            listener.onFailure((Exception)((Object)exception));
        }));
    }

    private IndexThreatIntelMonitorResponse getIndexThreatIntelMonitorResponse(IndexMonitorResponse r, User user) throws IOException {
        IndexThreatIntelMonitorResponse response = new IndexThreatIntelMonitorResponse(r.getId(), r.getVersion(), r.getSeqNo(), r.getPrimaryTerm(), ThreatIntelMonitorUtils.buildThreatIntelMonitorDto(r.getId(), r.getMonitor(), this.xContentRegistry));
        return response;
    }

    private IndexMonitorRequest buildIndexMonitorRequest(IndexThreatIntelMonitorRequest request) throws IOException {
        String id = request.getMethod() == RestRequest.Method.POST ? "" : request.getId();
        return new IndexMonitorRequest(id, -2L, 0L, WriteRequest.RefreshPolicy.IMMEDIATE, request.getMethod(), this.buildThreatIntelMonitor(request), null);
    }

    private Monitor buildThreatIntelMonitor(IndexThreatIntelMonitorRequest request) throws IOException {
        Monitor monitor;
        DocLevelMonitorInput docLevelMonitorInput = new DocLevelMonitorInput(String.format("threat intel input for monitor named %s", request.getMonitor().getName()), request.getMonitor().getIndices(), Collections.emptyList(), Boolean.valueOf(true));
        List<PerIocTypeScanInput> perIocTypeScanInputs = request.getMonitor().getPerIocTypeScanInputList().stream().map(it -> new PerIocTypeScanInput(it.getIocType(), it.getIndexToFieldsMap())).collect(Collectors.toList());
        ThreatIntelInput threatIntelInput = new ThreatIntelInput(perIocTypeScanInputs);
        RemoteDocLevelMonitorInput remoteDocLevelMonitorInput = new RemoteDocLevelMonitorInput(threatIntelInput.getThreatIntelInputAsBytesReference(), docLevelMonitorInput);
        ArrayList<RemoteMonitorTrigger> triggers = new ArrayList<RemoteMonitorTrigger>();
        for (ThreatIntelTriggerDto it2 : request.getMonitor().getTriggers()) {
            try {
                RemoteMonitorTrigger trigger = ThreatIntelMonitorUtils.buildRemoteMonitorTrigger(it2);
                triggers.add(trigger);
            }
            catch (IOException e) {
                this.logger.error(() -> new ParameterizedMessage("failed to parse threat intel trigger {}", (Object)it2.getId()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            monitor = new Monitor(request.getMethod() == RestRequest.Method.POST ? "" : request.getId(), 1L, StringUtils.isBlank((CharSequence)request.getMonitor().getName()) ? "threat_intel_monitor" : request.getMonitor().getName(), request.getMonitor().isEnabled(), request.getMonitor().getSchedule(), Instant.now(), request.getMonitor().isEnabled() ? Instant.now() : null, "ti_doc_level_monitor", request.getMonitor().getUser(), 1, List.of(remoteDocLevelMonitorInput), triggers, Collections.emptyMap(), new DataSources(), Boolean.valueOf(false), null, "security_analytics");
        }
        catch (Exception e) {
            String error = "Error occurred while parsing monitor.";
            log.error(error, (Throwable)e);
            throw new SecurityAnalyticsException(error, RestStatus.BAD_REQUEST, e);
        }
        return monitor;
    }
}

