/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.iocscan.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.model.threatintel.IocWithFeeds;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.threatIntel.iocscan.dto.IocScanContext;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.IoCScanServiceInterface;
import org.opensearch.securityanalytics.threatIntel.model.monitor.PerIocTypeScanInput;

public abstract class IoCScanService<Data>
implements IoCScanServiceInterface<Data> {
    private static final Logger log = LogManager.getLogger(IoCScanService.class);

    @Override
    public void scanIoCs(IocScanContext<Data> iocScanContext, BiConsumer<Object, Exception> scanCallback) {
        try {
            List data = iocScanContext.getData();
            if (data.isEmpty()) {
                scanCallback.accept(Collections.emptyList(), null);
                return;
            }
            Monitor monitor = iocScanContext.getMonitor();
            long startTime = System.currentTimeMillis();
            IocLookupDtos iocLookupDtos = this.extractIocsPerType(data, iocScanContext);
            if (iocLookupDtos.getIocsPerIocTypeMap().isEmpty()) {
                log.error("Threat intel monitor {}: Unexpected scenario that non-zero number of docs are fetched from indices containing iocs but iocs-per-type map constructed is empty", (Object)iocScanContext.getMonitor().getId());
                scanCallback.accept(Collections.emptyList(), null);
                return;
            }
            BiConsumer<List<STIX2IOC>, Exception> iocScanResultConsumer = (maliciousIocs, e) -> {
                long scanEndTime = System.currentTimeMillis();
                long timeTaken = scanEndTime - startTime;
                log.debug("Threat intel monitor {}: scan time taken is {}", (Object)monitor.getId(), (Object)timeTaken);
                if (e == null) {
                    this.createIocFindings((List<STIX2IOC>)maliciousIocs, iocLookupDtos.iocValueToDocIdMap, iocScanContext, (iocFindings, e1) -> {
                        if (e1 != null) {
                            log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to create ioc findings", (Object)iocScanContext.getMonitor().getId(), (Object)data.size()), (Throwable)e1);
                            scanCallback.accept(data, (Exception)e1);
                        } else {
                            BiConsumer<List<ThreatIntelAlert>, Exception> triggerResultConsumer = (alerts, e2) -> {
                                if (e2 != null) {
                                    log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to execute threat intel triggers/ ", (Object)iocScanContext.getMonitor().getId(), (Object)data.size()), (Throwable)e2);
                                    scanCallback.accept(data, null);
                                } else {
                                    scanCallback.accept(data, null);
                                }
                            };
                            this.executeTriggers((List<STIX2IOC>)maliciousIocs, (List<IocFinding>)iocFindings, iocScanContext, data, iocLookupDtos, triggerResultConsumer);
                        }
                    });
                } else {
                    log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Failed to run scan for {} docs", (Object)iocScanContext.getMonitor().getId(), (Object)data.size()), (Throwable)e);
                    scanCallback.accept(null, (Exception)e);
                }
            };
            this.matchAgainstThreatIntelAndReturnMaliciousIocs(iocLookupDtos.getIocsPerIocTypeMap(), monitor, iocScanResultConsumer, iocScanContext.getIocTypeToIndices());
        }
        catch (Exception e2) {
            log.error(() -> new ParameterizedMessage("Threat intel monitor {}: Unexpected failure in running scan for {} docs", (Object)iocScanContext.getMonitor().getId(), (Object)iocScanContext.getData().size()), (Throwable)e2);
            scanCallback.accept(null, e2);
        }
    }

    abstract void executeTriggers(List<STIX2IOC> var1, List<IocFinding> var2, IocScanContext<Data> var3, List<Data> var4, IocLookupDtos var5, BiConsumer<List<ThreatIntelAlert>, Exception> var6);

    abstract void matchAgainstThreatIntelAndReturnMaliciousIocs(Map<String, Set<String>> var1, Monitor var2, BiConsumer<List<STIX2IOC>, Exception> var3, Map<String, List<String>> var4);

    private IocLookupDtos extractIocsPerType(List<Data> data, IocScanContext<Data> context) {
        HashMap<String, Set<String>> iocsPerIocTypeMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> iocValueToDocIdMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> docIdToIocsMap = new HashMap<String, Set<String>>();
        for (Data datum : data) {
            for (PerIocTypeScanInput iocTypeToIndexFieldMapping : context.getThreatIntelInput().getPerIocTypeScanInputList()) {
                String iocType = iocTypeToIndexFieldMapping.getIocType().toLowerCase();
                String concreteIndex = this.getIndexName(datum);
                if (!context.getConcreteIndexToMonitorInputIndicesMap().containsKey(concreteIndex)) continue;
                String index = context.getConcreteIndexToMonitorInputIndicesMap().get(concreteIndex).get(0);
                List<String> fieldsConfiguredInMonitorForCurrentIndex = iocTypeToIndexFieldMapping.getIndexToFieldsMap().get(index);
                if (fieldsConfiguredInMonitorForCurrentIndex == null || fieldsConfiguredInMonitorForCurrentIndex.isEmpty()) continue;
                for (String field : fieldsConfiguredInMonitorForCurrentIndex) {
                    List<String> vals = this.getValuesAsStringList(datum, field);
                    String id = this.getId(datum);
                    String docId = id + ":" + index;
                    Set iocs = docIdToIocsMap.getOrDefault(docId, new HashSet());
                    iocs.addAll(vals);
                    docIdToIocsMap.put(docId, iocs);
                    for (String ioc : vals) {
                        Set docIds = iocValueToDocIdMap.getOrDefault(ioc, new HashSet());
                        docIds.add(docId);
                        iocValueToDocIdMap.put(ioc, docIds);
                    }
                    if (vals.isEmpty()) continue;
                    iocs = iocsPerIocTypeMap.getOrDefault(iocType, new HashSet());
                    iocs.addAll(vals);
                    iocsPerIocTypeMap.put(iocType, iocs);
                }
            }
        }
        return new IocLookupDtos(iocsPerIocTypeMap, iocValueToDocIdMap, docIdToIocsMap);
    }

    abstract List<String> getValuesAsStringList(Data var1, String var2);

    abstract String getIndexName(Data var1);

    abstract String getId(Data var1);

    private void createIocFindings(List<STIX2IOC> iocs, Map<String, Set<String>> iocValueToDocIdMap, IocScanContext iocScanContext, BiConsumer<List<IocFinding>, Exception> callback) {
        try {
            Instant timestamp = Instant.now();
            Monitor monitor = iocScanContext.getMonitor();
            HashMap<String, Set> iocValueToFeedIds = new HashMap<String, Set>();
            HashMap<String, String> iocValueToType = new HashMap<String, String>();
            for (STIX2IOC ioc : iocs) {
                String iocValue = ioc.getValue();
                if (!iocValueToType.containsKey(iocValue)) {
                    iocValueToType.put(iocValue, ioc.getType().toString());
                }
                iocValueToFeedIds.computeIfAbsent(iocValue, k -> new HashSet()).add(new IocWithFeeds(ioc.getId(), ioc.getFeedId(), ioc.getFeedName(), ""));
            }
            ArrayList<IocFinding> iocFindings = new ArrayList<IocFinding>();
            for (Map.Entry entry : iocValueToFeedIds.entrySet()) {
                String iocValue = (String)entry.getKey();
                Set iocWithFeeds = (Set)entry.getValue();
                ArrayList<String> relatedDocIds = new ArrayList<String>(iocValueToDocIdMap.getOrDefault(iocValue, new HashSet()));
                ArrayList<IocWithFeeds> feedIdsList = new ArrayList<IocWithFeeds>(iocWithFeeds);
                try {
                    IocFinding iocFinding = new IocFinding(UUID.randomUUID().toString(), relatedDocIds, feedIdsList, monitor.getId(), monitor.getName(), iocValue, (String)iocValueToType.get(iocValue), timestamp, UUID.randomUUID().toString());
                    iocFindings.add(iocFinding);
                }
                catch (Exception e) {
                    log.error(String.format("skipping creating ioc finding for %s due to unexpected failure.", entry.getKey()), (Throwable)e);
                }
            }
            this.saveIocFindings(iocFindings, callback, monitor);
        }
        catch (Exception e) {
            log.error(() -> new ParameterizedMessage("Failed to create ioc findinges due to unexpected error {}", (Object)iocScanContext.getMonitor().getId()), (Throwable)e);
            callback.accept(null, e);
        }
    }

    abstract void saveIocFindings(List<IocFinding> var1, BiConsumer<List<IocFinding>, Exception> var2, Monitor var3);

    abstract void saveAlerts(List<ThreatIntelAlert> var1, List<ThreatIntelAlert> var2, Monitor var3, BiConsumer<List<ThreatIntelAlert>, Exception> var4);

    protected static class IocLookupDtos {
        private final Map<String, Set<String>> iocsPerIocTypeMap;
        private final Map<String, Set<String>> iocValueToDocIdMap;
        private final Map<String, Set<String>> docIdToIocsMap;

        public IocLookupDtos(Map<String, Set<String>> iocsPerIocTypeMap, Map<String, Set<String>> iocValueToDocIdMap, Map<String, Set<String>> docIdToIocsMap) {
            this.iocsPerIocTypeMap = iocsPerIocTypeMap;
            this.iocValueToDocIdMap = iocValueToDocIdMap;
            this.docIdToIocsMap = docIdToIocsMap;
        }

        public Map<String, Set<String>> getIocsPerIocTypeMap() {
            return this.iocsPerIocTypeMap;
        }

        public Map<String, Set<String>> getIocValueToDocIdMap() {
            return this.iocValueToDocIdMap;
        }

        public Map<String, Set<String>> getDocIdToIocsMap() {
            return this.docIdToIocsMap;
        }
    }
}

