/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ThreatIntelFeedData
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(ThreatIntelFeedData.class);
    private static final String FEED_TYPE = "feed";
    private static final String TYPE_FIELD = "type";
    private static final String IOC_TYPE_FIELD = "ioc_type";
    private static final String IOC_VALUE_FIELD = "ioc_value";
    private static final String FEED_ID_FIELD = "feed_id";
    private static final String TIMESTAMP_FIELD = "timestamp";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(ThreatIntelFeedData.class, new ParseField("feed", new String[0]), xcp -> ThreatIntelFeedData.parse(xcp, null, null));
    private final String iocType;
    private final String iocValue;
    private final String feedId;
    private final Instant timestamp;
    private final String type;

    public ThreatIntelFeedData(String iocType, String iocValue, String feedId, Instant timestamp) {
        this.type = FEED_TYPE;
        this.iocType = iocType;
        this.iocValue = iocValue;
        this.feedId = feedId;
        this.timestamp = timestamp;
    }

    public static ThreatIntelFeedData parse(XContentParser xcp, String id, Long version) throws IOException {
        String iocType = null;
        String iocValue = null;
        String feedId = null;
        Instant timestamp = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "ioc_type": {
                    iocType = xcp.text();
                    continue block12;
                }
                case "ioc_value": {
                    iocValue = xcp.text();
                    continue block12;
                }
                case "feed_id": {
                    feedId = xcp.text();
                    continue block12;
                }
                case "timestamp": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        timestamp = null;
                        continue block12;
                    }
                    if (xcp.currentToken().isValue()) {
                        timestamp = Instant.ofEpochMilli(xcp.longValue());
                        continue block12;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    timestamp = null;
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelFeedData(iocType, iocValue, feedId, timestamp);
    }

    public String getIocType() {
        return this.iocType;
    }

    public String getIocValue() {
        return this.iocValue;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.iocType);
        out.writeString(this.iocValue);
        out.writeString(this.feedId);
        out.writeInstant(this.timestamp);
    }

    public ThreatIntelFeedData(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString(), sin.readInstant());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, params);
    }

    private XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(this.type);
        }
        builder.field(TYPE_FIELD, this.type).field(IOC_TYPE_FIELD, this.iocType).field(IOC_VALUE_FIELD, this.iocValue).field(FEED_ID_FIELD, this.feedId).timeField(TIMESTAMP_FIELD, String.format(Locale.getDefault(), "%s_in_millis", TIMESTAMP_FIELD), this.timestamp.toEpochMilli());
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreatIntelFeedData tif = (ThreatIntelFeedData)o;
        return Objects.equals(this.iocType, tif.iocType) && Objects.equals(this.iocValue, tif.iocValue) && Objects.equals(this.feedId, tif.feedId);
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }
}

