/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.join;

import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.join.ElasticJoinExecutor;
import org.opensearch.sql.legacy.executor.join.HashJoinComparisonStructure;
import org.opensearch.sql.legacy.executor.join.SearchHitsResult;
import org.opensearch.sql.legacy.query.join.HashJoinElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;

public class HashJoinElasticExecutor
extends ElasticJoinExecutor {
    private HashJoinElasticRequestBuilder requestBuilder;
    private boolean useQueryTermsFilterOptimization = false;
    private final int MAX_RESULTS_FOR_FIRST_TABLE = 100000;
    HashJoinComparisonStructure hashJoinComparisonStructure;
    private Set<String> alreadyMatched;

    public HashJoinElasticExecutor(Client client, HashJoinElasticRequestBuilder requestBuilder) {
        super(client, requestBuilder);
        this.requestBuilder = requestBuilder;
        this.useQueryTermsFilterOptimization = requestBuilder.isUseTermFiltersOptimization();
        this.hashJoinComparisonStructure = new HashJoinComparisonStructure(requestBuilder.getT1ToT2FieldsComparison());
        this.alreadyMatched = new HashSet<String>();
    }

    @Override
    public List<SearchHit> innerRun() throws IOException, SqlParseException {
        Map<String, Map<String, List<Object>>> optimizationTermsFilterStructure = this.initOptimizationStructure();
        this.updateFirstTableLimitIfNeeded();
        TableInJoinRequestBuilder firstTableRequest = this.requestBuilder.getFirstTable();
        this.createKeyToResultsAndFillOptimizationStructure(optimizationTermsFilterStructure, firstTableRequest);
        TableInJoinRequestBuilder secondTableRequest = this.requestBuilder.getSecondTable();
        if (this.needToOptimize(optimizationTermsFilterStructure)) {
            this.updateRequestWithTermsFilter(optimizationTermsFilterStructure, secondTableRequest);
        }
        List<SearchHit> combinedResult = this.createCombinedResults(secondTableRequest);
        int currentNumOfResults = combinedResult.size();
        int totalLimit = this.requestBuilder.getTotalLimit();
        if (this.requestBuilder.getJoinType() == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN && currentNumOfResults < totalLimit) {
            String t1Alias = this.requestBuilder.getFirstTable().getAlias();
            String t2Alias = this.requestBuilder.getSecondTable().getAlias();
            this.addUnmatchedResults(combinedResult, this.hashJoinComparisonStructure.getAllSearchHits(), this.requestBuilder.getSecondTable().getReturnedFields(), currentNumOfResults, totalLimit, t1Alias, t2Alias);
        }
        if (firstTableRequest.getOriginalSelect().isOrderdSelect()) {
            Collections.sort(combinedResult, new Comparator<SearchHit>(){

                @Override
                public int compare(SearchHit o1, SearchHit o2) {
                    return o1.docId() - o2.docId();
                }
            });
        }
        return combinedResult;
    }

    private Map<String, Map<String, List<Object>>> initOptimizationStructure() {
        HashMap<String, Map<String, List<Object>>> optimizationTermsFilterStructure = new HashMap<String, Map<String, List<Object>>>();
        for (String comparisonId : this.hashJoinComparisonStructure.getComparisons().keySet()) {
            optimizationTermsFilterStructure.put(comparisonId, new HashMap());
        }
        return optimizationTermsFilterStructure;
    }

    private void updateFirstTableLimitIfNeeded() {
        if (this.requestBuilder.getJoinType() == SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN) {
            Integer firstTableHintLimit = this.requestBuilder.getFirstTable().getHintLimit();
            int totalLimit = this.requestBuilder.getTotalLimit();
            if (firstTableHintLimit == null || firstTableHintLimit > totalLimit) {
                this.requestBuilder.getFirstTable().setHintLimit(totalLimit);
            }
        }
    }

    private List<SearchHit> createCombinedResults(TableInJoinRequestBuilder secondTableRequest) {
        boolean finishedScrolling;
        SearchResponse searchResponse;
        ArrayList<SearchHit> combinedResult = new ArrayList<SearchHit>();
        int resultIds = 0;
        int totalLimit = this.requestBuilder.getTotalLimit();
        Integer hintLimit = secondTableRequest.getHintLimit();
        if (hintLimit != null && hintLimit < 10000) {
            searchResponse = this.getResponseWithHits(secondTableRequest, hintLimit, null);
            finishedScrolling = true;
        } else {
            searchResponse = this.getResponseWithHits(secondTableRequest, 10000, null);
            finishedScrolling = false;
        }
        this.updateMetaSearchResults(searchResponse);
        boolean limitReached = false;
        int fetchedSoFarFromSecondTable = 0;
        while (!limitReached) {
            SearchHit[] secondTableHits = searchResponse.getHits().getHits();
            fetchedSoFarFromSecondTable += secondTableHits.length;
            for (SearchHit secondTableHit : secondTableHits) {
                if (limitReached) break;
                HashMap<String, List<Map.Entry<Field, Field>>> comparisons = this.hashJoinComparisonStructure.getComparisons();
                block2: for (Map.Entry<String, List<Map.Entry<Field, Field>>> comparison : comparisons.entrySet()) {
                    List<Map.Entry<Field, Field>> t1ToT2FieldsComparison;
                    String key;
                    String comparisonID = comparison.getKey();
                    SearchHitsResult searchHitsResult = this.hashJoinComparisonStructure.searchForMatchingSearchHits(comparisonID, key = this.getComparisonKey(t1ToT2FieldsComparison = comparison.getValue(), secondTableHit, false, null));
                    if (searchHitsResult == null || searchHitsResult.getSearchHits().size() <= 0) continue;
                    searchHitsResult.setMatchedWithOtherTable(true);
                    List<SearchHit> searchHits = searchHitsResult.getSearchHits();
                    for (SearchHit matchingHit : searchHits) {
                        String combinedId = matchingHit.getId() + "|" + secondTableHit.getId();
                        if (this.alreadyMatched.contains(combinedId)) continue;
                        this.alreadyMatched.add(combinedId);
                        HashMap<String, Object> copiedSource = new HashMap<String, Object>();
                        this.copyMaps(copiedSource, secondTableHit.getSourceAsMap());
                        this.onlyReturnedFields(copiedSource, secondTableRequest.getReturnedFields(), secondTableRequest.getOriginalSelect().isSelectAll());
                        HashMap documentFields = new HashMap();
                        HashMap metaFields = new HashMap();
                        matchingHit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
                        SearchHit searchHit = new SearchHit(matchingHit.docId(), combinedId, documentFields, metaFields);
                        searchHit.sourceRef(matchingHit.getSourceRef());
                        searchHit.getSourceAsMap().clear();
                        searchHit.getSourceAsMap().putAll(matchingHit.getSourceAsMap());
                        String t1Alias = this.requestBuilder.getFirstTable().getAlias();
                        String t2Alias = this.requestBuilder.getSecondTable().getAlias();
                        this.mergeSourceAndAddAliases(copiedSource, searchHit, t1Alias, t2Alias);
                        combinedResult.add(searchHit);
                        if (++resultIds < totalLimit) continue;
                        limitReached = true;
                        continue block2;
                    }
                }
            }
            if (finishedScrolling || secondTableHits.length <= 0 || hintLimit != null && fetchedSoFarFromSecondTable < hintLimit) break;
            searchResponse = this.getResponseWithHits(secondTableRequest, 10000, searchResponse);
        }
        return combinedResult;
    }

    private void copyMaps(Map<String, Object> into, Map<String, Object> from) {
        for (Map.Entry<String, Object> keyAndValue : from.entrySet()) {
            into.put(keyAndValue.getKey(), keyAndValue.getValue());
        }
    }

    private void createKeyToResultsAndFillOptimizationStructure(Map<String, Map<String, List<Object>>> optimizationTermsFilterStructure, TableInJoinRequestBuilder firstTableRequest) {
        List<SearchHit> firstTableHits = this.fetchAllHits(firstTableRequest);
        int resultIds = 1;
        for (SearchHit hit : firstTableHits) {
            HashMap<String, List<Map.Entry<Field, Field>>> comparisons = this.hashJoinComparisonStructure.getComparisons();
            for (Map.Entry<String, List<Map.Entry<Field, Field>>> comparison : comparisons.entrySet()) {
                String comparisonID = comparison.getKey();
                List<Map.Entry<Field, Field>> t1ToT2FieldsComparison = comparison.getValue();
                String key = this.getComparisonKey(t1ToT2FieldsComparison, hit, true, optimizationTermsFilterStructure.get(comparisonID));
                HashMap documentFields = new HashMap();
                HashMap metaFields = new HashMap();
                hit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
                SearchHit searchHit = new SearchHit(resultIds, hit.getId(), documentFields, metaFields);
                searchHit.sourceRef(hit.getSourceRef());
                this.onlyReturnedFields(searchHit.getSourceAsMap(), firstTableRequest.getReturnedFields(), firstTableRequest.getOriginalSelect().isSelectAll());
                ++resultIds;
                this.hashJoinComparisonStructure.insertIntoComparisonHash(comparisonID, key, searchHit);
            }
        }
    }

    private List<SearchHit> fetchAllHits(TableInJoinRequestBuilder tableInJoinRequest) {
        Integer hintLimit = tableInJoinRequest.getHintLimit();
        SearchRequestBuilder requestBuilder = tableInJoinRequest.getRequestBuilder();
        if (hintLimit != null && hintLimit < 10000) {
            requestBuilder.setSize(hintLimit.intValue());
            SearchResponse searchResponse = (SearchResponse)requestBuilder.get();
            this.updateMetaSearchResults(searchResponse);
            return Arrays.asList(searchResponse.getHits().getHits());
        }
        return this.scrollTillLimit(tableInJoinRequest, hintLimit);
    }

    private List<SearchHit> scrollTillLimit(TableInJoinRequestBuilder tableInJoinRequest, Integer hintLimit) {
        SearchResponse response = this.getResponseWithHits(tableInJoinRequest, 10000, null);
        this.updateMetaSearchResults(response);
        ArrayList<SearchHit> hitsWithScan = new ArrayList<SearchHit>();
        int curentNumOfResults = 0;
        SearchHit[] hits = response.getHits().getHits();
        if (hintLimit == null) {
            hintLimit = 100000;
        }
        while (hits.length != 0 && curentNumOfResults < hintLimit) {
            Collections.addAll(hitsWithScan, hits);
            if ((curentNumOfResults += hits.length) >= 100000) {
                System.out.println("too many results for first table, stoping at:" + curentNumOfResults);
                break;
            }
            response = this.getResponseWithHits(tableInJoinRequest, 100000, response);
            hits = response.getHits().getHits();
        }
        return hitsWithScan;
    }

    private boolean needToOptimize(Map<String, Map<String, List<Object>>> optimizationTermsFilterStructure) {
        if (!this.useQueryTermsFilterOptimization && optimizationTermsFilterStructure != null && optimizationTermsFilterStructure.size() > 0) {
            return false;
        }
        boolean allEmpty = true;
        for (Map<String, List<Object>> optimization : optimizationTermsFilterStructure.values()) {
            if (optimization.size() <= 0) continue;
            allEmpty = false;
            break;
        }
        return !allEmpty;
    }

    private void updateRequestWithTermsFilter(Map<String, Map<String, List<Object>>> optimizationTermsFilterStructure, TableInJoinRequestBuilder secondTableRequest) throws SqlParseException {
        BoolQueryBuilder boolQuery;
        Select select = secondTableRequest.getOriginalSelect();
        BoolQueryBuilder orQuery = QueryBuilders.boolQuery();
        for (Map<String, List<Object>> optimization : optimizationTermsFilterStructure.values()) {
            BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
            for (Map.Entry<String, List<Object>> keyToValues : optimization.entrySet()) {
                String fieldName = keyToValues.getKey();
                List<Object> values = keyToValues.getValue();
                andQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, values));
            }
            orQuery.should((QueryBuilder)andQuery);
        }
        Where where = select.getWhere();
        if (where != null) {
            boolQuery = QueryMaker.explain(where, false);
            boolQuery.must((QueryBuilder)orQuery);
        } else {
            boolQuery = orQuery;
        }
        secondTableRequest.getRequestBuilder().setQuery((QueryBuilder)boolQuery);
    }

    private String getComparisonKey(List<Map.Entry<Field, Field>> t1ToT2FieldsComparison, SearchHit hit, boolean firstTable, Map<String, List<Object>> optimizationTermsFilterStructure) {
        Object key = "";
        Map sourceAsMap = hit.getSourceAsMap();
        for (Map.Entry<Field, Field> t1ToT2 : t1ToT2FieldsComparison) {
            String name = firstTable ? t1ToT2.getKey().getName() : t1ToT2.getValue().getName();
            Object data = this.deepSearchInMap(sourceAsMap, name);
            if (firstTable && this.useQueryTermsFilterOptimization) {
                this.updateOptimizationData(optimizationTermsFilterStructure, data, t1ToT2.getValue().getName());
            }
            if (data == null) {
                key = (String)key + "|null|";
                continue;
            }
            key = (String)key + "|" + data.toString() + "|";
        }
        return key;
    }

    private void updateOptimizationData(Map<String, List<Object>> optimizationTermsFilterStructure, Object data, String queryOptimizationKey) {
        List<Object> values = optimizationTermsFilterStructure.get(queryOptimizationKey);
        if (values == null) {
            values = new ArrayList<Object>();
            optimizationTermsFilterStructure.put(queryOptimizationKey, values);
        }
        if (data instanceof String) {
            data = ((String)data).toLowerCase();
        }
        if (data != null) {
            values.add(data);
        }
    }
}

