/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.FeatureNormDefinition;
import com.o19s.es.ltr.feature.store.MinMaxFeatureNormDefinition;
import com.o19s.es.ltr.feature.store.StandardFeatureNormDefinition;
import com.o19s.es.ltr.ranker.normalizer.Normalizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.OpenSearchException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class StoredFeatureNormalizers {
    public static final ObjectParser.NamedObjectParser<FeatureNormDefinition, Void> PARSER;
    private static final ParseField STANDARD;
    private static final ParseField MIN_MAX;
    private final Map<String, FeatureNormDefinition> featureNormalizers = new HashMap<String, FeatureNormDefinition>();

    public StoredFeatureNormalizers() {
    }

    public StoredFeatureNormalizers(List<FeatureNormDefinition> ftrNormDefs) {
        for (FeatureNormDefinition ftrNorm : ftrNormDefs) {
            this.featureNormalizers.put(ftrNorm.featureName(), ftrNorm);
        }
    }

    public StoredFeatureNormalizers(StreamInput input) throws IOException {
        int numFeatureNorms;
        for (int i = numFeatureNorms = input.readInt(); i > 0; --i) {
            FeatureNormDefinition norm = this.createFromStreamInput(input);
            this.featureNormalizers.put(norm.featureName(), norm);
        }
    }

    public Normalizer getNormalizer(String featureName) {
        return this.featureNormalizers.get(featureName).createFeatureNorm();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, FeatureNormDefinition> ftrNormDefEntry : this.featureNormalizers.entrySet()) {
            builder.field(ftrNormDefEntry.getKey());
            ftrNormDefEntry.getValue().toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public Map<Integer, Normalizer> compileOrdToNorms(FeatureSet featureSet) {
        HashMap<Integer, Normalizer> ftrNorms = new HashMap<Integer, Normalizer>();
        for (Map.Entry<String, FeatureNormDefinition> ftrNormDefEntry : this.featureNormalizers.entrySet()) {
            String featureName = ftrNormDefEntry.getValue().featureName();
            Normalizer ftrNorm = ftrNormDefEntry.getValue().createFeatureNorm();
            if (!featureSet.hasFeature(featureName)) {
                throw new OpenSearchException("Feature " + featureName + " not found in feature set " + featureSet.name(), new Object[0]);
            }
            int ord = featureSet.featureOrdinal(featureName);
            ftrNorms.put(ord, ftrNorm);
        }
        return ftrNorms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredFeatureNormalizers)) {
            return false;
        }
        StoredFeatureNormalizers that = (StoredFeatureNormalizers)o;
        return that.featureNormalizers.equals(this.featureNormalizers);
    }

    public int hashCode() {
        return this.featureNormalizers.hashCode();
    }

    public int numNormalizers() {
        return this.featureNormalizers.size();
    }

    private FeatureNormDefinition createFromStreamInput(StreamInput input) throws IOException {
        Type normType = (Type)input.readEnum(Type.class);
        if (normType == Type.STANDARD) {
            return new StandardFeatureNormDefinition(input);
        }
        if (normType == Type.MIN_MAX) {
            return new MinMaxFeatureNormDefinition(input);
        }
        throw new OpenSearchException("unknown normalizer type during deserialization", new Object[0]);
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeInt(this.featureNormalizers.size());
        for (Map.Entry<String, FeatureNormDefinition> featureNormEntry : this.featureNormalizers.entrySet()) {
            output.writeEnum((Enum)featureNormEntry.getValue().normType());
            featureNormEntry.getValue().writeTo(output);
        }
    }

    static {
        STANDARD = new ParseField("standard", new String[0]);
        MIN_MAX = new ParseField("min_max", new String[0]);
        PARSER = (p, c, featureName) -> {
            ObjectParser parser = new ObjectParser("feature_normalizers", FeatureNormConsumer::new);
            parser.declareObject(FeatureNormConsumer::setFtrNormDefn, StandardFeatureNormDefinition.PARSER, STANDARD);
            parser.declareObject(FeatureNormConsumer::setFtrNormDefn, MinMaxFeatureNormDefinition.PARSER, MIN_MAX);
            FeatureNormConsumer parsedNorm = (FeatureNormConsumer)parser.parse(p, (Object)featureName);
            return parsedNorm.ftrNormDefn;
        };
    }

    public static enum Type {
        STANDARD,
        MIN_MAX;

    }

    private static class FeatureNormConsumer {
        FeatureNormDefinition ftrNormDefn;

        FeatureNormConsumer() {
        }

        public FeatureNormDefinition getFtrNormDefn() {
            return this.ftrNormDefn;
        }

        public void setFtrNormDefn(FeatureNormDefinition ftrNormDefn) {
            if (this.ftrNormDefn != null) {
                throw new IllegalArgumentException("Multiple feature normalizers detected ");
            }
            this.ftrNormDefn = ftrNormDefn;
        }
    }
}

