/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.nlp;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.QuestionAnsweringInputDataSet;
import org.opensearch.ml.common.input.MLInput;

@org.opensearch.ml.common.annotation.MLInput(functionNames={FunctionName.QUESTION_ANSWERING})
public class QuestionAnsweringMLInput
extends MLInput {
    public QuestionAnsweringMLInput(FunctionName algorithm, MLInputDataset dataset) {
        super(algorithm, null, dataset);
    }

    public QuestionAnsweringMLInput(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("algorithm", this.algorithm.name());
        if (this.parameters != null) {
            builder.field("parameters", (ToXContent)this.parameters);
        }
        if (this.inputDataset != null) {
            QuestionAnsweringInputDataSet ds = (QuestionAnsweringInputDataSet)this.inputDataset;
            String question = ds.getQuestion();
            String context = ds.getContext();
            builder.field("question", question);
            builder.field("context", context);
        }
        builder.endObject();
        return builder;
    }

    public QuestionAnsweringMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        String question = null;
        String context = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "question": {
                    question = parser.text();
                    continue block8;
                }
                case "context": {
                    context = parser.text();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        if (question == null) {
            throw new IllegalArgumentException("Question is not provided");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context is not provided");
        }
        this.inputDataset = new QuestionAnsweringInputDataSet(question, context);
    }
}

