/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.listeners;

import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.wlm.QueryGroupService;

public class QueryGroupRequestOperationListener
extends SearchRequestOperationsListener {
    private final QueryGroupService queryGroupService;
    private final ThreadPool threadPool;

    public QueryGroupRequestOperationListener(QueryGroupService queryGroupService, ThreadPool threadPool) {
        this.queryGroupService = queryGroupService;
        this.threadPool = threadPool;
    }

    @Override
    protected void onRequestStart(SearchRequestContext searchRequestContext) {
        String queryGroupId = this.threadPool.getThreadContext().getHeader("queryGroupId");
        this.queryGroupService.rejectIfNeeded(queryGroupId);
    }

    @Override
    protected void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        String queryGroupId = this.threadPool.getThreadContext().getHeader("queryGroupId");
        this.queryGroupService.incrementFailuresFor(queryGroupId);
    }
}

