/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.lookup;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.lookup.DocLookup;
import org.opensearch.search.lookup.FieldsLookup;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SourceLookup;

@PublicApi(since="1.0.0")
public class SearchLookup {
    private static final int MAX_FIELD_CHAIN_DEPTH = 5;
    public static final int UNKNOWN_SHARD_ID = -1;
    private final Set<String> fieldChain;
    private final DocLookup docMap;
    private final SourceLookup sourceLookup;
    private final FieldsLookup fieldsLookup;
    private final BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup;
    private final int shardId;

    @Deprecated
    public SearchLookup(MapperService mapperService, BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup) {
        this(mapperService, fieldDataLookup, -1);
    }

    public SearchLookup(MapperService mapperService, BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup, int shardId) {
        this.fieldChain = Collections.emptySet();
        this.docMap = new DocLookup(mapperService, fieldType -> (IndexFieldData)fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())));
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService);
        this.fieldDataLookup = fieldDataLookup;
        this.shardId = shardId;
    }

    private SearchLookup(SearchLookup searchLookup, Set<String> fieldChain) {
        this.fieldChain = Collections.unmodifiableSet(fieldChain);
        this.docMap = new DocLookup(searchLookup.docMap.mapperService(), fieldType -> searchLookup.fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())));
        this.sourceLookup = searchLookup.sourceLookup;
        this.fieldsLookup = searchLookup.fieldsLookup;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
        this.shardId = searchLookup.shardId;
    }

    public final SearchLookup forkAndTrackFieldReferences(String field) {
        Objects.requireNonNull(field, "field cannot be null");
        LinkedHashSet<String> newFieldChain = new LinkedHashSet<String>(this.fieldChain);
        if (!newFieldChain.add(field)) {
            String message = String.join((CharSequence)" -> ", newFieldChain) + " -> " + field;
            throw new IllegalArgumentException("Cyclic dependency detected while resolving runtime fields: " + message);
        }
        if (newFieldChain.size() > 5) {
            throw new IllegalArgumentException("Field requires resolving too many dependent fields: " + String.join((CharSequence)" -> ", newFieldChain));
        }
        return new SearchLookup(this, newFieldChain);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, this.docMap.getLeafDocLookup(context), new SourceLookup(), this.fieldsLookup.getLeafFieldsLookup(context));
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public int shardId() {
        if (this.shardId == -1) {
            throw new IllegalStateException("Shard id is unknown for this lookup");
        }
        return this.shardId;
    }
}

