/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.composite.composite912;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesProducerUtil;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.codec.composite.CompositeIndexReader;
import org.opensearch.index.codec.composite.LuceneDocValuesConsumerFactory;
import org.opensearch.index.compositeindex.datacube.startree.builder.StarTreesBuilder;
import org.opensearch.index.compositeindex.datacube.startree.index.CompositeIndexValues;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.CompositeMappedFieldType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class Composite912DocValuesWriter
extends DocValuesConsumer {
    private final DocValuesConsumer delegate;
    private final SegmentWriteState state;
    private final MapperService mapperService;
    AtomicReference<MergeState> mergeState = new AtomicReference();
    private final Set<CompositeMappedFieldType> compositeMappedFieldTypes;
    private final Set<String> compositeFieldSet;
    private DocValuesConsumer compositeDocValuesConsumer;
    public IndexOutput dataOut;
    public IndexOutput metaOut;
    private final Set<String> segmentFieldSet;
    private final boolean segmentHasCompositeFields;
    private final AtomicInteger fieldNumberAcrossCompositeFields;
    private final Map<String, DocValuesProducer> fieldProducerMap = new HashMap<String, DocValuesProducer>();
    private final Map<String, SortedSetDocValues> fieldDocIdSetIteratorMap = new HashMap<String, SortedSetDocValues>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Composite912DocValuesWriter(DocValuesConsumer delegate, SegmentWriteState segmentWriteState, MapperService mapperService) throws IOException {
        this.delegate = delegate;
        this.state = segmentWriteState;
        this.mapperService = mapperService;
        this.fieldNumberAcrossCompositeFields = new AtomicInteger();
        this.compositeMappedFieldTypes = mapperService.getCompositeFieldTypes();
        this.compositeFieldSet = new HashSet<String>();
        this.segmentFieldSet = new HashSet<String>();
        this.addStarTreeSupportedFieldsFromSegment();
        for (CompositeMappedFieldType type : this.compositeMappedFieldTypes) {
            this.compositeFieldSet.addAll(type.fields());
        }
        boolean success = false;
        try {
            SegmentWriteState consumerWriteState = Composite912DocValuesWriter.getSegmentWriteState(segmentWriteState);
            this.compositeDocValuesConsumer = LuceneDocValuesConsumerFactory.getDocValuesConsumerForCompositeCodec(consumerWriteState, "Composite912DocValuesData", "cidvd", "Composite912DocValuesMetadata", "cidvm");
            String dataFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)"cid");
            this.dataOut = this.state.directory.createOutput(dataFileName, this.state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.dataOut, (String)"Composite912FormatData", (int)0, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
            String metaFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)"cim");
            this.metaOut = this.state.directory.createOutput(metaFileName, this.state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.metaOut, (String)"Composite912FormatMeta", (int)0, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
        this.segmentHasCompositeFields = !Collections.disjoint(this.segmentFieldSet, this.compositeFieldSet);
    }

    private void addStarTreeSupportedFieldsFromSegment() {
        for (FieldInfo fi : this.state.fieldInfos) {
            if (!DocValuesType.SORTED_NUMERIC.equals((Object)fi.getDocValuesType()) && !DocValuesType.SORTED_SET.equals((Object)fi.getDocValuesType()) && !fi.name.equals("_doc_count")) continue;
            this.segmentFieldSet.add(fi.name);
        }
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addNumericField(field, valuesProducer);
        if (this.mergeState.get() == null && this.segmentHasCompositeFields) {
            this.createCompositeIndicesIfPossible(valuesProducer, field);
        }
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addBinaryField(field, valuesProducer);
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedNumericField(field, valuesProducer);
        if (this.mergeState.get() == null && this.segmentHasCompositeFields) {
            this.createCompositeIndicesIfPossible(valuesProducer, field);
        }
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedSetField(field, valuesProducer);
        if (this.mergeState.get() == null && this.segmentHasCompositeFields) {
            this.createCompositeIndicesIfPossible(valuesProducer, field);
        }
        if (this.mergeState.get() != null && this.compositeFieldSet.contains(field.name)) {
            this.fieldDocIdSetIteratorMap.put(field.name, valuesProducer.getSortedSet(field));
        }
    }

    public void close() throws IOException {
        block7: {
            block6: {
                this.delegate.close();
                boolean success = false;
                try {
                    if (this.metaOut != null) {
                        this.metaOut.writeLong(-1L);
                        CodecUtil.writeFooter((IndexOutput)this.metaOut);
                    }
                    if (this.dataOut != null) {
                        CodecUtil.writeFooter((IndexOutput)this.dataOut);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.dataOut, this.metaOut, this.compositeDocValuesConsumer});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.dataOut, this.metaOut, this.compositeDocValuesConsumer});
                    }
                    this.dataOut = null;
                    this.metaOut = null;
                    this.compositeDocValuesConsumer = null;
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.dataOut, this.metaOut, this.compositeDocValuesConsumer});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.dataOut, this.metaOut, this.compositeDocValuesConsumer});
        }
        this.dataOut = null;
        this.metaOut = null;
        this.compositeDocValuesConsumer = null;
    }

    private void createCompositeIndicesIfPossible(DocValuesProducer valuesProducer, FieldInfo field) throws IOException {
        if (this.compositeFieldSet.isEmpty()) {
            return;
        }
        if (this.compositeFieldSet.contains(field.name)) {
            this.fieldProducerMap.put(field.name, valuesProducer);
            this.compositeFieldSet.remove(field.name);
        }
        this.segmentFieldSet.remove(field.name);
        if (this.segmentFieldSet.isEmpty()) {
            HashSet<String> compositeFieldSetCopy = new HashSet<String>(this.compositeFieldSet);
            for (String compositeField : compositeFieldSetCopy) {
                this.addDocValuesForEmptyField(compositeField);
            }
        }
        if (this.compositeFieldSet.isEmpty()) {
            try (StarTreesBuilder starTreesBuilder = new StarTreesBuilder(this.state, this.mapperService, this.fieldNumberAcrossCompositeFields);){
                starTreesBuilder.build(this.metaOut, this.dataOut, this.fieldProducerMap, this.compositeDocValuesConsumer);
            }
        }
    }

    private void addDocValuesForEmptyField(String compositeField) {
        if (compositeField.equals("_doc_count")) {
            this.fieldProducerMap.put(compositeField, (DocValuesProducer)new EmptyDocValuesProducer(){

                public NumericDocValues getNumeric(FieldInfo field) {
                    return DocValues.emptyNumeric();
                }
            });
        } else if (this.isSortedSetField(compositeField)) {
            this.fieldProducerMap.put(compositeField, (DocValuesProducer)new EmptyDocValuesProducer(){

                public SortedSetDocValues getSortedSet(FieldInfo field) {
                    return DocValues.emptySortedSet();
                }
            });
        } else if (this.isSortedNumericField(compositeField)) {
            this.fieldProducerMap.put(compositeField, (DocValuesProducer)new EmptyDocValuesProducer(){

                public SortedNumericDocValues getSortedNumeric(FieldInfo field) {
                    return DocValues.emptySortedNumeric();
                }
            });
        } else {
            throw new IllegalStateException(String.format(Locale.ROOT, "Unsupported DocValues field associated with the composite field : %s", compositeField));
        }
        this.compositeFieldSet.remove(compositeField);
    }

    private boolean isSortedSetField(String field) {
        MappedFieldType ft = this.mapperService.fieldType(field);
        assert (ft.isAggregatable());
        return ft.fielddataBuilder("", () -> {
            throw new UnsupportedOperationException("SearchLookup not available");
        }) instanceof SortedSetOrdinalsIndexFieldData.Builder;
    }

    private boolean isSortedNumericField(String field) {
        MappedFieldType ft = this.mapperService.fieldType(field);
        assert (ft.isAggregatable());
        return ft.fielddataBuilder("", () -> {
            throw new UnsupportedOperationException("SearchLookup not available");
        }) instanceof IndexFieldData.Builder;
    }

    public void merge(MergeState mergeState) throws IOException {
        this.mergeState.compareAndSet(null, mergeState);
        super.merge(mergeState);
        this.mergeCompositeFields(mergeState);
    }

    private void mergeCompositeFields(MergeState mergeState) throws IOException {
        this.mergeStarTreeFields(mergeState);
    }

    private void mergeStarTreeFields(MergeState mergeState) throws IOException {
        HashMap<String, List<StarTreeValues>> starTreeSubsPerField = new HashMap<String, List<StarTreeValues>>();
        for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            CompositeIndexReader reader = null;
            if (mergeState.docValuesProducers[i] == null) continue;
            if (mergeState.docValuesProducers[i] instanceof CompositeIndexReader) {
                reader = (CompositeIndexReader)mergeState.docValuesProducers[i];
            } else {
                Set<DocValuesProducer> docValuesProducers = DocValuesProducerUtil.getSegmentDocValuesProducers(mergeState.docValuesProducers[i]);
                for (DocValuesProducer docValuesProducer : docValuesProducers) {
                    List<CompositeIndexFieldInfo> compositeFieldInfo;
                    if (docValuesProducer instanceof CompositeIndexReader && !(compositeFieldInfo = (reader = (CompositeIndexReader)docValuesProducer).getCompositeIndexFields()).isEmpty()) break;
                }
            }
            if (reader == null) continue;
            List<CompositeIndexFieldInfo> compositeFieldInfo = reader.getCompositeIndexFields();
            for (CompositeIndexFieldInfo fieldInfo : compositeFieldInfo) {
                CompositeIndexValues compositeIndexValues;
                if (!fieldInfo.getType().equals((Object)CompositeMappedFieldType.CompositeFieldType.STAR_TREE) || !((compositeIndexValues = reader.getCompositeIndexValues(fieldInfo)) instanceof StarTreeValues)) continue;
                StarTreeValues starTreeValues = (StarTreeValues)compositeIndexValues;
                List fieldsList = starTreeSubsPerField.getOrDefault(fieldInfo.getField(), new ArrayList());
                fieldsList.add(starTreeValues);
                starTreeSubsPerField.put(fieldInfo.getField(), fieldsList);
            }
        }
        try (StarTreesBuilder starTreesBuilder = new StarTreesBuilder(this.state, this.mapperService, this.fieldNumberAcrossCompositeFields);){
            starTreesBuilder.buildDuringMerge(this.metaOut, this.dataOut, starTreeSubsPerField, this.compositeDocValuesConsumer);
        }
    }

    private static SegmentWriteState getSegmentWriteState(SegmentWriteState segmentWriteState) {
        SegmentInfo segmentInfo = new SegmentInfo(segmentWriteState.segmentInfo.dir, segmentWriteState.segmentInfo.getVersion(), segmentWriteState.segmentInfo.getMinVersion(), segmentWriteState.segmentInfo.name, Integer.MAX_VALUE, segmentWriteState.segmentInfo.getUseCompoundFile(), segmentWriteState.segmentInfo.getHasBlocks(), segmentWriteState.segmentInfo.getCodec(), segmentWriteState.segmentInfo.getDiagnostics(), segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentInfo.getAttributes(), segmentWriteState.segmentInfo.getIndexSort());
        return new SegmentWriteState(segmentWriteState.infoStream, segmentWriteState.directory, segmentInfo, segmentWriteState.fieldInfos, segmentWriteState.segUpdates, segmentWriteState.context, segmentWriteState.segmentSuffix);
    }
}

