/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.AliasesRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.Diffable;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiffable;
import org.opensearch.cluster.NamedDiffableValueSerializer;
import org.opensearch.cluster.applicationtemplates.SystemTemplateMetadata;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.cluster.metadata.ComponentTemplateMetadata;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.DataStreamMetadata;
import org.opensearch.cluster.metadata.DiffableStringMap;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexGraveyard;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.QueryGroup;
import org.opensearch.cluster.metadata.QueryGroupMetadata;
import org.opensearch.cluster.metadata.TemplatesMetadata;
import org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.Index;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedObjectNotFoundException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.gateway.MetadataStateFormat;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.plugins.MapperPlugin;

@PublicApi(since="1.0.0")
public class Metadata
implements Iterable<IndexMetadata>,
Diffable<Metadata>,
ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(Metadata.class);
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+$");
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Integer> DEFAULT_REPLICA_COUNT_SETTING = Setting.intSetting("cluster.default_number_of_replicas", 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock CLUSTER_CREATE_INDEX_BLOCK = new ClusterBlock(10, "cluster create-index blocked (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.CREATE_INDEX));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_CREATE_INDEX_BLOCK_SETTING = Setting.boolSetting("cluster.blocks.create_index", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String CONTEXT_MODE_API = XContentContext.API.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    public static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final CoordinationMetadata coordinationMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final DiffableStringMap hashesOfConsistentSettings;
    private final Map<String, IndexMetadata> indices;
    private final TemplatesMetadata templates;
    private final Map<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final String[] allIndices;
    private final String[] visibleIndices;
    private final String[] allOpenIndices;
    private final String[] visibleOpenIndices;
    private final String[] allClosedIndices;
    private final String[] visibleClosedIndices;
    private final SortedMap<String, IndexAbstraction> indicesLookup;
    private final Map<String, SortedMap<Long, String>> systemTemplatesLookup;
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetadataStateFormat<Metadata> FORMAT;

    public boolean isSegmentReplicationEnabled(String indexName) {
        return Optional.ofNullable(this.index(indexName)).map(indexMetadata -> ReplicationType.parseString(indexMetadata.getSettings().get("index.replication.type")).equals((Object)ReplicationType.SEGMENT)).orElse(false);
    }

    Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, CoordinationMetadata coordinationMetadata, Settings transientSettings, Settings persistentSettings, DiffableStringMap hashesOfConsistentSettings, Map<String, IndexMetadata> indices, Map<String, IndexTemplateMetadata> templates, Map<String, Custom> customs, String[] allIndices, String[] visibleIndices, String[] allOpenIndices, String[] visibleOpenIndices, String[] allClosedIndices, String[] visibleClosedIndices, SortedMap<String, IndexAbstraction> indicesLookup, Map<String, SortedMap<Long, String>> systemTemplatesLookup) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.coordinationMetadata = coordinationMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.builder().put(persistentSettings).put(transientSettings).build();
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.indices = Collections.unmodifiableMap(indices);
        this.customs = Collections.unmodifiableMap(customs);
        this.templates = new TemplatesMetadata(templates);
        int totalNumberOfShards = 0;
        int totalOpenIndexShards = 0;
        for (IndexMetadata cursor : indices.values()) {
            totalNumberOfShards += cursor.getTotalNumberOfShards();
            if (!IndexMetadata.State.OPEN.equals((Object)cursor.getState())) continue;
            totalOpenIndexShards += cursor.getTotalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.allIndices = allIndices;
        this.visibleIndices = visibleIndices;
        this.allOpenIndices = allOpenIndices;
        this.visibleOpenIndices = visibleOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.visibleClosedIndices = visibleClosedIndices;
        this.indicesLookup = indicesLookup;
        this.systemTemplatesLookup = systemTemplatesLookup;
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public Map<String, String> hashesOfConsistentSettings() {
        return this.hashesOfConsistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public boolean hasAlias(String alias) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.getIndicesLookup().get(alias);
        if (indexAbstraction != null) {
            return indexAbstraction.getType() == IndexAbstraction.Type.ALIAS;
        }
        return false;
    }

    public boolean equalsAliases(Metadata other) {
        for (IndexMetadata otherIndex : other.indices().values()) {
            IndexMetadata thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<String, IndexAbstraction> getIndicesLookup() {
        return this.indicesLookup;
    }

    public Map<String, List<AliasMetadata>> findAllAliases(String[] concreteIndices) {
        return this.findAliases(Strings.EMPTY_ARRAY, concreteIndices);
    }

    public Map<String, List<AliasMetadata>> findAliases(AliasesRequest aliasesRequest, String[] concreteIndices) {
        return this.findAliases(aliasesRequest.aliases(), concreteIndices);
    }

    private Map<String, List<AliasMetadata>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return Map.of();
        }
        String[] patterns = new String[aliases.length];
        boolean[] include = new boolean[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias.charAt(0) == '-') {
                patterns[i] = alias.substring(1);
                include[i] = false;
                continue;
            }
            patterns[i] = alias;
            include[i] = true;
        }
        boolean matchAllAliases = patterns.length == 0;
        HashMap<String, List<AliasMetadata>> mapBuilder = new HashMap<String, List<AliasMetadata>>();
        for (String index : concreteIndices) {
            IndexMetadata indexMetadata = this.indices.get(index);
            ArrayList<AliasMetadata> filteredValues = new ArrayList<AliasMetadata>();
            for (AliasMetadata value : indexMetadata.getAliases().values()) {
                boolean matched = matchAllAliases;
                String alias = value.alias();
                for (int i = 0; i < patterns.length; ++i) {
                    if (include[i]) {
                        if (matched) continue;
                        String pattern = patterns[i];
                        matched = ALL.equals(pattern) || Regex.simpleMatch(pattern, alias);
                        continue;
                    }
                    if (!matched) continue;
                    matched = !Regex.simpleMatch(patterns[i], alias);
                }
                if (!matched) continue;
                filteredValues.add(value);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasMetadata::alias));
            mapBuilder.put(index, Collections.unmodifiableList(filteredValues));
        }
        return mapBuilder;
    }

    public Map<String, MappingMetadata> findMappings(String[] concreteIndices, Function<String, Predicate<String>> fieldFilter) throws IOException {
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return Map.of();
        }
        HashMap indexMapBuilder = new HashMap();
        Arrays.stream(concreteIndices).filter(this.indices.keySet()::contains).forEach(idx -> indexMapBuilder.put(idx, Metadata.filterFields(this.indices.get(idx).mapping(), (Predicate)fieldFilter.apply((String)idx))));
        return Collections.unmodifiableMap(indexMapBuilder);
    }

    public Map<String, IndexAbstraction.DataStream> findDataStreams(String[] concreteIndices) {
        assert (concreteIndices != null);
        HashMap<String, IndexAbstraction.DataStream> builder = new HashMap<String, IndexAbstraction.DataStream>();
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            assert (index != null);
            assert (index.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (index.getParentDataStream() == null) continue;
            builder.put(indexName, index.getParentDataStream());
        }
        return Collections.unmodifiableMap(builder);
    }

    private static MappingMetadata filterFields(MappingMetadata mappingMetadata, Predicate<String> fieldPredicate) {
        if (mappingMetadata == null) {
            return MappingMetadata.EMPTY_MAPPINGS;
        }
        if (fieldPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
            return mappingMetadata;
        }
        Map sourceAsMap = (Map)XContentHelper.convertToMap(mappingMetadata.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetadata.type()) ? (Map)sourceAsMap.get(mappingMetadata.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetadata;
        }
        Metadata.filterFields("", properties, fieldPredicate);
        return new MappingMetadata(mappingMetadata.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != MapperPlugin.NOOP_FIELD_PREDICATE);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = Metadata.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = Metadata.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = Metadata.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + String.valueOf(value.getClass()) + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (subFields.size() > 0);
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.size() == 0;
    }

    private static String mergePaths(String path, String field) {
        if (path.length() == 0) {
            return field;
        }
        return path + "." + field;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteVisibleIndices() {
        return this.visibleIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteVisibleOpenIndices() {
        return this.visibleOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteVisibleClosedIndices() {
        return this.visibleClosedIndices;
    }

    public String resolveWriteIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        IndexMetadata writeIndex = result.getWriteIndex();
        if (writeIndex == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetadata aliasMd = writeIndex.getAliases().get(result.getName());
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        AliasMetadata aliasMd;
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)result;
        if (result.getIndices().size() > 1) {
            this.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        if ((aliasMd = alias.getFirstAliasMetadata()).indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    private void rejectSingleIndexOperation(String aliasOrIndex, IndexAbstraction result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (IndexMetadata indexMetadata : result.getIndices()) {
            indexNames[i++] = indexMetadata.getIndex().getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        return metadata != null && metadata.getIndexUUID().equals(index.getUUID());
    }

    public boolean hasConcreteIndex(String index) {
        return this.getIndicesLookup().containsKey(index);
    }

    public IndexMetadata index(String index) {
        return this.indices.get(index);
    }

    public IndexMetadata index(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null && metadata.getIndexUUID().equals(index.getUUID())) {
            return metadata;
        }
        return null;
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata;
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null) {
            if (metadata.getIndexUUID().equals(index.getUUID())) {
                return metadata;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metadata.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index);
    }

    public Map<String, IndexMetadata> indices() {
        return this.indices;
    }

    public Map<String, IndexMetadata> getIndices() {
        return this.indices();
    }

    public Map<String, IndexTemplateMetadata> templates() {
        return this.templates.getTemplates();
    }

    public Map<String, IndexTemplateMetadata> getTemplates() {
        return this.templates();
    }

    public TemplatesMetadata templatesMetadata() {
        return this.templates;
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return Optional.ofNullable((ComponentTemplateMetadata)this.custom("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, SortedMap<Long, String>> systemTemplatesLookup() {
        return this.systemTemplatesLookup;
    }

    public Map<String, ComposableIndexTemplate> templatesV2() {
        return Optional.ofNullable((ComposableIndexTemplateMetadata)this.custom("index_template")).map(ComposableIndexTemplateMetadata::indexTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, DataStream> dataStreams() {
        return Optional.ofNullable((DataStreamMetadata)this.custom("data_stream")).map(DataStreamMetadata::dataStreams).orElse(Collections.emptyMap());
    }

    public Map<String, QueryGroup> queryGroups() {
        return Optional.ofNullable((QueryGroupMetadata)this.custom("queryGroups")).map(QueryGroupMetadata::queryGroups).orElse(Collections.emptyMap());
    }

    public DecommissionAttributeMetadata decommissionAttributeMetadata() {
        return (DecommissionAttributeMetadata)this.custom("decommissionedAttribute");
    }

    public Map<String, Custom> customs() {
        return this.customs;
    }

    public Map<String, Custom> getCustoms() {
        return this.customs();
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public WeightedRoutingMetadata weightedRoutingMetadata() {
        return (WeightedRoutingMetadata)this.custom("weighted_shard_routing");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public static boolean isAllTypes(String[] types) {
        return types == null || types.length == 0 || Metadata.isExplicitAllType(types);
    }

    public static boolean isExplicitAllType(String[] types) {
        return types != null && types.length == 1 && ALL.equals(types[0]);
    }

    public boolean routingRequired(String concreteIndex) {
        MappingMetadata mappingMetadata;
        IndexMetadata indexMetadata = this.indices.get(concreteIndex);
        if (indexMetadata != null && (mappingMetadata = indexMetadata.mapping()) != null) {
            return mappingMetadata.routingRequired();
        }
        return false;
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.values().iterator();
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!Metadata.isCoordinationMetadataEqual(metadata1, metadata2)) {
            return false;
        }
        if (!metadata1.hashesOfConsistentSettings.equals(metadata2.hashesOfConsistentSettings)) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        return Metadata.isGlobalResourcesMetadataEquals(metadata1, metadata2);
    }

    public static boolean isGlobalResourcesMetadataEquals(Metadata metadata1, Metadata metadata2) {
        if (!Metadata.isSettingsMetadataEqual(metadata1, metadata2)) {
            return false;
        }
        if (!Metadata.isTemplatesMetadataEqual(metadata1, metadata2)) {
            return false;
        }
        return Metadata.isCustomMetadataEqual(metadata1, metadata2);
    }

    public static boolean isCoordinationMetadataEqual(Metadata metadata1, Metadata metadata2) {
        return metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata);
    }

    public static boolean isSettingsMetadataEqual(Metadata metadata1, Metadata metadata2) {
        return metadata1.persistentSettings.equals(metadata2.persistentSettings);
    }

    public static boolean isTransientSettingsMetadataEqual(Metadata metadata1, Metadata metadata2) {
        return metadata1.transientSettings.equals(metadata2.transientSettings);
    }

    public static boolean isTemplatesMetadataEqual(Metadata metadata1, Metadata metadata2) {
        return metadata1.templates.equals(metadata2.templates);
    }

    public static boolean isHashesOfConsistentSettingsEqual(Metadata metadata1, Metadata metadata2) {
        return metadata1.hashesOfConsistentSettings.equals(metadata2.hashesOfConsistentSettings);
    }

    public static boolean isCustomMetadataEqual(Metadata metadata1, Metadata metadata2) {
        int customCount1 = 0;
        for (Map.Entry<String, Custom> cursor : metadata1.customs.entrySet()) {
            if (!cursor.getValue().context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!cursor.getValue().equals(metadata2.custom(cursor.getKey()))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (Custom cursor : metadata2.customs.values()) {
            if (!cursor.context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        return new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            builder.clusterUUIDCommitted = in.readBoolean();
        }
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            builder.coordinationMetadata(new CoordinationMetadata(in));
        }
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_3_0)) {
            builder.hashesOfConsistentSettings(DiffableStringMap.readFrom(in));
        }
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetadata.readFrom(in), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetadata.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetadata = (Custom)in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            out.writeBoolean(this.clusterUUIDCommitted);
        }
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            this.coordinationMetadata.writeTo(out);
        }
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_3_0)) {
            this.hashesOfConsistentSettings.writeTo(out);
        }
        out.writeVInt(this.indices.size());
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out);
        }
        this.templates.writeTo(out);
        int numberOfCustoms = 0;
        for (Custom cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, cursor)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (Custom cursor : this.customs.values()) {
            if (!ClusterState.FeatureAware.shouldSerialize(out, cursor)) continue;
            out.writeNamedWriteable((NamedWriteable)cursor);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put(CONTEXT_MODE_PARAM, CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetadataStateFormat<Metadata>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, Metadata state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public Metadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    @PublicApi(since="1.0.0")
    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContentFragment,
    ClusterState.FeatureAware {
        public EnumSet<XContentContext> context();

        public static Custom fromXContent(XContentParser parser, String name) throws IOException {
            return (Custom)parser.namedObject(Custom.class, name, null);
        }
    }

    @PublicApi(since="1.0.0")
    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private final long version;
        private final String clusterUUID;
        private boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<DiffableStringMap> hashesOfConsistentSettings;
        private final Diff<Map<String, IndexMetadata>> indices;
        private final Diff<Map<String, IndexTemplateMetadata>> templates;
        private final Diff<Map<String, Custom>> customs;
        private static final DiffableUtils.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.hashesOfConsistentSettings = after.hashesOfConsistentSettings.diff(before.hashesOfConsistentSettings);
            this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
            this.templates = DiffableUtils.diff(before.templates.getTemplates(), after.templates.getTemplates(), DiffableUtils.getStringKeySerializer());
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        MetadataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                this.clusterUUIDCommitted = in.readBoolean();
            }
            this.version = in.readLong();
            this.coordinationMetadata = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0) ? new CoordinationMetadata(in) : CoordinationMetadata.EMPTY_METADATA;
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.hashesOfConsistentSettings = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_3_0) ? DiffableStringMap.readDiffFrom(in) : DiffableStringMap.DiffableStringMapDiff.EMPTY;
            this.indices = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                out.writeBoolean(this.clusterUUIDCommitted);
            }
            out.writeLong(this.version);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
                this.coordinationMetadata.writeTo(out);
            }
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_3_0)) {
                this.hashesOfConsistentSettings.writeTo(out);
            }
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
        }

        @Override
        public Metadata apply(Metadata part) {
            Builder builder = Metadata.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.hashesOfConsistentSettings(this.hashesOfConsistentSettings.apply(part.hashesOfConsistentSettings));
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates.getTemplates()));
            builder.customs(this.customs.apply(part.customs));
            return builder.build();
        }
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = Settings.Builder.EMPTY_SETTINGS;
        private DiffableStringMap hashesOfConsistentSettings = new DiffableStringMap(Collections.emptyMap());
        private final Map<String, IndexMetadata> indices;
        private final Map<String, IndexTemplateMetadata> templates;
        private final Map<String, Custom> customs;
        private final Metadata previousMetadata;
        private Map<String, SortedMap<Long, String>> systemTemplatesLookup;

        public Builder() {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.indices = new HashMap<String, IndexMetadata>();
            this.templates = new HashMap<String, IndexTemplateMetadata>();
            this.customs = new HashMap<String, Custom>();
            this.previousMetadata = null;
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.hashesOfConsistentSettings = metadata.hashesOfConsistentSettings;
            this.version = metadata.version;
            this.indices = new HashMap<String, IndexMetadata>(metadata.indices);
            this.templates = new HashMap<String, IndexTemplateMetadata>(metadata.templates.getTemplates());
            this.customs = new HashMap<String, Custom>(metadata.customs);
            this.previousMetadata = metadata;
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            if (this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata) {
                return this;
            }
            if (incrementVersion) {
                indexMetadata = IndexMetadata.builder(indexMetadata).version(indexMetadata.getVersion() + 1L).build();
            }
            this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            return this;
        }

        public IndexMetadata get(String index) {
            return this.indices.get(index);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getName());
            if (indexMetadata != null) {
                if (indexMetadata.getIndexUUID().equals(index.getUUID())) {
                    return indexMetadata;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetadata.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(Map<String, IndexMetadata> indices) {
            this.indices.putAll(indices);
            return this;
        }

        public Builder put(IndexTemplateMetadata.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(Map<String, IndexTemplateMetadata> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Builder templates(TemplatesMetadata templatesMetadata) {
            this.templates.clear();
            this.templates.putAll(templatesMetadata.getTemplates());
            return this;
        }

        public Builder put(String name, ComponentTemplate componentTemplate) {
            Objects.requireNonNull(componentTemplate, "it is invalid to add a null component template: " + name);
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.put(name, componentTemplate);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeComponentTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.customs.put("component_template", new ComponentTemplateMetadata(componentTemplates));
            return this;
        }

        public Builder indexTemplates(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(indexTemplates));
            return this;
        }

        public Builder put(String name, ComposableIndexTemplate indexTemplate) {
            Objects.requireNonNull(indexTemplate, "it is invalid to add a null index template: " + name);
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.put(name, indexTemplate);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeIndexTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public DataStream dataStream(String dataStreamName) {
            return ((DataStreamMetadata)this.customs.get("data_stream")).dataStreams().get(dataStreamName);
        }

        public Builder dataStreams(Map<String, DataStream> dataStreams) {
            this.customs.put("data_stream", new DataStreamMetadata(dataStreams));
            return this;
        }

        public Builder put(DataStream dataStream) {
            Objects.requireNonNull(dataStream, "it is invalid to add a null data stream");
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.put(dataStream.getName(), dataStream);
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams));
            return this;
        }

        public Builder removeDataStream(String name) {
            Map existingDataStreams = Optional.ofNullable((DataStreamMetadata)this.customs.get("data_stream")).map(dsmd -> new HashMap<String, DataStream>(dsmd.dataStreams())).orElse(new HashMap());
            existingDataStreams.remove(name);
            this.customs.put("data_stream", new DataStreamMetadata(existingDataStreams));
            return this;
        }

        public Builder queryGroups(Map<String, QueryGroup> queryGroups) {
            this.customs.put("queryGroups", new QueryGroupMetadata(queryGroups));
            return this;
        }

        public Builder put(QueryGroup queryGroup) {
            Objects.requireNonNull(queryGroup, "queryGroup should not be null");
            HashMap<String, QueryGroup> existing = new HashMap<String, QueryGroup>(this.getQueryGroups());
            existing.put(queryGroup.get_id(), queryGroup);
            return this.queryGroups(existing);
        }

        public Builder remove(QueryGroup queryGroup) {
            Objects.requireNonNull(queryGroup, "queryGroup should not be null");
            HashMap<String, QueryGroup> existing = new HashMap<String, QueryGroup>(this.getQueryGroups());
            existing.remove(queryGroup.get_id());
            return this.queryGroups(existing);
        }

        private Map<String, QueryGroup> getQueryGroups() {
            return Optional.ofNullable(this.customs.get("queryGroups")).map(o -> (QueryGroupMetadata)o).map(QueryGroupMetadata::queryGroups).orElse(Collections.emptyMap());
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(Map<String, Custom> customs) {
            StreamSupport.stream(Spliterators.spliterator(customs.entrySet(), 0), false).forEach(cursor -> Objects.requireNonNull((Custom)cursor.getValue(), (String)cursor.getKey()));
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            IndexGraveyard graveyard = (IndexGraveyard)this.getCustom("index-graveyard");
            return graveyard;
        }

        public Builder decommissionAttributeMetadata(DecommissionAttributeMetadata decommissionAttributeMetadata) {
            this.putCustom("decommissionedAttribute", decommissionAttributeMetadata);
            return this;
        }

        public DecommissionAttributeMetadata decommissionAttributeMetadata() {
            return (DecommissionAttributeMetadata)this.getCustom("decommissionedAttribute");
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keySet().toArray(new String[0]);
            }
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Builder updateNumberOfSearchReplicas(int numberOfSearchReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfSearchReplicas(numberOfSearchReplicas));
            }
            return this;
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public DiffableStringMap hashesOfConsistentSettings() {
            return this.hashesOfConsistentSettings;
        }

        public Builder hashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder hashesOfConsistentSettings(Map<String, String> hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = new DiffableStringMap(hashesOfConsistentSettings);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public Metadata build() {
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.customs.get("data_stream");
            DataStreamMetadata previousDataStreamMetadata = this.previousMetadata != null ? (DataStreamMetadata)this.previousMetadata.customs.get("data_stream") : null;
            this.buildSystemTemplatesLookup();
            boolean recomputeRequiredforIndicesLookups = this.previousMetadata == null || !this.indices.equals(this.previousMetadata.indices) || previousDataStreamMetadata != null && !previousDataStreamMetadata.equals(dataStreamMetadata) || dataStreamMetadata != null && !dataStreamMetadata.equals(previousDataStreamMetadata);
            return !recomputeRequiredforIndicesLookups ? this.buildMetadataWithPreviousIndicesLookups() : this.buildMetadataWithRecomputedIndicesLookups();
        }

        private void buildSystemTemplatesLookup() {
            if (this.previousMetadata != null && Objects.equals(this.previousMetadata.customs.get("component_template"), this.customs.get("component_template"))) {
                this.systemTemplatesLookup = Collections.unmodifiableMap(this.previousMetadata.systemTemplatesLookup);
            } else {
                this.systemTemplatesLookup = new HashMap<String, SortedMap<Long, String>>();
                Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElseGet(Collections::emptyMap).forEach((k, v) -> {
                    if (MetadataIndexTemplateService.isSystemTemplate(v)) {
                        SystemTemplateMetadata templateMetadata = SystemTemplateMetadata.fromComponentTemplate(k);
                        this.systemTemplatesLookup.compute(templateMetadata.name(), (ik, iv) -> {
                            if (iv == null) {
                                iv = new TreeMap<Long, String>();
                            }
                            iv.put(templateMetadata.version(), k);
                            return iv;
                        });
                    }
                });
            }
        }

        protected Metadata buildMetadataWithPreviousIndicesLookups() {
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.hashesOfConsistentSettings, this.indices, this.templates, this.customs, Arrays.copyOf(this.previousMetadata.allIndices, this.previousMetadata.allIndices.length), Arrays.copyOf(this.previousMetadata.visibleIndices, this.previousMetadata.visibleIndices.length), Arrays.copyOf(this.previousMetadata.allOpenIndices, this.previousMetadata.allOpenIndices.length), Arrays.copyOf(this.previousMetadata.visibleOpenIndices, this.previousMetadata.visibleOpenIndices.length), Arrays.copyOf(this.previousMetadata.allClosedIndices, this.previousMetadata.allClosedIndices.length), Arrays.copyOf(this.previousMetadata.visibleClosedIndices, this.previousMetadata.visibleClosedIndices.length), Collections.unmodifiableSortedMap(this.previousMetadata.indicesLookup), this.systemTemplatesLookup);
        }

        protected Metadata buildMetadataWithRecomputedIndicesLookups() {
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            ArrayList<Object> visibleIndices = new ArrayList<Object>();
            ArrayList<Object> allOpenIndices = new ArrayList<Object>();
            ArrayList<Object> visibleOpenIndices = new ArrayList<Object>();
            ArrayList<Object> allClosedIndices = new ArrayList<Object>();
            ArrayList<Object> visibleClosedIndices = new ArrayList<Object>();
            HashSet allAliases = new HashSet();
            for (IndexMetadata indexMetadata : this.indices.values()) {
                boolean visible;
                String name = indexMetadata.getIndex().getName();
                boolean added = allIndices.add(name);
                assert (added) : "double index named [" + (String)name + "]";
                boolean bl = visible = IndexMetadata.INDEX_HIDDEN_SETTING.get(indexMetadata.getSettings()) == false;
                if (visible) {
                    visibleIndices.add(name);
                }
                if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                    allOpenIndices.add(name);
                    if (visible) {
                        visibleOpenIndices.add(name);
                    }
                } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    allClosedIndices.add(name);
                    if (visible) {
                        visibleClosedIndices.add(name);
                    }
                }
                indexMetadata.getAliases().keySet().iterator().forEachRemaining(allAliases::add);
            }
            HashSet<String> allDataStreams = new HashSet<String>();
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.customs.get("data_stream");
            if (dataStreamMetadata != null) {
                for (DataStream dataStream : dataStreamMetadata.dataStreams().values()) {
                    allDataStreams.add(dataStream.getName());
                }
            }
            HashSet aliasDuplicatesWithIndices = new HashSet(allAliases);
            aliasDuplicatesWithIndices.retainAll(allIndices);
            ArrayList<CallSite> duplicates = new ArrayList<CallSite>();
            if (!aliasDuplicatesWithIndices.isEmpty()) {
                for (IndexMetadata indexMetadata : this.indices.values()) {
                    for (Object alias : aliasDuplicatesWithIndices) {
                        if (!indexMetadata.getAliases().containsKey(alias)) continue;
                        duplicates.add((CallSite)((Object)((String)alias + " (alias of " + String.valueOf(indexMetadata.getIndex()) + ") conflicts with index")));
                    }
                }
            }
            HashSet aliasDuplicatesWithDataStreams = new HashSet(allAliases);
            aliasDuplicatesWithDataStreams.retainAll(allDataStreams);
            if (!aliasDuplicatesWithDataStreams.isEmpty()) {
                for (IndexMetadata indexMetadata : this.indices.values()) {
                    for (String alias : aliasDuplicatesWithDataStreams) {
                        if (!indexMetadata.getAliases().containsKey(alias)) continue;
                        duplicates.add((CallSite)((Object)(alias + " (alias of " + String.valueOf(indexMetadata.getIndex()) + ") conflicts with data stream")));
                    }
                }
            }
            HashSet hashSet = new HashSet(allDataStreams);
            hashSet.retainAll(allIndices);
            if (!hashSet.isEmpty()) {
                for (String dataStream : hashSet) {
                    duplicates.add((CallSite)((Object)("data stream [" + dataStream + "] conflicts with index")));
                }
            }
            if (duplicates.size() > 0) {
                throw new IllegalStateException("index, alias, and data stream names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
            SortedMap<String, IndexAbstraction> sortedMap = Collections.unmodifiableSortedMap(this.buildIndicesLookup());
            Builder.validateDataStreams(sortedMap, (DataStreamMetadata)this.customs.get("data_stream"));
            String[] allIndicesArray = allIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleIndicesArray = visibleIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allOpenIndicesArray = allOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleOpenIndicesArray = visibleOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allClosedIndicesArray = allClosedIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleClosedIndicesArray = visibleClosedIndices.toArray(Strings.EMPTY_ARRAY);
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.hashesOfConsistentSettings, this.indices, this.templates, this.customs, allIndicesArray, visibleIndicesArray, allOpenIndicesArray, visibleOpenIndicesArray, allClosedIndicesArray, visibleClosedIndicesArray, sortedMap, this.systemTemplatesLookup);
        }

        private SortedMap<String, IndexAbstraction> buildIndicesLookup() {
            TreeMap<String, IndexAbstraction> indicesLookup = new TreeMap<String, IndexAbstraction>();
            HashMap<String, DataStream> indexToDataStreamLookup = new HashMap<String, DataStream>();
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.customs.get("data_stream");
            if (dataStreamMetadata != null && this.indices.size() > 0) {
                for (DataStream dataStream : dataStreamMetadata.dataStreams().values()) {
                    List<IndexMetadata> backingIndices = dataStream.getIndices().stream().map(index -> this.indices.get(index.getName())).collect(Collectors.toList());
                    assert (!backingIndices.isEmpty());
                    assert (!backingIndices.contains(null));
                    IndexAbstraction existing = indicesLookup.put(dataStream.getName(), new IndexAbstraction.DataStream(dataStream, backingIndices));
                    assert (existing == null) : "duplicate data stream for " + dataStream.getName();
                    for (Index i : dataStream.getIndices()) {
                        indexToDataStreamLookup.put(i.getName(), dataStream);
                    }
                }
            }
            for (IndexMetadata indexMetadata : this.indices.values()) {
                IndexAbstraction.Index index2;
                DataStream parent = (DataStream)indexToDataStreamLookup.get(indexMetadata.getIndex().getName());
                if (parent != null) {
                    assert (parent.getIndices().contains(indexMetadata.getIndex()));
                    index2 = new IndexAbstraction.Index(indexMetadata, (IndexAbstraction.DataStream)indicesLookup.get(parent.getName()));
                } else {
                    index2 = new IndexAbstraction.Index(indexMetadata);
                }
                IndexAbstraction existing = indicesLookup.put(indexMetadata.getIndex().getName(), index2);
                assert (existing == null) : "duplicate for " + String.valueOf(indexMetadata.getIndex());
                for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                    indicesLookup.compute(aliasMetadata.getAlias(), (aliasName, alias) -> {
                        if (alias == null) {
                            return new IndexAbstraction.Alias(aliasMetadata, indexMetadata);
                        }
                        assert (alias.getType() == IndexAbstraction.Type.ALIAS) : alias.getClass().getName();
                        ((IndexAbstraction.Alias)alias).addIndex(indexMetadata);
                        return alias;
                    });
                }
            }
            indicesLookup.values().stream().filter(aliasOrIndex -> aliasOrIndex.getType() == IndexAbstraction.Type.ALIAS).forEach(alias -> ((IndexAbstraction.Alias)alias).computeAndValidateAliasProperties());
            return indicesLookup;
        }

        static void validateDataStreams(SortedMap<String, IndexAbstraction> indicesLookup, @Nullable DataStreamMetadata dsMetadata) {
            if (dsMetadata != null) {
                for (DataStream ds : dsMetadata.dataStreams().values()) {
                    String prefix = ".ds-" + ds.getName() + "-";
                    Set conflicts = indicesLookup.subMap(prefix, ".ds-" + ds.getName() + ".").keySet().stream().filter(s -> NUMBER_PATTERN.matcher(s.substring(prefix.length())).matches()).filter(s -> (long)IndexMetadata.parseIndexNameCounter(s) > ds.getGeneration()).collect(Collectors.toSet());
                    if (conflicts.size() <= 0) continue;
                    throw new IllegalStateException("data stream [" + ds.getName() + "] could create backing indices that conflict with " + conflicts.size() + " existing index(s) or alias(s) including '" + (String)conflicts.iterator().next() + "'");
                }
            }
        }

        public static void toXContent(Metadata metadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            XContentContext context = XContentContext.valueOf(params.param(Metadata.CONTEXT_MODE_PARAM, CONTEXT_MODE_API));
            if (context == XContentContext.API) {
                builder.startObject("metadata");
            } else {
                builder.startObject("meta-data");
                builder.field("version", metadata.version());
            }
            builder.field("cluster_uuid", metadata.clusterUUID);
            builder.field("cluster_uuid_committed", metadata.clusterUUIDCommitted);
            builder.startObject("cluster_coordination");
            metadata.coordinationMetadata().toXContent(builder, params);
            builder.endObject();
            if (context != XContentContext.API && !metadata.persistentSettings().isEmpty()) {
                builder.startObject("settings");
                metadata.persistentSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                builder.endObject();
            }
            builder.startObject("templates");
            metadata.templatesMetadata().toXContent(builder, params);
            builder.endObject();
            if (context == XContentContext.API) {
                builder.startObject("indices");
                for (IndexMetadata indexMetadata : metadata) {
                    IndexMetadata.Builder.toXContent(indexMetadata, builder, params);
                }
                builder.endObject();
            }
            for (Map.Entry entry : metadata.customs().entrySet()) {
                if (!((Custom)entry.getValue()).context().contains((Object)context)) continue;
                builder.startObject((String)entry.getKey());
                ((Custom)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static Metadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Expected a field name but got " + String.valueOf(token));
                    }
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(parser.currentName())) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + String.valueOf(token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetadata.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("hashes_of_consistent_settings".equals(currentFieldName)) {
                        builder.hashesOfConsistentSettings(parser.mapStrings());
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        builder.templates(TemplatesMetadata.fromXContent(parser));
                        continue;
                    }
                    try {
                        Custom custom = Custom.fromXContent(parser, currentFieldName);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            return builder.build();
        }
    }
}

